/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.mods.adhooks.client.RopeRenderer;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HookShotRenderer
extends EntityRenderer<HookShot> {
    public HookShotRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void renderHook(HookShot hookShot, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(partialTicks);
        double pixel = 0.0625;
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + shotRotation.yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(shotRotation.pitch));
        if (hookType == HookType.WEB) {
            matrixStack.func_227861_a_(0.0, -0.1, 0.0);
        } else {
            matrixStack.func_227861_a_(-0.03125, 0.0, -0.4);
        }
        ItemStack hook = hookType == HookType.WEB ? Items.field_221672_ax.func_190903_i() : hookType.hook.func_190903_i();
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(hook, ItemCameraTransforms.TransformType.GROUND, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }

    public void render(HookShot hookShot, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (!hookShot.isHookingEntity()) {
            this.renderHook(hookShot, yaw, partialTicks, matrixStack, buffer, packedLight);
        }
        new RopeRenderer(hookShot, this.func_177068_d(), buffer, matrixStack, packedLight).render(partialTicks);
        super.func_225623_a_((Entity)hookShot, yaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getEntityTexture(HookShot entity) {
        return AtlasTexture.field_110575_b;
    }
}

