/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.motion.MotionController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;

public class BoostUpMsg
extends ForgeNetMsg<BoostUpMsg> {
    public float maxStrengthFactor = 1.2f;
    public float strength;

    public BoostUpMsg() {
    }

    public BoostUpMsg(float strength) {
        this.strength = strength * MotionController.mainFactor;
    }

    public void sendTo(ServerPlayerEntity player) {
        AdHooks.getInstance().getConnection().sendToPlayer((Object)this, player);
    }

    public BoostUpMsg create() {
        return new BoostUpMsg();
    }

    public void handle(World world, PlayerEntity player) {
        double maxMotionY;
        double playerMotionY = player.func_213322_ci().func_82617_b();
        double newMotionY = playerMotionY + (double)this.strength;
        if (newMotionY > (maxMotionY = (double)(this.maxStrengthFactor * this.strength))) {
            newMotionY = Math.max(playerMotionY, maxMotionY);
        }
        Vect3d newMotion = ForgeEntity.getMotion((Entity)player).withY(newMotionY);
        ForgeEntity.setMotion((Entity)player, (Vect3d)newMotion);
    }
}

