/*
 * Decompiled with CFR 0.152.
 */
package com.github.thegoldcrayon.tgcropesmod.container;

import com.github.thegoldcrayon.tgcropesmod.init.ModRegistry;
import com.github.thegoldcrayon.tgcropesmod.tileentity.DryingRackTileEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class DryingRackContainer
extends Container {
    public final DryingRackTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;

    public DryingRackContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, DryingRackContainer.getTileEntity(playerInventory, data));
    }

    public DryingRackContainer(int windowId, PlayerInventory playerInventory, DryingRackTileEntity tileEntity) {
        super((ContainerType)ModRegistry.DRYING_RACK_CONTAINER_TYPE.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 0, 26, 13));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 1, 62, 13));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 2, 98, 13));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 3, 134, 13));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 4, 26, 57));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 5, 62, 57));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 6, 98, 57));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 7, 134, 57));
        int playerInventoryStartX = 8;
        int playerInventoryStartY = 84;
        int slotSizePlusBorder = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)playerInventory, 9 + row * 9 + column, 8 + column * 18, 84 + row * 18));
            }
        }
        int playerHotbarY = 142;
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)playerInventory, column, 8 + column * 18, 142));
        }
    }

    private static DryingRackTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof DryingRackTileEntity) {
            return (DryingRackTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            returnStack = slotStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(slotStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == returnStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return returnStack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return DryingRackContainer.func_216963_a((IWorldPosCallable)this.canInteractWithCallable, (PlayerEntity)playerIn, (Block)((Block)ModRegistry.DRYING_RACK.get()));
    }
}

