/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.PregenConfig;
import pregenerator.client.ClientHandler;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.commands.PregenCommand;
import pregenerator.common.commands.arguments.CenterArgument;
import pregenerator.common.commands.arguments.RadiusArgument;
import pregenerator.common.commands.arguments.SuggestableEnumArgument;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.structures.StructureManager;
import pregenerator.common.tracker.ServerTracker;

@Mod(value="chunkpregen")
public class ChunkPregenerator {
    public static ChunkPregenerator INSTANCE;
    public static Logger LOGGER;

    public ChunkPregenerator() {
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        PregenConfig.INSTANCE.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)StructureManager.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ClientHandler.INSTANCE);
        ITask.init();
        IDeletionTask.init();
        IProcessorInfo.init();
        NetworkManager.INSTANCE.init();
        ServerTracker.INSTANCE.init();
        this.registerArguments();
    }

    public void registerArguments() {
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_coord", CenterArgument.class, (IArgumentSerializer)new ArgumentSerializer(CenterArgument::center));
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_radius", RadiusArgument.class, (IArgumentSerializer)new ArgumentSerializer(RadiusArgument::integer));
        ArgumentTypes.func_218136_a((String)"chunkpregen:pregen_enum", SuggestableEnumArgument.class, (IArgumentSerializer)new SuggestableEnumArgument.Serializer());
    }

    public void registerPermissions() {
        PermissionAPI.registerNode((String)"pregen.retrogen", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to set Retrogen Permissions");
        PermissionAPI.registerNode((String)"pregen.mass.deletion", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to remove Entities/TileEntities in mass");
        PermissionAPI.registerNode((String)"pregen.chunkscraping", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to scan the entire loaded world for detailed data");
        PermissionAPI.registerNode((String)"pregen.commands", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to use In-Gui-Commands");
        PermissionAPI.registerNode((String)"pregen.world_gui", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"allows to access the InGui WorldData");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientLoad(FMLClientSetupEvent event) {
        ClientHandler.INSTANCE.initClient();
    }

    @SubscribeEvent
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ServerManager.INSTANCE.init();
        this.registerPermissions();
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartingEvent event) {
        PregenCommand.registerCommand((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    static {
        LOGGER = LogManager.getLogger((String)"Chunk Pregenerator");
    }
}

