/*
 * Decompiled with CFR 0.152.
 */
package pregenerator;

import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import pregenerator.base.api.Align;

public class PregenConfig {
    public static final PregenConfig INSTANCE = new PregenConfig();
    ForgeConfigSpec generalConfig;
    public final ForgeConfigSpec.IntValue threadingRule;
    public final ForgeConfigSpec.BooleanValue agressiveGeneration;
    public final ForgeConfigSpec.IntValue playerLimit;
    public final ForgeConfigSpec.IntValue deletionTimeLimit;
    public final ForgeConfigSpec.BooleanValue tracker;
    public final ForgeConfigSpec.BooleanValue autoRestart;
    public final ForgeConfigSpec.BooleanValue pregenOverlay;
    public final ForgeConfigSpec.EnumValue<Align> pregenHAlign;
    public final ForgeConfigSpec.EnumValue<Align> pregenVAlign;
    public final ForgeConfigSpec.DoubleValue pregenZoom;
    public final ForgeConfigSpec.BooleanValue trackerOverlay;
    public final ForgeConfigSpec.EnumValue<Align> trackerHAlign;
    public final ForgeConfigSpec.EnumValue<Align> trackerVAlign;
    public final ForgeConfigSpec.DoubleValue trackerZoom;
    public final ForgeConfigSpec.ConfigValue<String> detailDimension;

    private PregenConfig() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("general");
        builder.comment("Defines how many Dimensions can be generated at the same time, this is due to thread limitations mcs worldgen has. 0 => Single Dimension, 1 => Up to 3 dimensions (Ensures each dimension has at least 2 threads), 2 => Up to 5 Dimensions (Dimensions will fight over CPU Threads due to limitations)");
        this.threadingRule = builder.defineInRange("Threading Rule", 0, 0, 2);
        builder.comment("Defines how the pregenerator processes the Chunks. True => will cause a lot more CPU/Server usage, but can be faster, False => more cpu friendly but can be slower. NOTE: Pregen without agressive pregeneration is already very fast. This is more if you have a overbuild server/cpu and want to maximize generation");
        this.agressiveGeneration = builder.define("Agressive Pregen", false);
        builder.comment("Defines how many Players have to be online for the Processor to Auto Pause, -1 = Disabled. It is Inclusive 2 = Allows 1 Player");
        this.playerLimit = builder.defineInRange("Player Limit", -1, -1, Integer.MAX_VALUE);
        builder.comment("Defines how many milliseconds the Chunk Deleter gets per tick");
        this.deletionTimeLimit = builder.defineInRange("Deletion Time", 10, 1, 1000);
        builder.comment("Defines if the pregenerator should automatically restart on server start. Automatically set to true when a task is running, and automatically set to false if no task is running");
        this.autoRestart = builder.define("auto-restart", false);
        builder.comment("Defines if the Profiler should run in the background or not");
        this.tracker = builder.define("enable-profiler", false);
        builder.pop();
        builder.push("client");
        builder.push("pregen-overlay");
        builder.comment("Defines if the Pregen Overlay should be enabled");
        this.pregenOverlay = builder.define("pregen-overlay", true);
        builder.comment("Defines the Horizontal Alignment of the UI, left to right");
        this.pregenHAlign = builder.defineEnum("horizontal-alignment", (Enum)Align.START);
        builder.comment("Defines the Vertical Alignment of the UI, top to bottom");
        this.pregenVAlign = builder.defineEnum("vertical-alignment", (Enum)Align.START);
        builder.comment("Defines the Scale of the Overlay");
        this.pregenZoom = builder.defineInRange("scale", 1.0, 0.1, 10.0);
        builder.pop();
        builder.push("profiler-overlay");
        builder.comment("Defines if the Profiler Overlay should be enabled");
        this.trackerOverlay = builder.define("profiler-overlay", true);
        builder.comment("Defines the Horizontal Alignment of the UI, left to right");
        this.trackerHAlign = builder.defineEnum("horizontal-alignment", (Enum)Align.START);
        builder.comment("Defines the Vertical Alignment of the UI, top to bottom");
        this.trackerVAlign = builder.defineEnum("vertical-alignment", (Enum)Align.START);
        builder.comment("Defines the Scale of the Overlay");
        this.trackerZoom = builder.defineInRange("scale", 1.0, 0.1, 10.0);
        builder.comment("Reference to save which dimension is currently detailed");
        this.detailDimension = builder.define("detailed-dimension", (Object)DimensionType.field_223227_a_.getRegistryName().toString());
        builder.pop();
        builder.pop();
        this.generalConfig = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.generalConfig, "PregenConfig.toml");
    }

    public void init() {
    }
}

