/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import pregenerator.client.ProcessorRenderer;
import pregenerator.client.TrackerRenderer;
import pregenerator.client.gui.PregenScreen;
import pregenerator.client.preview.PreviewScreen;

public class ClientHandler {
    public static final ClientHandler INSTANCE = new ClientHandler();
    public ProcessorRenderer processor = new ProcessorRenderer();
    public TrackerRenderer tracker = new TrackerRenderer();
    @OnlyIn(value=Dist.CLIENT)
    KeyBinding uiKey;

    public void onInfoPacketReceived(byte[] data) {
        this.processor.onInfoPacketReceived(data);
    }

    public void onTrackerPacketReceived(byte[] data) {
        this.tracker.onTrackerInfoReceived(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        this.uiKey = new KeyBinding("Options Gui", 73, "Chunk-Pregenerator");
        ClientRegistry.registerKeyBinding((KeyBinding)this.uiKey);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof CreateWorldScreen) {
            int width = event.getGui().width / 2;
            event.addWidget((Widget)new ExtendedButton(width - 155, 187, 72, 20, TextFormatting.GOLD + "Preview", T -> Minecraft.func_71410_x().func_147108_a((Screen)new PreviewScreen((CreateWorldScreen)event.getGui()))));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.uiKey.func_151470_d() && mc.field_71462_r == null) {
            mc.func_147108_a((Screen)new PregenScreen());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUIRenderer(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        this.processor.onUIRenderer(event);
        this.tracker.onUIRenderer(event);
        GlStateManager.func_227734_k_();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUIUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        this.processor.update();
        this.tracker.update();
    }
}

