/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui.commands;

import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.dimension.DimensionType;
import pregenerator.base.impl.BaseCommandScreen;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.SquareTask;
import pregenerator.common.networking.command.GenerationPacket;
import pregenerator.common.utils.misc.GenShape;

public class SimpleGenScreen
extends BaseCommandScreen {
    int radius = 100;
    int centerX;
    int centerZ;

    @Override
    public boolean usesDimension() {
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.registerButton(-40, 90, 80, 20, "Back", this::back);
        this.shapeButton = this.registerButton(-180, -60, 160, 20, "Shape: " + this.getShapeName(), this::toggleShape);
        this.registerSlider(20, -60, 160, 20, "Radius: ", " Chunks", 1.0, 25000.0, 100.0, T -> {
            this.radius = T.getValueInt();
        }).setScrollEffect(1.0);
        this.registerSlider(-180, -30, 160, 20, "Center X: ", " Chunk", -1000.0, 1000.0, 0.0, T -> {
            this.centerX = T.getValueInt();
        }).setScrollEffect(1.0);
        this.registerSlider(20, -30, 160, 20, "Center Z: ", " Chunk", -1000.0, 1000.0, 0.0, T -> {
            this.centerZ = T.getValueInt();
        }).setScrollEffect(1.0);
        this.dimensionButton = this.registerButton(-180, 0, 160, 20, "Dim: " + this.getDimensionName(), this::toggleDimension);
        this.generationButton = this.registerButton(20, 0, 160, 20, "GenType: " + this.getGenerationName(), this::toggleGeneration);
        this.dimensionButton.active = false;
        this.registerText(-40, 35, 80, 20, "").func_212954_a(this::setName);
        this.startButton = this.registerButton(-40, 60, 80, 20, "Pregen!", this::pregen);
        this.startButton.active = false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.drawCenterText("Simple Generation", 0, -99, -1);
        this.drawText("Task Name: ", -40, 25, -1);
    }

    protected void pregen(Button button) {
        if (this.taskName == null || this.taskName.length() <= 0 || this.dimensionIndex < 0 || this.dimensionIndex >= this.dimensions.size()) {
            return;
        }
        this.sendToServer(new GenerationPacket(this.createGenTask()));
        this.minecraft.func_147108_a(null);
    }

    @Override
    public IBaseTask<?> createTask(String name, DimensionType type, GenShape shape, int genType) {
        return shape == GenShape.SQUARE ? new SquareTask(name, type, genType, new ChunkPos(this.centerX, this.centerY), this.radius) : new CircleTask(name, type, genType, new ChunkPos(this.centerX, this.centerY), this.radius);
    }
}

