/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.info;

import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.base.api.Align;
import pregenerator.base.api.IRenderHelper;
import pregenerator.client.info.IProcessorInfo;
import pregenerator.common.generator.ChunkLogger;

public class TrackerInfo
implements IProcessorInfo {
    long totalMemory;
    long maxMemory;
    long freeMemory;
    int averagePackets;
    int exactPackets;
    long averageServerLag;
    long exactServerLag;
    Object2LongMap<DimensionType> dimensionLag = new Object2LongLinkedOpenHashMap();
    WorldInfo info = new WorldInfo();

    public void clear() {
        this.totalMemory = 0L;
        this.maxMemory = 0L;
        this.freeMemory = 0L;
        this.averagePackets = 0;
        this.exactPackets = 0;
        this.averageServerLag = 0L;
        this.exactServerLag = 0L;
        this.dimensionLag.clear();
        this.info.clear();
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.averagePackets = buffer.func_150792_a();
        this.exactPackets = buffer.func_150792_a();
        this.totalMemory = buffer.readLong();
        this.maxMemory = buffer.readLong();
        this.freeMemory = buffer.readLong();
        this.averageServerLag = buffer.func_179260_f();
        this.exactServerLag = buffer.func_179260_f();
        this.dimensionLag.clear();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            DimensionType type = DimensionType.func_186069_a((int)buffer.readInt());
            long lag = buffer.func_179260_f();
            this.dimensionLag.put((Object)type, lag);
        }
        this.info.clear();
        if (buffer.readBoolean()) {
            this.info.read(buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(IRenderHelper helper, int x, int y) {
        helper.drawArea(x, y, 100, 88 + this.dimensionLag.size() * 5);
        helper.drawText(x + 54, y += 3, Align.CENTER, "Server Tracker");
        int ms = (int)MathHelper.func_76131_a((float)((float)this.averageServerLag / 1000000.0f), (float)0.0f, (float)50.0f);
        helper.drawProgressBar(x + 4, y += 5, 100, 5, (float)ms / 50.0f, "Server Lag: " + this.averageServerLag / 1000000L + " / 50ms (" + this.averageServerLag / 1000L + "qs)");
        float tps = Math.min(20.0f, 20.0f / ((float)ms / 50.0f));
        helper.drawProgressBar(x + 4, y += 5, 100, 5, tps / 20.0f, "TPS (" + ItemStack.field_111284_a.format(tps) + " / 20)");
        helper.drawProgressBar(x + 4, y += 5, 100, 5, this.maxMemory <= 0L ? 0.0f : (float)(this.totalMemory - this.freeMemory) / (float)this.maxMemory, "Ram: (" + FORMAT.format(IProcessorInfo.toMB(this.totalMemory - this.freeMemory)) + " MB / " + FORMAT.format(IProcessorInfo.toMB(this.maxMemory)) + " MB)");
        helper.drawText(x + 4, y += 8, Align.START, "Server Packets: " + this.exactPackets + " (Average: " + this.averagePackets + ")");
        for (Object2LongMap.Entry type : this.dimensionLag.object2LongEntrySet()) {
            ms = (int)MathHelper.func_76131_a((float)((float)type.getLongValue() / 1000000.0f), (float)0.0f, (float)50.0f);
            helper.drawProgressBar(x + 4, y += 5, 100, 5, (float)ms / 50.0f, ChunkLogger.toPascalCase(((DimensionType)type.getKey()).getRegistryName().func_110623_a()) + " Lag: " + type.getLongValue() / 1000000L + " / 50ms (" + type.getLongValue() / 1000L + "qs)");
        }
        if (this.info.dim == null) {
            return;
        }
        helper.drawText(x + 54, y += 8, Align.CENTER, "Detailed Info");
        helper.drawText(x + 54, y += 5, Align.CENTER, ChunkLogger.toPascalCase(this.info.dim.getRegistryName().func_110623_a()));
        ms = (int)MathHelper.func_76131_a((float)((float)this.info.averageLag / 1000000.0f), (float)0.0f, (float)50.0f);
        helper.drawProgressBar(x + 4, y += 5, 100, 5, (float)ms / 50.0f, "Average Lag: " + this.info.averageLag / 1000000L + " / 50ms (" + this.info.averageLag / 1000L + "qs)");
        ms = (int)MathHelper.func_76131_a((float)((float)this.info.exactLag / 1000000.0f), (float)0.0f, (float)50.0f);
        helper.drawProgressBar(x + 4, y += 5, 100, 5, (float)ms / 50.0f, "Exact Lag: " + this.info.exactLag / 1000000L + " / 50ms (" + this.info.exactLag / 1000L + "qs)");
        helper.drawText(x + 4, y += 7, Align.START, "Loaded Chunks: " + this.info.loadedChunks);
        helper.drawText(x + 4, y += 5, Align.START, "Loaded Points of Interest: " + this.info.loadedPointsOfInterest);
        helper.drawText(x + 4, y += 5, Align.START, "Loaded TileEntities: " + this.info.loadedTileEntities + " (" + this.info.tickingTileEntities + " Ticking)");
        helper.drawText(x + 4, y += 5, Align.START, "Loaded Entities: " + this.info.loadedEntities);
        helper.drawText(x + 4, y += 5, Align.START, "BlockUpdates: " + this.info.exactBlockUpdates + " (Average: " + this.info.averageBlockUpdates + ")");
        helper.drawProgressBar(x + 4, y += 5, 100, 5, (float)this.info.exactBlockTicks / 65536.0f, "BlockTicks Queue: " + this.info.exactBlockTicks + " (A: " + this.info.averageBlockTicks + ")");
        helper.drawProgressBar(x + 4, y += 5, 100, 5, (float)this.info.exactFluidTicks / 65536.0f, "FluidTicks Queue: " + this.info.exactFluidTicks + " (A: " + this.info.averageFluidTicks + ")");
    }

    @Override
    public int getID() {
        return 3;
    }

    public static class WorldInfo {
        DimensionType dim;
        long averageLag;
        long exactLag;
        int loadedTileEntities;
        int tickingTileEntities;
        int loadedChunks;
        int loadedPointsOfInterest;
        int loadedEntities;
        int averageBlockUpdates;
        int exactBlockUpdates;
        int averageBlockTicks;
        int exactBlockTicks;
        int averageFluidTicks;
        int exactFluidTicks;

        public void clear() {
            this.dim = null;
        }

        public void read(PacketBuffer buffer) {
            this.dim = DimensionType.func_186069_a((int)buffer.readInt());
            this.averageLag = buffer.func_179260_f();
            this.exactLag = buffer.func_179260_f();
            this.loadedTileEntities = buffer.func_150792_a();
            this.tickingTileEntities = buffer.func_150792_a();
            this.loadedChunks = buffer.func_150792_a();
            this.loadedPointsOfInterest = buffer.func_150792_a();
            this.loadedEntities = buffer.func_150792_a();
            this.averageBlockUpdates = buffer.func_150792_a();
            this.exactBlockUpdates = buffer.func_150792_a();
            this.averageBlockTicks = buffer.func_150792_a();
            this.exactBlockTicks = buffer.func_150792_a();
            this.averageFluidTicks = buffer.func_150792_a();
            this.exactFluidTicks = buffer.func_150792_a();
        }
    }
}

