/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.lwjgl.opengl.GL11;
import pregenerator.ChunkPregenerator;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.PregenSlider;
import pregenerator.client.gui.PatreonImage;
import pregenerator.client.preview.ConfirmScreen;
import pregenerator.client.preview.ScreenshotScreen;
import pregenerator.client.preview.data.ChunkData;
import pregenerator.client.preview.data.EventManager;
import pregenerator.client.preview.data.MapDataManager;
import pregenerator.client.preview.data.tasks.CreateScreenshotTask;
import pregenerator.client.preview.texture.MoveableTexture;
import pregenerator.client.preview.world.ChunkCache;
import pregenerator.client.preview.world.CustomServer;
import pregenerator.client.preview.world.IFileProvider;
import pregenerator.client.preview.world.WorldData;
import pregenerator.client.preview.world.WorldSeed;
import pregenerator.common.base.ProcessListener;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.SquareTask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.structures.StructureRef;

public class PreviewScreen
extends BasePregenScreen {
    public static final int SLIME_COLOR = new Color(0, 255, 255, 128).getRGB();
    public static final DecimalFormat FORMAT = new DecimalFormat("###,###");
    WorldSeed seed;
    CustomServer server;
    Future<CustomServer> awaitedServer;
    MapDataManager manager = new MapDataManager();
    ThreadPoolExecutor screenShotService = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    ExecutorService processor = Executors.newFixedThreadPool(1);
    Map<ResourceLocation, WorldData> genData = new ConcurrentHashMap<ResourceLocation, WorldData>();
    EventManager events = new EventManager(this.genData);
    List<ResourceLocation> dimensions = new ObjectArrayList();
    int dimensionIndex = -1;
    List<String> names = new ObjectArrayList((Object[])new String[]{"Map View: Blocks", "Map View: Biome (Grass)", "Map View: Biome (Foliage)"});
    int view;
    boolean slime = false;
    boolean structures = false;
    float scale = 0.2f;
    ChunkPos pos = null;
    boolean square = true;
    boolean blockUnload = false;
    MoveableTexture renderTexture = new MoveableTexture(3200);
    TextFieldWidget seedField;
    PregenSlider radiusField;
    Button[] buttons = new Button[15];

    public PreviewScreen(CreateWorldScreen original) {
        super((ITextComponent)new StringTextComponent("Preview Screen"));
        this.seed = new WorldSeed(original);
        this.screenShotService.setKeepAliveTime(1L, TimeUnit.MILLISECONDS);
        this.screenShotService.allowCoreThreadTimeOut(true);
        WorldSeed.remove(WorldSeed.getPreviewFolder(), true);
    }

    @Override
    protected void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)this.events);
        this.dimensions.clear();
        ObjectList list = ObjectIterators.pour(DimensionType.func_212681_b().iterator());
        list.sort((K, V) -> Integer.compare(K.func_186068_a(), V.func_186068_a()));
        for (DimensionType type : list) {
            this.dimensions.add(type.getRegistryName());
        }
        this.dimensionIndex = Math.max(0, this.dimensions.indexOf(DimensionType.field_223227_a_.getRegistryName()));
        WorldData data = this.getCurrentData();
        this.registerSimpleButton(this.width - 202, 16, 20, 13, "GC", T -> System.gc());
        this.seedField = this.registerSimpleText(30, 35, 160, 10, this.seed.getSeedString());
        this.buttons[0] = this.registerSimpleButton(29, 47, 80, 14, "Ramdomize", T -> this.seedField.func_146180_a(Long.toString(new Random().nextLong())));
        this.buttons[1] = this.registerSimpleButton(111, 47, 80, 14, "Apply Seed", this::setSeed);
        this.radiusField = this.registerSimpleSlider(44, 75, 132, 14, "Radius: ", " Chunks", 1.0, 1000.0, data == null ? 100.0 : (double)data.getRadius(), T -> {}).setScrollEffect(1.0);
        this.buttons[2] = this.registerSimpleButton(29, 75, 14, 14, "<", T -> this.offset(-1));
        this.buttons[3] = this.registerSimpleButton(177, 75, 14, 14, ">", T -> this.offset(1));
        this.buttons[4] = this.registerSimpleButton(29, 91, 70, 14, "Apply Size", this::resizeTexture);
        this.buttons[5] = this.registerSimpleButton(101, 91, 90, 14, "Shape: Square", this::toggleShape);
        this.buttons[8] = this.registerSimpleButton(29, 106, 162, 14, this.getDimensionName(), this::dim);
        this.buttons[9] = this.registerSimpleButton(29, 121, 80, 14, "Start", this::start);
        this.buttons[10] = this.registerSimpleButton(111, 121, 80, 14, "Stop", this::stop);
        this.registerSimpleButton(29, 146, 162, 14, "Map View: Blocks", this::toggleView);
        this.registerSimpleButton(29, 161, 80, 14, "Slime Chunks", this::toggleChunks);
        this.registerSimpleButton(111, 161, 80, 14, "Structures", this::toggleStructures);
        this.registerSimpleButton(29, 176, 80, 14, "Progress View", this::toggleProgress);
        this.buttons[13] = this.registerSimpleButton(111, 176, 80, 14, "Screenshot", this::createScreenshot);
        this.buttons[11] = this.registerSimpleButton(29, this.height - 29, 80, 14, "Back", this::back);
        this.buttons[12] = this.registerSimpleButton(111, this.height - 29, 80, 14, "Keep World", this::keepWorld);
        this.buttons[14] = this.registerSimpleButton(199, 15, 18, 18, "", this::togglePatreon);
        if (this.server == null && this.awaitedServer == null) {
            this.awaitedServer = this.processor.submit(this.seed::createServer);
        }
    }

    public void removed() {
        if (this.blockUnload) {
            return;
        }
        this.processor.shutdownNow();
        this.screenShotService.shutdownNow();
        this.renderTexture.removeTexture();
        this.manager.kill();
        MinecraftForge.EVENT_BUS.unregister((Object)this.events);
        super.removed();
    }

    @Override
    public void tick() {
        ServerManager manager = ServerManager.INSTANCE;
        boolean globalRunning = manager.isRunning();
        boolean dimensionRunning = manager.isRunning(this.getType());
        boolean serverRunning = this.awaitedServer == null && this.server != null && this.server.func_71200_ad();
        this.buttons[0].active = !globalRunning;
        this.buttons[1].active = !globalRunning && WorldSeed.makeSeed(this.seedField.func_146179_b()) != this.seed.getSeed();
        this.seedField.func_146184_c(!globalRunning);
        this.radiusField.active = !globalRunning;
        this.buttons[2].active = !dimensionRunning;
        this.buttons[3].active = !dimensionRunning;
        this.buttons[4].active = !dimensionRunning && (int)this.renderTexture.getWidth() != this.radiusField.getValueInt() * 32;
        this.buttons[5].active = !dimensionRunning;
        this.buttons[9].active = !dimensionRunning && serverRunning && manager.hasProcessorsLeft();
        this.buttons[10].active = dimensionRunning && this.server != null;
        this.buttons[11].active = !globalRunning && this.screenShotService.getActiveCount() <= 0 && !this.buttons[11].getMessage().equals("Stopping") && !this.buttons[12].getMessage().equals("Processing");
        this.buttons[12].active = !globalRunning && this.screenShotService.getActiveCount() <= 0 && !this.buttons[11].getMessage().equals("Stopping") && !this.buttons[12].getMessage().equals("Processing");
        this.buttons[13].active = this.screenShotService.getActiveCount() <= 0;
        this.buttons[13].setMessage(this.buttons[13].active ? "Screenshot" : "Processing");
        this.buttons[9].setMessage(serverRunning ? (manager.hasProcessorsLeft() ? "Start" : "Max Tasks") : "Loading");
        if (this.awaitedServer != null && this.awaitedServer.isDone()) {
            try {
                this.server = this.awaitedServer.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.awaitedServer = null;
        }
        super.tick();
        for (WorldData data : this.genData.values()) {
            data.update(this.view, this.processor);
            if (!data.isFocused()) continue;
            data.render(this.renderTexture);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double effect) {
        if (effect != 0.0 && this.isInFrame(mouseX, mouseY)) {
            float data = 1.0f + (PreviewScreen.hasControlDown() ? 2.0f : 0.1f) * (float)effect;
            this.scale *= data;
            if (this.scale < 0.01f) {
                this.scale = 0.01f;
            } else if (this.scale > 60.0f) {
                this.scale = 60.0f;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, effect);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isInFrame(mouseX, mouseY)) {
            this.pos = new ChunkPos((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (this.pos != null) {
            this.pos = null;
            return true;
        }
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        long window = this.getMinecraft().func_228018_at_().func_198092_i();
        if (this.pos != null) {
            this.renderTexture.moveTexture(-((float)(this.pos.field_77276_a - mouseX) / this.scale), -((float)(this.pos.field_77275_b - mouseY) / this.scale));
            this.pos = new ChunkPos(mouseX, mouseY);
        } else if (!this.seedField.isFocused()) {
            float xMove = (InputMappings.func_216506_a((long)window, (int)65) ? 1.0f : 0.0f) + (InputMappings.func_216506_a((long)window, (int)68) ? -1.0f : 0.0f);
            float yMove = (InputMappings.func_216506_a((long)window, (int)87) ? 1.0f : 0.0f) + (InputMappings.func_216506_a((long)window, (int)83) ? -1.0f : 0.0f);
            if (xMove != 0.0f || yMove != 0.0f) {
                this.renderTexture.moveTexture(xMove / this.scale, yMove / this.scale);
            }
        }
        this.renderBackground();
        long[] ram = this.getRamInfo();
        long[] progressBars = ServerManager.INSTANCE.getData(this.getType());
        this.drawFrame(ram, progressBars);
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.func_227760_t_((int)PatreonImage.PATREON_PIC.func_110552_b());
        this.renderTexture(202.0f, 17.0f, 13.0f, 13.0f);
        MainWindow mc = this.getMinecraft().func_228018_at_();
        double scaleW = (double)mc.func_198109_k() / ((double)mc.func_198109_k() / mc.func_198100_s());
        double scaleH = (double)mc.func_198091_l() / ((double)mc.func_198091_l() / mc.func_198100_s());
        this.startScissors((int)(200.0 * scaleW), (int)(50.0 * scaleH), (int)((double)mc.func_198105_m() - 240.0 * scaleW), (int)((double)mc.func_198083_n() - 85.0 * scaleH));
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)((float)this.centerX + 70.0f), (float)this.centerY, (float)0.0f);
        GlStateManager.func_227672_b_((float)this.scale, (float)this.scale, (float)1.0f);
        this.renderTexture.render(this::renderTextureWithOffset);
        this.drawExtras();
        GlStateManager.func_227627_O_();
        GL11.glDisable((int)3089);
        this.drawPostFrame(ram, progressBars);
        if (!this.isInFrame(mouseX, mouseY)) {
            ObjectArrayList tooltips = new ObjectArrayList();
            if (this.buttons[13].isMouseOver((double)mouseX, (double)mouseY)) {
                tooltips.add("Creates a Screenshot of the Current MapView without UI Elements");
                tooltips.add("Press Shift while pressing to get into a Selection View");
                tooltips.add("Press Shift while confirming settings to include Mineshafts if structures are selected");
            }
            if (this.radiusField.isMouseOver(mouseX, mouseY)) {
                int worldSize = this.radiusField.getValueInt() * 32;
                long byteSize = (int)Math.pow(this.radiusField.getValueInt() * 2, 2.0);
                tooltips.add("WorldSize: " + FORMAT.format(worldSize) + "x" + FORMAT.format(worldSize) + " Blocks");
                tooltips.add("");
                tooltips.add("Expected Memory Usage");
                tooltips.add("GPU Usage: " + FORMAT.format(byteSize * 1024L >> 20) + " MB");
                tooltips.add("");
                tooltips.add("Harddrive Usage: (Accumulated per dimension)");
                tooltips.add("World Usage: " + FORMAT.format(byteSize * 8192L >> 20) + " MB");
                tooltips.add("Preview Data: " + FORMAT.format(byteSize * IFileProvider.FileType.CHUNK_DATA.getOffset() + byteSize * IFileProvider.FileType.HEIGHT_DATA.getOffset() >> 20) + " MB (Temporary)");
            }
            if (this.buttons[8].isMouseOver((double)mouseX, (double)mouseY)) {
                tooltips.add(ChunkLogger.toPascalCase(this.dimensions.get(this.dimensionIndex).func_110624_b()));
            }
            if (this.buttons[14].isMouseOver((double)mouseX, (double)mouseY)) {
                tooltips.add("Support Speiger on Patreon");
            }
            if (tooltips.size() > 0) {
                this.renderTooltip((List)tooltips, mouseX, mouseY);
            }
            return;
        }
        WorldData data = this.getCurrentData();
        if (data == null) {
            return;
        }
        ChunkPos pos = this.getMousePosition(data.getRadius() * 16, mouseX, mouseY);
        if (pos == null) {
            return;
        }
        ChunkData chunk = data.getData(pos.field_77276_a >> 4, pos.field_77275_b >> 4);
        if (chunk == null) {
            return;
        }
        ObjectArrayList tooltips = new ObjectArrayList();
        int x = pos.field_77276_a & 0xF;
        int z = pos.field_77275_b & 0xF;
        int index = z * 16 + x;
        tooltips.add("Position: [X=" + pos.field_77276_a + ", Y=" + chunk.getHeights()[index] + ", Z=" + pos.field_77275_b + "]");
        tooltips.add("Chunk: [X=" + (pos.field_77276_a >> 4) + ", Z=" + (pos.field_77275_b >> 4) + "]");
        ResourceLocation biome = chunk.getBiome(index).getRegistryName();
        tooltips.add("Biome: [" + ChunkLogger.toPascalCase(biome.func_110623_a()) + " (" + ChunkLogger.toPascalCase(biome.func_110624_b()) + ")]");
        if (chunk.isSlimeChunk()) {
            tooltips.add("SlimeChunk");
        }
        List<StructureRef> references = data.getStructures();
        int m = references.size();
        for (int i = 0; i < m; ++i) {
            int growth;
            StructureRef ref = references.get(i);
            int[] bounds = ref.getBounds();
            int n = growth = ref.getSize() <= 4 ? 20 : 0;
            if (pos.field_77276_a < bounds[0] - growth || pos.field_77276_a > bounds[3] + growth || pos.field_77275_b < bounds[2] - growth || pos.field_77275_b > bounds[5] + growth) continue;
            tooltips.add(ref.getDisplayName());
        }
        if (!chunk.isDone()) {
            tooltips.add("Chunk needs Lighting");
        }
        this.renderTooltip((List)tooltips, mouseX, mouseY);
    }

    public ChunkPos getMousePosition(int radius, int mouseX, int mouseY) {
        int posX = (int)(this.renderTexture.getX() - ((float)(mouseX - (this.width + 140) / 2) / this.scale - (float)this.centerX));
        int posZ = (int)(this.renderTexture.getY() - ((float)(mouseY - this.height / 2) / this.scale - (float)this.centerY));
        return posX > 0 || posZ > 0 || posX <= radius * -2 || posZ <= radius * -2 ? null : new ChunkPos(Math.abs(posX) - radius, Math.abs(posZ) - radius);
    }

    public void drawExtras() {
        WorldData data = this.getCurrentData();
        if (data == null) {
            return;
        }
        GlStateManager.func_227670_b_((double)this.centerX, (double)this.centerY, (double)0.0);
        GlStateManager.func_227688_c_((float)(this.renderTexture.getWidth() / 2.0f), (float)(this.renderTexture.getHeight() / 2.0f), (float)0.0f);
        float x = this.renderTexture.getX();
        float y = this.renderTexture.getY();
        if (this.slime) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder builder = tes.func_178180_c();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227621_I_();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            LongIterator longIterator = data.getSlimeChunks().iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                float minX = (float)(ChunkPos.func_212578_a((long)pos) * 16) + x;
                float minY = (float)(ChunkPos.func_212579_b((long)pos) * 16) + y;
                this.drawQuadArea(minX, minY, minX + 16.0f, minY + 16.0f, builder, SLIME_COLOR);
            }
            tes.func_78381_a();
            GlStateManager.func_227619_H_();
            GlStateManager.func_227737_l_();
        }
        if (this.structures) {
            int radius = data.getRadius() * 16;
            List<StructureRef> references = data.getStructures();
            int m = references.size();
            for (int i = 0; i < m; ++i) {
                StructureRef ref = references.get(i);
                String name = ref.getName();
                boolean mineshaft = name.equalsIgnoreCase("minecraft:mineshaft");
                if (mineshaft && !Screen.hasShiftDown()) continue;
                int growth = ref.getSize() <= 4 ? 20 : 0;
                int color = Integer.MIN_VALUE | (mineshaft ? 0xFF0000 : (name.hashCode() & 0xAAAAAA) + 0x444444 & 0xFFFFFF);
                int[] bounds = ref.getBounds();
                if (bounds[3] <= -radius || bounds[0] >= radius || bounds[5] <= -radius || bounds[2] >= radius) continue;
                this.fill((float)bounds[0] + x - (float)growth, (float)bounds[2] + y - (float)growth, (float)bounds[3] + x + (float)growth, (float)bounds[5] + y + (float)growth, color);
            }
        }
    }

    public void drawFrame(long[] ram, long[] progressBars) {
        int pixels;
        this.drawSimpleRect(20, 15, this.width - 20, this.height - 13, -3750202, false);
        this.drawSimpleRect(200, 35, this.width - 40, this.height - 50, -7631989, true);
        this.drawSimpleRect(this.width - 180, 17, this.width - 40, 28, -7631989, true);
        this.drawSimpleRect(200, this.height - 28, this.width - 40, this.height - 15, -7631989, true);
        this.drawSimpleRect(200, this.height - 45, this.width - 40, this.height - 32, -7631989, true);
        double value = (double)ram[0] / (double)ram[2];
        PreviewScreen.fill((int)(this.width - 180), (int)17, (int)(this.width - 40 - (int)(140.0 - 140.0 * value)), (int)28, (int)Color.GREEN.getRGB());
        if (progressBars[0] > 0L) {
            pixels = this.width - 200 - 40;
            value = (double)progressBars[1] / (double)progressBars[0];
            PreviewScreen.fill((int)200, (int)(this.height - 28), (int)(this.width - 40 - (int)((double)pixels - (double)pixels * value)), (int)(this.height - 15), (int)Color.RED.darker().getRGB());
            value = (double)progressBars[2] / (double)progressBars[0];
            PreviewScreen.fill((int)200, (int)(this.height - 28), (int)(this.width - 40 - (int)((double)pixels - (double)pixels * value)), (int)(this.height - 15), (int)Color.GREEN.getRGB());
        }
        if (progressBars[3] > 0L) {
            pixels = this.width - 200 - 40;
            value = (double)progressBars[4] / (double)progressBars[3];
            PreviewScreen.fill((int)200, (int)(this.height - 45), (int)(this.width - 40 - (int)((double)pixels - (double)pixels * value)), (int)(this.height - 32), (int)Color.RED.darker().getRGB());
            value = (double)progressBars[5] / (double)progressBars[3];
            PreviewScreen.fill((int)200, (int)(this.height - 45), (int)(this.width - 40 - (int)((double)pixels - (double)pixels * value)), (int)(this.height - 32), (int)Color.GREEN.getRGB());
        }
    }

    public void drawPostFrame(long[] ram, long[] progressBars) {
        this.drawSimpleText("Seed: ", 30, 25, 0x404040);
        this.drawSimpleText("Generation Settings:", 30, 66, 0x404040);
        this.drawSimpleText("Overlays: ", 30, 137, 0x404040);
        this.drawSimpleText("RAM: " + (ram[0] >> 20) + " MB / " + (ram[2] >> 20) + " MB", this.width - 178, 19, 0x404040);
        long totalGen = progressBars[0];
        long dimGen = progressBars[3];
        if (Screen.hasShiftDown() || progressBars[1] == totalGen) {
            this.drawSimpleText(progressBars[2] + " / " + totalGen + " Light-Chunks", 201, this.height - 25, 0x404040);
        } else {
            this.drawSimpleText(progressBars[1] + " / " + totalGen + " Gen-Chunks", 201, this.height - 25, 0x404040);
        }
        if (Screen.hasShiftDown() || progressBars[4] == dimGen) {
            this.drawSimpleText("Dim: " + progressBars[5] + " / " + dimGen + " Light-Chunks", 201, this.height - 42, 0x404040);
        } else {
            this.drawSimpleText("Dim: " + progressBars[4] + " / " + dimGen + " Gen-Chunks", 201, this.height - 42, 0x404040);
        }
    }

    private long[] getRamInfo() {
        long first = Runtime.getRuntime().totalMemory();
        long second = Runtime.getRuntime().freeMemory();
        long last = Runtime.getRuntime().maxMemory();
        return new long[]{first - second, first, last};
    }

    public String getDimensionName() {
        return "Dim: " + ChunkLogger.toPascalCase(this.dimensions.get(this.dimensionIndex).func_110623_a());
    }

    public DimensionType getType() {
        return DimensionType.func_193417_a((ResourceLocation)this.dimensions.get(this.dimensionIndex));
    }

    public WorldData getCurrentData() {
        return this.genData.get(this.dimensions.get(this.dimensionIndex));
    }

    public WorldData createData() {
        ResourceLocation dim = this.dimensions.get(this.dimensionIndex);
        WorldData data = this.genData.get(dim);
        if (data == null) {
            data = new WorldData(dim, this.manager.generateForDimension(dim), this.seed.getSeed(), ServerLifecycleHooks.getCurrentServer().func_71218_a(this.getType()).func_201675_m().func_177495_o(), this.square);
            data.setRadius(this.radiusField.getValueInt());
            this.genData.put(dim, data);
            this.renderTexture.resizeTexture(this.radiusField.getValueInt() * 32);
            this.renderTexture.centerTexture();
        }
        return data;
    }

    public void reloadTextureData() {
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.reload(this.view);
        }
    }

    private void togglePatreon(Button button) {
        this.blockUnload = true;
        String s = "https://www.patreon.com/Speiger";
        this.minecraft.func_147108_a((Screen)new ConfirmOpenLinkScreen(p_213069_2_ -> {
            if (p_213069_2_) {
                Util.func_110647_a().func_195640_a(s);
            }
            this.blockUnload = false;
            this.minecraft.func_147108_a((Screen)this);
        }, s, true));
    }

    public void createScreenshot(Button button) {
        if (Screen.hasShiftDown()) {
            this.blockUnload = true;
            this.minecraft.func_147108_a((Screen)new ScreenshotScreen((K, V) -> {
                if (K.booleanValue()) {
                    this.createScreenShot(V[0] > 0, V[1], V[2]);
                }
                this.minecraft.func_147108_a((Screen)this);
                this.blockUnload = false;
            }));
            return;
        }
        this.createScreenShot(false, -1, 0);
    }

    private void createScreenShot(boolean allScreen, int screenType, int overlays) {
        File file = new File(this.minecraft.field_71412_D, "screenshots/preview/" + Long.toString(this.seed.getSeed()));
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (screenType < 0) {
            WorldData data = this.getCurrentData();
            if (data != null) {
                this.screenShotService.execute(new CreateScreenshotTask(data, file, (IntList)IntArrayList.wrap((int[])new int[]{this.view & 0xFFFFFFFB}), overlays));
            }
        } else if (allScreen) {
            for (WorldData data : this.genData.values()) {
                IntArrayList list = new IntArrayList();
                for (int i = 0; i < 3; ++i) {
                    if ((screenType & 1 << i) == 0) continue;
                    list.add(i);
                }
                this.screenShotService.execute(new CreateScreenshotTask(data, file, (IntList)list, overlays));
            }
        } else {
            WorldData data = this.getCurrentData();
            if (data == null) {
                return;
            }
            IntArrayList list = new IntArrayList();
            for (int i = 0; i < 3; ++i) {
                if ((screenType & 1 << i) == 0) continue;
                list.add(i);
            }
            this.screenShotService.execute(new CreateScreenshotTask(data, file, (IntList)list, overlays));
        }
    }

    public String getMapView() {
        return this.names.get(this.view & 0xFFFFFFFB);
    }

    public void setDimension(int index) {
        this.dimensionIndex = index % this.dimensions.size();
        for (WorldData data : this.genData.values()) {
            data.setFocus(this.dimensions.get(this.dimensionIndex), this.view);
        }
        WorldData data = this.getCurrentData();
        if (data != null) {
            this.radiusField.setValue(data.getRadius());
            this.radiusField.updateSlider();
        }
        this.renderTexture.resizeTexture(this.radiusField.getValueInt() * 32);
        this.renderTexture.centerTexture();
        this.reloadTextureData();
    }

    private void start(Button button) {
        this.createData();
        WorldData data = this.getCurrentData();
        ServerManager.INSTANCE.startTask((data.isSquare() ? new SquareTask("Preview_" + this.getType().getRegistryName().toString(), this.getType(), GenerationType.FAST_CHECK_GEN.getIndex(), new ChunkPos(0, 0), this.radiusField.getValueInt()) : new CircleTask("Preview_" + this.getType().getRegistryName().toString(), this.getType(), GenerationType.FAST_CHECK_GEN.getIndex(), new ChunkPos(0, 0), this.radiusField.getValueInt())).setThrowEvents(), ProcessListener.PREVIEW.getOwner(), T -> {});
    }

    private void stop(Button button) {
        this.server.execute(() -> ServerManager.INSTANCE.removeTask("Preview_" + this.getType().getRegistryName().toString(), T -> {}));
    }

    private void toggleChunks(Button button) {
        this.slime = !this.slime;
    }

    private void toggleStructures(Button button) {
        this.structures = !this.structures;
    }

    private void toggleProgress(Button button) {
        this.view ^= 4;
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.reload(this.view);
        }
    }

    private void toggleView(Button button) {
        boolean has = (this.view & 4) != 0;
        this.view = (this.view + 1) % 3;
        if (!has) {
            WorldData data = this.getCurrentData();
            if (data != null) {
                data.reload(this.view);
            }
        } else {
            this.view |= 4;
        }
        button.setMessage(this.getMapView());
    }

    private void setSeed(Button button) {
        long newSeed = WorldSeed.makeSeed(this.seedField.func_146179_b());
        if (newSeed != this.seed.getSeed()) {
            this.seed.setSeed(this.seedField.func_146179_b());
            this.removeServer(() -> {
                this.manager.clearDimensions();
                WorldSeed.removePreview();
                this.renderTexture.centerTexture();
                this.renderTexture.clearTexture();
                this.reloadTextureData();
                this.awaitedServer = this.processor.submit(this.seed::createServer);
            });
        }
    }

    private void toggleShape(Button button) {
        WorldData data = this.getCurrentData();
        if (data != null) {
            button.setMessage("Shape: " + (data.toggleSquare() ? "Square" : "Circle"));
            return;
        }
        this.square = !this.square;
        button.setMessage("Shape: " + (this.square ? "Square" : "Circle"));
    }

    private void dim(Button button) {
        this.setDimension(this.dimensionIndex + 1);
        button.setMessage(this.getDimensionName());
    }

    private void resizeTexture(Button button) {
        int radius = this.radiusField.getValueInt();
        this.renderTexture.resizeTexture(radius * 32);
        this.renderTexture.centerTexture();
        WorldData data = this.getCurrentData();
        if (data != null) {
            data.setRadius(radius);
        }
        this.reloadTextureData();
    }

    private void back(Button button) {
        button.setMessage("Stopping");
        button.active = false;
        this.removeServer(this::back);
    }

    void back() {
        this.getMinecraft().func_147108_a(this.seed.getPrevScreen());
        WorldSeed.remove(WorldSeed.getPreviewFolder(), true);
    }

    private void keepWorld(Button button) {
        Object2IntLinkedOpenHashMap toLight = new Object2IntLinkedOpenHashMap();
        for (WorldData data : this.genData.values()) {
            ChunkCache cache = data.getCache();
            if (cache.isFullyFinished()) continue;
            toLight.put((Object)data.getDimension(), cache.getChunksToLight());
        }
        if (toLight.isEmpty()) {
            button.active = false;
            button.setMessage("Processing");
            this.removeServer(this::finishFolder);
            return;
        }
        this.blockUnload = true;
        this.getMinecraft().func_147108_a((Screen)new ConfirmScreen(T -> {
            this.getMinecraft().func_147108_a((Screen)this);
            this.blockUnload = false;
            if (T.booleanValue()) {
                this.buttons[12].active = false;
                this.buttons[12].setMessage("Processing");
                this.removeServer(this::finishFolder);
            }
        }, (Object2IntMap<ResourceLocation>)toLight));
    }

    private void finishFolder() {
        WorldSeed.remove(WorldSeed.getMapFolder(), true);
        WorldSeed.getPreviewFolder().renameTo(new File("saves/" + this.seed.getMapName()));
        this.getMinecraft().func_147108_a((Screen)new MainMenuScreen());
    }

    private void offset(int value) {
        this.radiusField.setValue(MathHelper.func_76125_a((int)(this.radiusField.getValueInt() + value), (int)1, (int)1000));
        this.radiusField.updateSlider();
    }

    public boolean isInFrame(double mouseX, double mouseY) {
        return mouseX >= 200.0 && mouseX <= (double)(this.width - 35) && mouseY >= 40.0 && mouseY <= (double)(this.height - 50);
    }

    public void startScissors(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    private void removeServer(Runnable runnable) {
        this.processor.execute(() -> {
            if (this.awaitedServer != null) {
                try {
                    this.server = this.awaitedServer.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ChunkPregenerator.LOGGER.info("Removing Server: " + (this.server != null));
            if (this.server != null) {
                this.seed.destroyServer(this.server);
                this.server = null;
            }
            if (runnable != null) {
                this.getMinecraft().func_213167_f(runnable);
            }
        });
    }
}

