/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview;

import java.util.function.BiConsumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.PregenCheckBox;

public class ScreenshotScreen
extends BasePregenScreen {
    PregenCheckBox[] box = new PregenCheckBox[7];
    BiConsumer<Boolean, int[]> listener;

    public ScreenshotScreen(BiConsumer<Boolean, int[]> listener) {
        super((ITextComponent)new StringTextComponent("Screenshot"));
        this.listener = listener;
    }

    @Override
    protected void init() {
        super.init();
        this.box[0] = this.registerCheckbox(-85, -60, 80, 20, "Current Map", true, this::currentMap);
        this.box[1] = this.registerCheckbox(5, -60, 80, 20, "All Maps", false, this::allMaps);
        this.box[2] = this.registerCheckbox(-140, -30, 90, 20, "Blocks", true);
        this.box[3] = this.registerCheckbox(-45, -30, 90, 20, "Biomes (Grass)", false);
        this.box[4] = this.registerCheckbox(50, -30, 90, 20, "Biomes (Foliage)", false);
        this.box[5] = this.registerCheckbox(-115, 0, 110, 20, "Slime Overlay", false);
        this.box[6] = this.registerCheckbox(5, 0, 110, 20, "Structure Overlay", false);
        this.registerButton(-60, 30, 120, 20, "Create Screenshots", T -> this.back(true));
        this.registerButton(-30, 60, 60, 20, "Back", T -> this.back(false));
    }

    private void currentMap(Button button) {
        this.box[1].setChecked(!this.box[0].isChecked());
    }

    private void allMaps(Button button) {
        this.box[0].setChecked(!this.box[1].isChecked());
    }

    private void back(boolean finished) {
        int[] nArray;
        Boolean bl = finished && this.generateResult() > 0;
        if (finished) {
            int[] nArray2 = new int[3];
            nArray2[0] = this.box[0].isChecked() ? 0 : 1;
            nArray2[1] = this.generateResult();
            nArray = nArray2;
            nArray2[2] = this.generateOverlays();
        } else {
            nArray = null;
        }
        this.listener.accept(bl, nArray);
    }

    private int generateResult() {
        int result = 0;
        result += this.box[2].isChecked() ? 1 : 0;
        result += this.box[3].isChecked() ? 2 : 0;
        return result += this.box[4].isChecked() ? 4 : 0;
    }

    private int generateOverlays() {
        int result = 0;
        result += this.box[5].isChecked() ? 1 : 0;
        result += this.box[6].isChecked() ? 2 : 0;
        return result += this.box[6].isChecked() && Screen.hasShiftDown() ? 4 : 0;
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        this.renderBackground();
        super.render(mouseX, mouseY, partial);
        this.drawCenterText("Screenshot Settings", 0, -90, -1);
    }
}

