/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.preview.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import pregenerator.client.preview.world.WorldData;
import pregenerator.common.base.PregenEvent;

public class EventManager {
    Map<ResourceLocation, WorldData> genData;
    Map<WorldLightManager, ResourceLocation> toWorlds = new ConcurrentHashMap<WorldLightManager, ResourceLocation>();

    public EventManager(Map<ResourceLocation, WorldData> genData) {
        this.genData = genData;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            this.toWorlds.put((WorldLightManager)world.func_72863_F().func_212863_j_(), world.func_201675_m().func_186058_p().getRegistryName());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            this.toWorlds.remove(((ServerWorld)event.getWorld()).func_72863_F().func_212863_j_());
        }
    }

    @SubscribeEvent
    public void onPregenEvent(PregenEvent event) {
        WorldData data = this.genData.get(event.getWorld().func_201675_m().func_186058_p().getRegistryName());
        if (data != null) {
            data.addChunk(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onPregenCheckEvent(PregenEvent.PregenCheckEvent event) {
        WorldData data = this.genData.get(event.getWorld().func_201675_m().func_186058_p().getRegistryName());
        if (data != null) {
            event.setPredicate(data.createPredicate());
        }
    }
}

