/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.misc.CommandBuilder;
import pregenerator.common.utils.misc.CommandWrapper;

public class RetrogenCommand {
    public static CommandBuilder createRetogenCommand() {
        CommandBuilder start = new CommandBuilder("Retrogen");
        start.addLiteral("add");
        start.addArgument((ArgumentBuilder<CommandSource, ?>)((RequiredArgumentBuilder)Commands.func_197056_a((String)"id", (ArgumentType)ResourceLocationArgument.func_197197_a()).executes(RetrogenCommand::add)).suggests((K, V) -> ISuggestionProvider.func_197014_a(RetrogenManager.INSTANCE.getInactiveFeatures(), (SuggestionsBuilder)V))).popTop();
        start.addLiteral("remove");
        start.addArgument((ArgumentBuilder<CommandSource, ?>)((RequiredArgumentBuilder)Commands.func_197056_a((String)"id", (ArgumentType)ResourceLocationArgument.func_197197_a()).executes(RetrogenCommand::remove)).suggests((K, V) -> ISuggestionProvider.func_197014_a(RetrogenManager.INSTANCE.getActiveFeatures(), (SuggestionsBuilder)V))).popTop();
        start.addLiteral("show", (Command<CommandSource>)((Command)RetrogenCommand::show)).popTop();
        return start;
    }

    private static int add(CommandContext<CommandSource> source) {
        if (ServerManager.INSTANCE.hasRetroBlockingTask()) {
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Retrogen Settings can not be changed while a Pregenerator is Running"), true);
            return 0;
        }
        ResourceLocation location = (ResourceLocation)source.getArgument("id", ResourceLocation.class);
        if (ForgeRegistries.FEATURES.containsKey(location)) {
            RetrogenManager.INSTANCE.enableFeature(location);
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Added [" + location + "] to the Retrogensettings"), true);
        }
        return 0;
    }

    private static int remove(CommandContext<CommandSource> source) {
        if (ServerManager.INSTANCE.hasRetroBlockingTask()) {
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Retrogen Settings can not be changed while a Pregenerator is Running"), true);
            return 0;
        }
        ResourceLocation location = (ResourceLocation)source.getArgument("id", ResourceLocation.class);
        if (ForgeRegistries.FEATURES.containsKey(location)) {
            RetrogenManager.INSTANCE.disableFeature(location);
            ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Removed [" + location + "] from the Retrogensettings"), true);
        }
        return 0;
    }

    private static int show(CommandContext<CommandSource> source) {
        CommandWrapper wrapper = new CommandWrapper(source);
        Set<ResourceLocation> locations = RetrogenManager.INSTANCE.getActiveFeatures();
        if (locations.isEmpty()) {
            wrapper.sendFeedBackMessage("No Retrogen Features active");
            return 0;
        }
        wrapper.sendFeedBackMessage("[" + locations.size() + "] Retrogen Features Enabled");
        for (ResourceLocation location : locations) {
            wrapper.sendErrorMessage(location.toString());
        }
        return 0;
    }
}

