/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import pregenerator.common.commands.arguments.CenterLocation;
import pregenerator.common.commands.arguments.ICoordinate;

public class CenterArgument
implements ArgumentType<ILocationArgument> {
    private static final Collection<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"0 0", "~ ~", "^ ^", "^1 ^-5", "~0.5 ~-5", "0b 0", "^1b ^-5b", "~0.5 ~-5b"});
    public static final SimpleCommandExceptionType POS_INCOMPLETE = new SimpleCommandExceptionType((Message)new StringTextComponent("Center Coordinate Incomplete"));
    public static final SuggestionEntry[] SUGGESTIONS = new SuggestionEntry[]{new SuggestionEntry("0 0", "Chunk Position"), new SuggestionEntry("~ ~", "Player Position (~)"), new SuggestionEntry("^ ^", "Spawn Point (^)"), new SuggestionEntry("1b 100", "Block Position, (b)"), new SuggestionEntry("^100 ^", "Spawn Point with Chunk Offset (^)"), new SuggestionEntry("^100b 100", "Spawn Point with Block Offset (^)"), new SuggestionEntry("~100 ~", "Player Position with Chunk Offset (~)"), new SuggestionEntry("~100b ^100", "Player Position with Block Offset (~)")};

    public static CenterArgument center() {
        return new CenterArgument();
    }

    public ILocationArgument parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        ICoordinate coord = ICoordinate.parseCoordinate(reader);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            return new CenterLocation(coord, ICoordinate.parseCoordinate(reader));
        }
        reader.setCursor(start);
        throw POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String[] value = builder.getRemaining().split(" ");
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < SUGGESTIONS.length; ++j) {
                if (!SUGGESTIONS[j].matches(value[i])) continue;
                SUGGESTIONS[j].suggest(builder);
            }
        }
        return builder.buildFuture();
    }

    public static BlockPos getBlockPos(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ((ILocationArgument)context.getArgument(name, ILocationArgument.class)).func_197280_c((CommandSource)context.getSource());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class SuggestionEntry {
        String entry;
        String tooltip;

        public SuggestionEntry(String entry, String tooltip) {
            this.entry = entry;
            this.tooltip = tooltip;
        }

        public boolean matches(String s) {
            return this.entry.toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT));
        }

        public void suggest(SuggestionsBuilder builder) {
            builder.suggest(this.entry, (Message)new LiteralMessage(this.tooltip));
        }
    }
}

