/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import pregenerator.ChunkPregenerator;

public interface ICoordinate {
    public int getPositon(CommandSource var1, boolean var2);

    public static ICoordinate parseCoordinate(StringReader reader) throws CommandSyntaxException {
        switch (reader.peek()) {
            case '^': {
                return new SpawnCoordinate(ICoordinate.parseNumber(ICoordinate.skip(reader)));
            }
            case '~': {
                return new PlayerCoordinate(ICoordinate.parseNumber(ICoordinate.skip(reader)));
            }
        }
        return new NormalCoordinate(ICoordinate.parseNumber(reader));
    }

    public static StringReader skip(StringReader reader) {
        reader.skip();
        return reader;
    }

    public static int parseNumber(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() != ' ') {
            int result = reader.readInt();
            if (reader.canRead() && Character.toLowerCase(reader.peek()) == 'b') {
                reader.skip();
                return result >> 4;
            }
            return result;
        }
        return 0;
    }

    public static class PlayerCoordinate
    implements ICoordinate {
        int offset;

        public PlayerCoordinate(int offset) {
            this.offset = offset;
        }

        @Override
        public int getPositon(CommandSource source, boolean isX) {
            if (source.func_197022_f() == null) {
                return this.offset;
            }
            BlockPos pos = source.func_197022_f().func_180425_c();
            return ((isX ? pos.func_177958_n() : pos.func_177952_p()) >> 4) + this.offset;
        }
    }

    public static class SpawnCoordinate
    implements ICoordinate {
        int offset;

        public SpawnCoordinate(int offset) {
            this.offset = offset;
        }

        @Override
        public int getPositon(CommandSource source, boolean isX) {
            BlockPos pos = source.func_197023_e().func_175694_M();
            ChunkPregenerator.LOGGER.info("Test: " + new ChunkPos(pos));
            return ((isX ? pos.func_177958_n() : pos.func_177952_p()) >> 4) + this.offset;
        }
    }

    public static class NormalCoordinate
    implements ICoordinate {
        int value;

        public NormalCoordinate(int value) {
            this.value = value;
        }

        @Override
        public int getPositon(CommandSource source, boolean isX) {
            return this.value;
        }
    }
}

