/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import pregenerator.common.commands.arguments.ISuggestableEnum;

public class SuggestableEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    Class<T> enumClass;

    private SuggestableEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public static <R extends Enum<R>> SuggestableEnumArgument<R> enumArgument(Class<R> enumClass) {
        return new SuggestableEnumArgument<R>(enumClass);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        return Enum.valueOf(this.enumClass, reader.readUnquotedString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining().toLowerCase(Locale.ROOT);
        Stream.of(this.enumClass.getEnumConstants()).filter(e -> e.toString().toLowerCase(Locale.ROOT).startsWith(s)).forEach(e -> builder.suggest(e.toString(), (Message)((ISuggestableEnum)((Object)e)).createSuggestion()));
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return Stream.of(this.enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
    }

    public static class Serializer
    implements IArgumentSerializer<SuggestableEnumArgument<?>> {
        public void write(SuggestableEnumArgument<?> argument, PacketBuffer buffer) {
            buffer.func_180714_a(argument.enumClass.getName());
        }

        public SuggestableEnumArgument<?> read(PacketBuffer buffer) {
            try {
                String name = buffer.func_218666_n();
                return new SuggestableEnumArgument(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void write(SuggestableEnumArgument<?> argument, JsonObject json) {
            json.addProperty("enum", argument.enumClass.getName());
        }
    }
}

