/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInputStream;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.LongPredicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.base.PregenEvent;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.utils.misc.ChunkWrapper;
import pregenerator.common.utils.misc.TrackedRegionFile;

public class ChunkEntry {
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    public static final int IS_SUB_STEP = 4;
    public static final int UNLOADED = 8;
    public static final int TASK_FINISHED = 16;
    public static final int RETRO_GENNING = 32;
    public static final int SKIP_MAIN = 64;
    private ChunkProcess process;
    private BitSet chunksToGenerate;
    private ChunkPos regionFilePos;
    private int maxSize = 0;
    private int generationSize = 0;
    private int unloadProgress = 0;
    private int retrogenProgress = 0;
    private long[] chunks;
    private CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] tasks;
    private CompletableFuture<Void> validationTask;
    private CompletableFuture<Void> retrogenTask;
    private int flags = 0;
    private BitSet chunksToEvent = null;

    public ChunkEntry(ChunkProcess process, ChunkPos regionFilePos, BitSet chunksToGenerate) {
        this.process = process;
        this.chunksToGenerate = chunksToGenerate;
        this.regionFilePos = regionFilePos;
    }

    public boolean init(ChunkProcess.RegionProvider region, boolean event, LongPredicate predicate) {
        byte state = this.process.getMemory().getState(this.regionFilePos.func_201841_a());
        if (state == 4) {
            return true;
        }
        BitSet file = region.get(this.regionFilePos.field_77276_a, this.regionFilePos.field_77275_b);
        for (int i = 0; i < 1024; ++i) {
            if (!this.chunksToGenerate.get(i)) continue;
            if (state >= 2 || this.isChunkValid(i % 32, i / 32, file, event, region) || predicate != null && !predicate.test(ChunkPos.func_77272_a((int)(this.regionFilePos.field_77276_a + i % 32), (int)(this.regionFilePos.field_77275_b + i / 32)))) {
                ++this.maxSize;
                continue;
            }
            this.chunksToGenerate.clear(i);
        }
        this.generationSize = this.maxSize;
        if (event) {
            this.chunksToEvent = new BitSet(this.generationSize);
        }
        if (state >= 2) {
            this.flags |= 0x40;
        }
        return this.maxSize == 0;
    }

    public void startTask(boolean main) {
        this.generateCache();
        if (main) {
            this.process.getTaskType().startMainTask(this.chunks, this.tasks, this, this.process);
            this.process.getMemory().addEntry(this.regionFilePos, 1);
        } else {
            this.process.getTaskType().startSubTask(this.chunks, this.tasks, this.process);
            this.process.getMemory().addEntry(this.regionFilePos, 3);
            this.flags |= 4;
        }
        this.flags |= 1;
        this.flags &= 0xFFFFFFF5;
        this.unloadProgress = 0;
    }

    public int trackProgress() {
        int i;
        if (this.isValidating()) {
            return -1;
        }
        if (this.chunksToGenerate.isEmpty()) {
            return 0;
        }
        int done = 0;
        int m = this.tasks.length;
        for (i = 0; i < m; ++i) {
            if (!this.tasks[i].isDone()) continue;
            ++done;
        }
        if (done == this.generationSize) {
            if (this.process.getTaskType() == GenerationType.BLOCK_POST && (this.flags & 4) == 0) {
                ServerWorldLightManager manager = this.process.getWorld().func_72863_F().func_212863_j_();
                for (int i2 = 0; i2 < this.tasks.length; ++i2) {
                    IChunk chunk = (IChunk)this.tasks[i2].getNow((Either<IChunk, ChunkHolder.IChunkLoadingError>)Either.left(null)).left().get();
                    if (!(chunk instanceof ChunkPrimer)) continue;
                    ((ChunkPrimer)chunk).func_201574_a(ChunkStatus.field_222613_i);
                    chunk.func_177427_f(true);
                    ((ChunkPrimer)chunk).func_217306_a((WorldLightManager)manager);
                }
                if (this.chunksToEvent != null) {
                    this.postEvents();
                    this.chunksToEvent.clear();
                }
            } else if (this.process.getTaskType() == GenerationType.RETROGEN) {
                if (this.retrogenTask != null && !this.retrogenTask.isDone()) {
                    return 0;
                }
                this.retrogenTask = null;
                for (i = 0; i < 50 && this.retrogenProgress < this.tasks.length; ++i) {
                    this.retrogenChunk((IChunk)this.tasks[this.retrogenProgress++].getNow((Either<IChunk, ChunkHolder.IChunkLoadingError>)Either.left(null)).left().get());
                }
                if (this.chunksToEvent != null) {
                    this.postEvents();
                }
                if (this.retrogenProgress < this.generationSize) {
                    return this.retrogenProgress;
                }
                done = this.retrogenProgress;
            } else if (this.chunksToEvent != null) {
                this.postEvents();
                this.chunksToEvent.clear();
            }
            this.flags |= 2;
        } else if (this.process.getTaskType() == GenerationType.RETROGEN) {
            done = 0;
        } else if (this.chunksToEvent != null) {
            this.postEvents();
        }
        return done;
    }

    public void postEvents() {
        if (this.tasks == null) {
            return;
        }
        for (int i = 0; i < this.tasks.length; ++i) {
            IChunk chunk;
            if (this.chunksToEvent.get(i) || !this.tasks[i].isDone() || (chunk = (IChunk)this.tasks[i].getNow((Either<IChunk, ChunkHolder.IChunkLoadingError>)Either.left(null)).left().get()) == null) continue;
            this.chunksToEvent.set(i);
            MinecraftForge.EVENT_BUS.post((Event)new PregenEvent(this.process.getWorld(), chunk));
        }
    }

    public void retrogenChunk(IChunk chunk) {
        if (!(chunk instanceof Chunk)) {
            return;
        }
        RetrogenManager.INSTANCE.retrogenChunks((Chunk)chunk, this.getChunks(chunk));
    }

    public List<IChunk> getChunks(IChunk center) {
        int i = center.func_76632_l().field_77276_a;
        int j = center.func_76632_l().field_77275_b;
        ObjectArrayList chunks = new ObjectArrayList();
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                Chunk chunk = (Chunk)this.process.getChunk(ChunkPos.func_77272_a((int)(i + l), (int)(j + k))).getNow((Either<IChunk, ChunkHolder.IChunkLoadingError>)Either.left(null)).left().get();
                if (chunk == null) {
                    return null;
                }
                chunks.add(new ChunkWrapper(chunk));
            }
        }
        return chunks;
    }

    public int trackUnloading(LongArrayFIFOQueue queue) {
        int end = Math.min(this.unloadProgress + 100, this.generationSize);
        if ((this.flags & 4) == 0 || !this.process.getTaskType().hasSubTask()) {
            this.process.getTaskType().unloadMainTask(this.chunks, this.unloadProgress, end, this.process);
        } else {
            this.process.getTaskType().unloadSubTask(this.chunks, this.unloadProgress, end, this.process);
        }
        this.unloadProgress = end;
        if (this.unloadProgress == this.generationSize) {
            this.flags |= 8;
            for (int i = 0; i < this.chunks.length; ++i) {
                queue.enqueue(this.chunks[i]);
            }
            this.chunks = null;
            this.tasks = null;
            if ((this.flags & 4) != 0 || !this.process.getTaskType().hasSubTask()) {
                this.flags |= 0x10;
                this.process.getMemory().addEntry(this.regionFilePos, 4);
            } else {
                this.process.getMemory().addEntry(this.regionFilePos, 2);
            }
        }
        return this.unloadProgress;
    }

    public void interrupt() {
        if (this.validationTask != null && !this.validationTask.isDone()) {
            this.validationTask.complete(null);
        }
        if (this.chunks != null) {
            if ((this.flags & 4) == 0) {
                this.process.getTaskType().unloadMainTask(this.chunks, this.unloadProgress, this.generationSize, this.process);
            } else {
                this.process.getTaskType().unloadSubTask(this.chunks, this.unloadProgress, this.generationSize, this.process);
            }
        }
    }

    public boolean isValidating() {
        return this.validationTask != null;
    }

    public boolean isStarted() {
        return (this.flags & 1) != 0;
    }

    public boolean isFinished() {
        return (this.flags & 2) != 0;
    }

    public boolean isSkipped() {
        return (this.flags & 0x40) != 0;
    }

    public void removeSkip() {
        this.flags &= 0xFFFFFFBF;
    }

    public boolean isUnloaded() {
        return (this.flags & 8) != 0;
    }

    public boolean isTaskFinished() {
        return (this.flags & 0x10) != 0;
    }

    void checkAccuratly(Executor taskManager) {
        boolean clearNull;
        boolean bl = clearNull = this.process.getTaskType() == GenerationType.POST_GEN || this.process.getTaskType() == GenerationType.RETROGEN;
        if (this.process.getFile(this.regionFilePos) == null) {
            if (this.process.getTaskType() == GenerationType.POST_GEN || this.process.getTaskType() == GenerationType.RETROGEN) {
                this.chunksToGenerate.clear();
                this.generationSize = 0;
            }
            return;
        }
        this.validationTask = CompletableFuture.runAsync(() -> {
            TrackedRegionFile file = this.process.getFile(this.regionFilePos);
            if (file == null) {
                return;
            }
            ChunkStatus.Type type = this.process.getTaskType() == GenerationType.RETROGEN ? ChunkStatus.Type.PROTOCHUNK : ChunkStatus.Type.LEVELCHUNK;
            for (int i = 0; i < 1024; ++i) {
                if (!this.chunksToGenerate.get(i)) continue;
                ChunkPos chunkPos = new ChunkPos(i % 32, i / 32);
                if (!file.func_222667_d(chunkPos)) {
                    if (!clearNull) continue;
                    this.chunksToGenerate.clear(i);
                    --this.generationSize;
                    continue;
                }
                if (!file.isValid()) {
                    file = this.process.getFile(this.regionFilePos);
                }
                try (DataInputStream stream = file.func_222666_a(chunkPos);){
                    if (ChunkSerializer.func_222651_a((CompoundNBT)CompressedStreamTools.func_74794_a((DataInputStream)stream)) != type) continue;
                    this.chunksToGenerate.clear(i);
                    --this.generationSize;
                    continue;
                }
                catch (Exception e) {
                    ChunkPregenerator.LOGGER.info("This should never happen!");
                    ChunkPregenerator.LOGGER.catching((Throwable)e);
                }
            }
        }, taskManager).thenAcceptAsync(T -> {
            this.validationTask = null;
        }, (Executor)ServerLifecycleHooks.getCurrentServer());
    }

    protected boolean isChunkValid(int x, int z, BitSet file, boolean spawn, ChunkProcess.RegionProvider region) {
        switch (this.process.getTaskType()) {
            case TERRAIN_ONLY: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != ActionResultType.SUCCESS;
            }
            case BLOCK_POST: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != ActionResultType.SUCCESS;
            }
            case FAST_CHECK_GEN: {
                return this.isChunkGenerated(x, z, file, false, spawn, region) != ActionResultType.SUCCESS;
            }
            case NORMAL_GEN: {
                return true;
            }
            case POST_GEN: {
                return this.isChunkGenerated(x, z, file, true, spawn, region) == ActionResultType.SUCCESS;
            }
            case RETROGEN: {
                return this.isChunkGenerated(x, z, file, true, spawn, region) == ActionResultType.SUCCESS;
            }
        }
        return false;
    }

    protected ActionResultType isChunkGenerated(int x, int z, BitSet file, boolean full, boolean spawn, ChunkProcess.RegionProvider region) {
        int regionX = this.regionFilePos.field_77276_a + x;
        int regionZ = this.regionFilePos.field_77275_b + z;
        if (this.process.getProvider().func_73149_a(regionX, regionZ)) {
            return ActionResultType.SUCCESS;
        }
        if (file.isEmpty()) {
            return ActionResultType.FAIL;
        }
        if (file.get(z * 32 + x)) {
            if (!full && this.isUnfinished(regionX, regionZ, region)) {
                return ActionResultType.PASS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected boolean isUnfinished(int x, int z, ChunkProcess.RegionProvider region) {
        for (int i = 1; i < 26; ++i) {
            if (region.getChunk(x + i, z) && region.getChunk(x - i, z) && region.getChunk(x, z + i) && region.getChunk(x, z - i)) continue;
            return true;
        }
        return false;
    }

    long getDistanceToCenter(ChunkPos center) {
        long x = this.regionFilePos.field_77276_a - center.field_77276_a;
        long z = this.regionFilePos.field_77275_b - center.field_77275_b;
        return x * x + z * z;
    }

    void generateCache() {
        if (this.chunks == null) {
            this.chunks = new long[this.generationSize];
            int index = 0;
            for (int i = 0; i < 1024; ++i) {
                if (!this.chunksToGenerate.get(i)) continue;
                this.chunks[index++] = ChunkPos.func_77272_a((int)(this.regionFilePos.field_77276_a + i % 32), (int)(this.regionFilePos.field_77275_b + i / 32));
            }
        }
        if (this.tasks == null) {
            this.tasks = new CompletableFuture[this.generationSize];
        }
    }

    public int getTotalSize() {
        return this.maxSize;
    }

    public int getGenerationSize() {
        return this.generationSize;
    }

    public void setRetrogenTask(CompletableFuture<Void> allOf) {
        this.retrogenTask = allOf;
    }
}

