/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.PriorityQueue;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.PregenConfig;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkUnloader;
import pregenerator.common.generator.GeneratorQueue;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.collections.FIFOQueue;
import pregenerator.common.utils.misc.IntCounter;

public class ChunkProcessor
implements IProcess<ChunkProcess, ITask> {
    public static Logger LOGGER = LogManager.getLogger((String)"Pregen");
    IntCounter gen_speed = new IntCounter(20000);
    IntCounter light_speed = new IntCounter(20000);
    IProcess.PrepaireProgress progress = null;
    ITask task;
    String taskName;
    ChunkProcess process = null;
    GeneratorQueue mainQueue;
    GeneratorQueue lightQueue;
    ChunkUnloader unloader;
    FIFOQueue<ChunkEntry> chunksToLight;
    Instant start;
    Duration terrainTime;
    long normalDone;
    long lightDone;
    long toLight;
    int ticker;
    boolean unpaused;
    boolean prepaire;

    public ChunkProcessor() {
        this.mainQueue = new GeneratorQueue(1000, (Boolean)PregenConfig.INSTANCE.agressiveGeneration.get() != false ? 2 : 1, true, this::onMainPassFinished);
        this.lightQueue = new GeneratorQueue(2000, Integer.MAX_VALUE, false, this::onLightPassFinished);
        this.unloader = new ChunkUnloader();
        this.chunksToLight = new FIFOQueue();
        this.normalDone = 0L;
        this.lightDone = 0L;
        this.toLight = 0L;
        this.ticker = 0;
        this.unpaused = true;
        this.prepaire = false;
    }

    @Override
    public void prepaireTask(IProcess.PrepaireProgress progress, String taskName) {
        this.progress = progress;
        this.taskName = taskName;
        this.prepaire = true;
    }

    @Override
    public boolean startTask(ITask task, ChunkProcess process) {
        if (process == null || task == null || !this.prepaire) {
            return false;
        }
        this.gen_speed.clear();
        this.light_speed.clear();
        this.chunksToLight.clear();
        this.normalDone = 0L;
        this.lightDone = 0L;
        this.toLight = 0L;
        this.ticker = 0;
        this.task = task;
        this.process = process;
        this.start = Instant.now();
        this.unpaused = true;
        this.prepaire = false;
        this.progress = null;
        return true;
    }

    @Override
    public boolean isBlockingRetrogen() {
        return true;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    public ITask getTask() {
        return this.task;
    }

    @Override
    public boolean isRunning() {
        return this.unpaused;
    }

    @Override
    public void pauseTask() {
        if (this.process == null || !this.unpaused) {
            return;
        }
        this.unpaused = false;
    }

    @Override
    public void resumeTask() {
        if (this.process == null || this.unpaused) {
            return;
        }
        this.unpaused = true;
        while (!this.chunksToLight.isEmpty() && this.lightQueue.enqueue((ChunkEntry)this.chunksToLight.first())) {
            ((ChunkEntry)this.chunksToLight.dequeue()).startTask(false);
        }
    }

    @Override
    public void stopTask() {
        if (this.process == null) {
            return;
        }
        TaskStorage.getGenStorage().stopTask(this.getTaskName());
        this.process.interrupt();
        this.mainQueue.interrupt();
        this.lightQueue.interrupt();
        this.unloader.forceFinish(this.process);
        this.chunksToLight.clear();
        this.process = null;
        this.task = null;
        this.prepaire = false;
        if (this.progress != null) {
            this.progress.interruptTask();
        }
        this.progress = null;
    }

    @Override
    public void onTickStart() {
        if (this.progress != null && this.ticker++ % 20 == 0) {
            long value = this.progress.getValue();
            long max = this.progress.getMax();
            double progress = (double)value / (double)max * 100.0;
            ServerManager.INSTANCE.listen(new StringTextComponent("Prepaire Progress: " + FORMAT.format(value) + " / " + FORMAT.format(max) + " [" + ItemStack.field_111284_a.format(progress) + "%]").func_211708_a(TextFormatting.AQUA));
        }
    }

    @Override
    public void onTickStop(boolean paused) {
        if (this.process == null) {
            return;
        }
        if (paused) {
            return;
        }
        this.toLight += this.unloader.process((PriorityQueue<ChunkEntry>)this.chunksToLight);
        this.unloader.handleTickets(this.process, false);
        this.process.onTick();
        if (this.unpaused) {
            this.process.drainIntoQueue(this.mainQueue);
        }
        this.mainQueue.tick();
        this.lightQueue.tick();
        this.gen_speed.setNewValue(this.normalDone + (long)this.mainQueue.getSubProgress());
        if (this.lightDone > 0L || this.lightQueue.getSubProgress() > 0) {
            this.light_speed.setNewValue(this.lightDone + (long)this.lightQueue.getSubProgress());
        }
        if (this.ticker++ % 20 == 0 && this.unpaused) {
            StringTextComponent text = new StringTextComponent("\n");
            for (ChunkLogger logger : ChunkLogger.values()) {
                logger.append((ITextComponent)text, this);
                if (logger == ChunkLogger.RamUsage) continue;
                text.func_150258_a("\n");
            }
            ServerManager.INSTANCE.listen((ITextComponent)text);
        }
        this.process.getProvider().func_212863_j_().func_215588_z_();
        if (this.process.isDone() && this.mainQueue.isNotWorking() && this.lightQueue.isNotWorking() && this.unloader.isFinished() && this.unpaused) {
            this.onTaskFinished();
        }
    }

    public StringBuilder getRam(StringBuilder builder) {
        long j = Runtime.getRuntime().totalMemory();
        return builder.append(this.toMB(j - Runtime.getRuntime().freeMemory())).append(" MB / ").append(this.toMB(Runtime.getRuntime().maxMemory())).append(" MB, Allocated=").append(this.toMB(j)).append(" MB");
    }

    protected long toMB(long base) {
        return base / 1024L / 1024L;
    }

    protected void onTaskFinished() {
        ServerManager.INSTANCE.listen((ITextComponent)new StringTextComponent("Pregenerator Finished. Starting Cleanup! May freeze the game!"));
        this.process.getProvider().func_217210_a(true);
        ServerManager.INSTANCE.listen((ITextComponent)new StringTextComponent("Pregenation Finished: [Time=" + this.getTime() + ", Chunks=" + this.process.getTotalChunks() + "]"));
        Duration time = Duration.between(Instant.now(), this.start).abs();
        long total = this.process.getTotalChunks();
        this.process.onTaskFinished();
        this.process = null;
        this.task.onCompletion(this.terrainTime == null ? time : this.terrainTime, time, total);
        TaskStorage.getGenStorage().removeTask(this.task.getName());
        ServerManager.INSTANCE.onTaskFinished(this.task.getDimension());
        this.task = null;
    }

    protected void onMainPassFinished(ChunkEntry file) {
        this.normalDone += (long)file.getTotalSize();
        if (this.process.isDone() && this.mainQueue.isNotWorking()) {
            this.terrainTime = Duration.between(Instant.now(), this.start).abs();
        }
        if (file.isUnloaded()) {
            this.lightDone += (long)file.getTotalSize();
            return;
        }
        if (this.unpaused && !file.isTaskFinished() && this.lightQueue.enqueue(file)) {
            return;
        }
        if (file.isSkipped()) {
            file.removeSkip();
            this.chunksToLight.enqueue(file);
            this.toLight += (long)file.getTotalSize();
            return;
        }
        this.unloader.enqueue(file);
    }

    protected void onLightPassFinished(ChunkEntry file) {
        this.lightDone += (long)file.getTotalSize();
        this.unloader.enqueue(file);
        while (this.unpaused && !this.chunksToLight.isEmpty() && this.lightQueue.enqueue((ChunkEntry)this.chunksToLight.first())) {
            this.toLight -= (long)((ChunkEntry)this.chunksToLight.dequeue()).getTotalSize();
        }
    }

    protected String getTime() {
        return DurationFormatUtils.formatDuration((long)Duration.between(Instant.now(), this.start).abs().toMillis(), (String)"HH:mm:ss");
    }

    public long getTotal() {
        return this.process != null ? this.process.getTotalChunks() : 0L;
    }

    public long getGenDone() {
        return this.gen_speed.getLastValue();
    }

    public long getLightDone() {
        return this.light_speed.getLastValue();
    }

    @Override
    public void sendClientData(PacketBuffer buffer) {
        buffer.writeByte(1);
        buffer.writeBoolean(this.prepaire || this.task == null);
        buffer.func_180714_a(this.taskName);
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        if (this.prepaire || this.task == null) {
            buffer.writeLong(this.progress == null ? 0L : this.progress.getValue());
            buffer.writeLong(this.progress == null ? 0L : this.progress.getMax());
            return;
        }
        buffer.writeBoolean(this.unpaused);
        buffer.writeLong(Duration.between(this.start, Instant.now()).toMillis());
        buffer.writeLong(this.process.getTotalChunks());
        buffer.writeLong(this.gen_speed.getLastValue());
        buffer.writeLong(this.light_speed.getLastValue());
        buffer.writeFloat(this.light_speed.getTotalValue());
        buffer.writeFloat(this.gen_speed.getTotalValue());
        buffer.writeInt(this.process.getPointsOfInterest());
        buffer.writeInt(this.process.getLoadedChunks());
        buffer.writeLong(this.toLight);
        buffer.writeInt(this.unloader.getChunksToUnload());
        buffer.func_150786_a(ITask.saveTask(this.task));
    }
}

