/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.BitSet;
import net.minecraft.util.math.ChunkPos;
import pregenerator.common.manager.IProcess;

public class ChunkShapeBuilder {
    public static Long2ObjectMap<BitSet> getSquareShape(int xPos, int zPos, int radius, IProcess.PrepaireProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, (Object)set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
                progress.growValue(1);
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> getSquareExspansionShape(int xPos, int zPos, int minRadius, int maxRadius, IProcess.PrepaireProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (x > -minRadius && x <= minRadius && z > -minRadius && z <= minRadius) continue;
                long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, (Object)set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> getCircleShape(int xPos, int zPos, int radius, IProcess.PrepaireProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                progress.growValue(1);
                if (ChunkShapeBuilder.isNotInReach(x, z, radius)) continue;
                long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, (Object)set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
            }
        }
        return result;
    }

    public static Long2ObjectMap<BitSet> getCircleExpansionShape(int xPos, int zPos, int minRadius, int maxRadius, IProcess.PrepaireProgress progress) {
        Long2ObjectLinkedOpenHashMap result = new Long2ObjectLinkedOpenHashMap();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (ChunkShapeBuilder.isNotInRange(x, z, minRadius, maxRadius)) continue;
                long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, (Object)set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
            }
        }
        return result;
    }

    static boolean isNotInRange(int x, int y, int minRadius, int maxRadius) {
        long distance = x * x + y * y;
        return distance >= (long)(maxRadius * maxRadius) && distance < (long)(minRadius * minRadius);
    }

    static boolean isNotInReach(int x, int y, int radius) {
        return x * x + y * y >= radius * radius;
    }
}

