/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.utils.collections.FIFOQueue;

public class ChunkUnloader {
    LongArrayFIFOQueue dataToUnload = new LongArrayFIFOQueue(50000);
    FIFOQueue<ChunkEntry> queue = new FIFOQueue();
    List<ChunkEntry> finishedSaved = new ObjectArrayList();
    int chunksToUnload = 0;
    int tempUnloaded = 0;

    public void enqueue(ChunkEntry file) {
        this.queue.enqueue(file);
        this.chunksToUnload += file.getGenerationSize();
    }

    public long process(PriorityQueue<ChunkEntry> chunksToProcess) {
        if (this.queue.isEmpty()) {
            return 0L;
        }
        long value = 0L;
        ChunkEntry file = (ChunkEntry)this.queue.first();
        this.tempUnloaded = file.trackUnloading(this.dataToUnload);
        if (file.isUnloaded()) {
            this.tempUnloaded = 0;
            this.chunksToUnload -= file.getGenerationSize();
            if (!file.isTaskFinished()) {
                chunksToProcess.enqueue((Object)file);
                value += (long)file.getTotalSize();
            }
            this.queue.dequeue();
        }
        return value;
    }

    public void handleTickets(ChunkProcess process, boolean cleanup) {
        if (cleanup) {
            this.dataToUnload.clear();
            return;
        }
        int limit = 40000;
        ServerWorld world = process.getWorld();
        ServerChunkProvider provider = process.getProvider();
        while (this.dataToUnload.size() > limit) {
            long value = this.dataToUnload.dequeueLong();
            if (process.containsChunk(provider, value)) continue;
            ChunkPos pos = new ChunkPos(value);
            world.func_205220_G_().func_223188_a(pos, true, true);
            world.func_205219_F_().func_223188_a(pos, true, true);
        }
    }

    public void forceFinish(ChunkProcess process) {
        while (!this.queue.isEmpty()) {
            ((ChunkEntry)this.queue.dequeue()).interrupt();
        }
        this.tempUnloaded = 0;
        this.chunksToUnload = 0;
        this.handleTickets(process, true);
    }

    public boolean isFinished() {
        return this.chunksToUnload <= 0;
    }

    public int getChunksToUnload() {
        return this.chunksToUnload - this.tempUnloaded;
    }
}

