/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import pregenerator.common.commands.arguments.ISuggestableEnum;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkProcess;

public enum GenerationType implements ISuggestableEnum
{
    TERRAIN_ONLY(0){

        @Override
        public boolean hasSubTask() {
            return false;
        }
    }
    ,
    FAST_CHECK_GEN(1),
    NORMAL_GEN(2, true),
    POST_GEN(3, true),
    BLOCK_POST(4),
    RETROGEN(5, true){

        @Override
        public boolean hasSubTask() {
            return false;
        }

        @Override
        public void startMainTask(long[] chunks, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] tasks, ChunkEntry entry, ChunkProcess task) {
            task.startTask(chunks, 1, tasks);
            ObjectArrayList list = new ObjectArrayList();
            for (int i = 0; i < tasks.length; ++i) {
                ChunkPos pos = new ChunkPos(chunks[i]);
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        list.add(task.getChunk(ChunkPos.func_77272_a((int)(pos.field_77276_a + l), (int)(pos.field_77275_b + k))));
                    }
                }
            }
            entry.setRetrogenTask(CompletableFuture.allOf(list.toArray(new CompletableFuture[list.size()])));
        }

        @Override
        public void unloadMainTask(long[] chunks, int min, int max, ChunkProcess task) {
            task.finishTickets(chunks, min, max, 1);
        }

        @Override
        public void startSubTask(long[] chunks, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] tasks, ChunkProcess task) {
        }

        @Override
        public void unloadSubTask(long[] chunks, int min, int max, ChunkProcess task) {
        }
    };

    int index;
    boolean accurate;

    private GenerationType(int index, boolean accurate) {
        this.index = index;
        this.accurate = accurate;
    }

    private GenerationType(int index) {
        this.index = index;
        this.accurate = false;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean requiresAccurateScan() {
        return this.accurate;
    }

    @Override
    public ITextComponent createSuggestion() {
        switch (this) {
            case BLOCK_POST: {
                return new StringTextComponent("Generates Only the Terrain and Tricks the game into thinking they are fully finished");
            }
            case FAST_CHECK_GEN: {
                return new StringTextComponent("Generates Chunks normally, but with simplifed chunk checks, 100x faster, but 95% accurate");
            }
            case NORMAL_GEN: {
                return new StringTextComponent("Generates Chunks normally and makes deep checks they are fully finished");
            }
            case POST_GEN: {
                return new StringTextComponent("Makes sure that already generated Chunks are fully generated");
            }
            case RETROGEN: {
                return new StringTextComponent("Regenerates Selected Features in already generated Chunks");
            }
            case TERRAIN_ONLY: {
                return new StringTextComponent("Only Generates the Terrain");
            }
        }
        return new StringTextComponent("I AM ERROR");
    }

    public boolean hasSubTask() {
        return true;
    }

    public void startMainTask(long[] chunks, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] tasks, ChunkEntry entry, ChunkProcess task) {
        task.startTask(chunks, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.field_222612_h : ChunkStatus.field_222613_i, tasks);
    }

    public void startSubTask(long[] chunks, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>[] tasks, ChunkProcess task) {
        task.startTask(chunks, ChunkStatus.field_222617_m, tasks);
        task.finishTickets(chunks, 0, chunks.length, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.field_222612_h : ChunkStatus.field_222613_i);
    }

    public void unloadMainTask(long[] chunks, int min, int max, ChunkProcess task) {
        task.finishTickets(chunks, min, max, this == TERRAIN_ONLY || this == BLOCK_POST ? ChunkStatus.field_222612_h : ChunkStatus.field_222613_i);
    }

    public void unloadSubTask(long[] chunks, int min, int max, ChunkProcess task) {
        task.finishTickets(chunks, min, max, ChunkStatus.field_222617_m);
    }
}

