/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.time.Duration;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.tasks.BenchmarkTask;
import pregenerator.common.generator.tasks.CircleExpansionTask;
import pregenerator.common.generator.tasks.CircleTask;
import pregenerator.common.generator.tasks.SquareExpansionTask;
import pregenerator.common.generator.tasks.SquareTask;
import pregenerator.common.generator.tasks.WorldBorderTask;

public interface ITask
extends IBaseTask<ChunkProcess> {
    public static final Int2ObjectMap<Function<CompoundNBT, ITask>> TASK_REGISTRY = new Int2ObjectOpenHashMap();

    public static void init() {
        TASK_REGISTRY.put(1, SquareTask::new);
        TASK_REGISTRY.put(2, CircleTask::new);
        TASK_REGISTRY.put(3, SquareExpansionTask::new);
        TASK_REGISTRY.put(4, CircleExpansionTask::new);
        TASK_REGISTRY.put(5, BenchmarkTask::new);
        TASK_REGISTRY.put(6, WorldBorderTask::new);
    }

    public static ITask loadTask(CompoundNBT nbt) {
        Function creator = (Function)TASK_REGISTRY.get(nbt.func_74762_e("id"));
        if (creator == null) {
            return null;
        }
        ITask task = (ITask)creator.apply(nbt);
        return task == null || !task.isValid() ? null : task;
    }

    public static CompoundNBT saveTask(ITask task) {
        if (task == null) {
            return null;
        }
        CompoundNBT nbt = task.write();
        nbt.func_74774_a("id", task.getId());
        return nbt;
    }

    public static ITextComponent convert(String s, ITextComponent parent, TextFormatting ... formats) {
        StringTextComponent comp = new StringTextComponent(s);
        comp.func_211709_a(formats);
        parent.func_150257_a((ITextComponent)comp);
        return comp;
    }

    public int getGenType();

    public void onCompletion(Duration var1, Duration var2, long var3);
}

