/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.chunk;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.server.permission.PermissionAPI;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.chunk.ChunkTypeRequest;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.tracker.WorldTracker;

public class ChunkTypeRemovalRequest
implements IPregenPacket {
    int index;
    ResourceLocation dimension;
    long pos;
    ResourceLocation type;

    public ChunkTypeRemovalRequest() {
    }

    public ChunkTypeRemovalRequest(int index, ResourceLocation dimension, long pos, ResourceLocation type) {
        this.index = index;
        this.dimension = dimension;
        this.pos = pos;
        this.type = type;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.index);
        buffer.func_192572_a(this.dimension);
        buffer.writeLong(this.pos);
        buffer.func_192572_a(this.type);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.index = buffer.func_150792_a();
        this.dimension = buffer.func_192575_l();
        this.pos = buffer.readLong();
        this.type = buffer.func_192575_l();
    }

    @Override
    public void process(PlayerEntity player) {
        if (!PermissionAPI.hasPermission((PlayerEntity)player, (String)"pregen.mass.deletion")) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Not Enough Permission to do such Action"), false);
            return;
        }
        WorldTracker tracker = ServerTracker.INSTANCE.getWorldTracker(DimensionType.func_193417_a((ResourceLocation)this.dimension));
        if (tracker == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Dimension is Unloaded"), false);
            return;
        }
        int deleted = 0;
        Chunk chunk = tracker.getChunk(this.pos);
        if (chunk == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Chunk is unloaded"), false);
            return;
        }
        switch (this.index) {
            case 0: {
                for (TileEntity tile : new ObjectArrayList(chunk.func_177434_r().values())) {
                    if (!tile.func_200662_C().getRegistryName().equals((Object)this.type)) continue;
                    tracker.getWorld().func_217377_a(tile.func_174877_v(), false);
                    ++deleted;
                }
                break;
            }
            case 1: {
                ClassInheritanceMultiMap[] types = chunk.func_177429_s();
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == null) continue;
                    for (Entity entity : types[i]) {
                        if (!entity.func_200600_R().getRegistryName().equals((Object)this.type)) continue;
                        entity.func_70106_y();
                        ++deleted;
                    }
                }
                break;
            }
        }
        player.func_146105_b((ITextComponent)new StringTextComponent("Removed " + deleted + " of [" + ChunkLogger.toPascalCase(this.type.func_110623_a()) + "]"), false);
        new ChunkTypeRequest(this.index, this.dimension, this.pos).process(player);
    }
}

