/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import pregenerator.common.structures.StructureRef;
import pregenerator.common.structures.StructureTracker;

public class StructureWorld
extends WorldSavedData {
    static final String DATA = "pregen_structure_cache";
    Map<String, StructureTracker> trackers = new Object2ObjectLinkedOpenHashMap();

    public StructureWorld() {
        super(DATA);
    }

    public static StructureWorld getStructures(ServerWorld world) {
        return (StructureWorld)world.func_217481_x().func_215752_a(StructureWorld::new, DATA);
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("data", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            StructureTracker tracker = new StructureTracker(list.func_150305_b(i));
            this.trackers.put(tracker.getName(), tracker);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (StructureTracker tracker : this.trackers.values()) {
            list.add((Object)tracker.write());
        }
        compound.func_218657_a("data", (INBT)list);
        return compound;
    }

    public void addStructure(String name, StructureStart start) {
        if (start == StructureStart.field_214630_a || start == null) {
            return;
        }
        StructureTracker tracker = this.trackers.get(name);
        if (tracker == null) {
            tracker = new StructureTracker(name);
            this.trackers.put(name, tracker);
        }
        tracker.addStructure(start);
        this.func_76185_a();
    }

    public void getStructures(String name, Collection<StructureRef> refs) {
        if (name == null) {
            for (StructureTracker tracker : this.trackers.values()) {
                refs.addAll(tracker.getReferences());
            }
            return;
        }
        StructureTracker tracker = this.trackers.get(name);
        if (tracker != null) {
            refs.addAll(tracker.getReferences());
        }
    }
}

