/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import pregenerator.common.utils.misc.ReflectionHelper;

public class ChunkEntry {
    public int xPos;
    public int zPos;
    public Object2IntLinkedOpenHashMap<ResourceLocation> entityCount = new Object2IntLinkedOpenHashMap();
    public Object2IntLinkedOpenHashMap<ResourceLocation> tileEntityCount = new Object2IntLinkedOpenHashMap();
    public Object2IntLinkedOpenHashMap<ResourceLocation> biomeCount = new Object2IntLinkedOpenHashMap();
    public int entities;
    public int tileEntities;
    public int tickableTileEntities;
    public int randomBlockTicks;

    public int distance(PlayerEntity player, boolean chunk) {
        return this.chunkDistance(chunk ? (long)(this.xPos - (int)(player.func_226277_ct_() / 16.0)) : (long)(this.xPos * 16 + 8 - (int)player.func_226277_ct_()), chunk ? (long)(this.zPos - (int)(player.func_226281_cx_() / 16.0)) : (long)(this.zPos * 16 + 8 - (int)player.func_226281_cx_()));
    }

    int chunkDistance(long distanceX, long distanceZ) {
        return (int)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
    }

    public static ChunkEntry fromChunk(Chunk chunk) {
        ChunkEntry entry = new ChunkEntry();
        entry.xPos = chunk.func_76632_l().field_77276_a;
        entry.zPos = chunk.func_76632_l().field_77275_b;
        ClassInheritanceMultiMap[] entities = chunk.func_177429_s();
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) continue;
            for (Entity entity : entities[i]) {
                entry.entityCount.addTo((Object)entity.func_200600_R().getRegistryName(), 1);
                ++entry.entities;
            }
        }
        for (TileEntity tile : chunk.func_177434_r().values()) {
            entry.tileEntityCount.addTo((Object)tile.func_200662_C().getRegistryName(), 1);
            ++entry.tileEntities;
            entry.tickableTileEntities = entry.tickableTileEntities + (tile instanceof ITickableTileEntity ? 1 : 0);
        }
        for (Biome biome : (Biome[])ReflectionHelper.getValueSave(BiomeContainer.class, chunk.func_225549_i_(), new String[]{"field_227054_f_", "biomes"})) {
            entry.biomeCount.addTo((Object)biome.getRegistryName(), 1);
        }
        ChunkSection[] sections = chunk.func_76587_i();
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i] == null) continue;
            entry.randomBlockTicks += ReflectionHelper.getValueSave(ChunkSection.class, sections[i], (short)0, "blockTickRefCount", "field_76683_c").intValue();
        }
        return entry;
    }

    public static ChunkEntry fromBuffer(PacketBuffer buffer) {
        ResourceLocation location;
        int i;
        ChunkEntry entry = new ChunkEntry();
        entry.xPos = buffer.readInt();
        entry.zPos = buffer.readInt();
        entry.entities = buffer.func_150792_a();
        entry.tileEntities = buffer.func_150792_a();
        entry.tickableTileEntities = buffer.func_150792_a();
        entry.randomBlockTicks = buffer.func_150792_a();
        int size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            location = buffer.func_192575_l();
            entry.entityCount.put((Object)location, buffer.func_150792_a());
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            location = buffer.func_192575_l();
            entry.tileEntityCount.put((Object)location, buffer.func_150792_a());
        }
        size = buffer.func_150792_a();
        for (i = 0; i < size; ++i) {
            location = buffer.func_192575_l();
            entry.biomeCount.put((Object)location, buffer.func_150792_a());
        }
        return entry;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.xPos);
        buffer.writeInt(this.zPos);
        buffer.func_150787_b(this.entities);
        buffer.func_150787_b(this.tileEntities);
        buffer.func_150787_b(this.tickableTileEntities);
        buffer.func_150787_b(this.randomBlockTicks);
        buffer.func_150787_b(this.entityCount.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.entityCount)) {
            buffer.func_192572_a((ResourceLocation)entry.getKey());
            buffer.func_150787_b(entry.getIntValue());
        }
        buffer.func_150787_b(this.tileEntityCount.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.tileEntityCount)) {
            buffer.func_192572_a((ResourceLocation)entry.getKey());
            buffer.func_150787_b(entry.getIntValue());
        }
        buffer.func_150787_b(this.biomeCount.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.biomeCount)) {
            buffer.func_192572_a((ResourceLocation)entry.getKey());
            buffer.func_150787_b(entry.getIntValue());
        }
    }
}

