/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import pregenerator.common.utils.misc.ReflectionHelper;

public class TypeEntry {
    ResourceLocation location;
    int count;

    public TypeEntry(ResourceLocation location, int count) {
        this.location = location;
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.location);
        buffer.func_150787_b(this.count);
    }

    public static TypeEntry read(PacketBuffer buffer) {
        ResourceLocation location = buffer.func_192575_l();
        int count = buffer.func_150792_a();
        return new TypeEntry(location, count);
    }

    public static List<TypeEntry> toList(Object2IntMap<ResourceLocation> locations) {
        ObjectArrayList list = new ObjectArrayList();
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(locations)) {
            list.add(new TypeEntry((ResourceLocation)entry.getKey(), entry.getIntValue()));
        }
        return list;
    }

    public static List<TypeEntry> createTileEntity(ServerWorld world) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        for (TileEntity entity : world.field_147482_g) {
            tiles.addTo((Object)entity.func_200662_C().getRegistryName(), 1);
        }
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createEntities(ServerWorld world) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        world.getEntities().filter(T -> !(T instanceof PlayerEntity)).forEach(T -> tiles.addTo((Object)T.func_200600_R().getRegistryName(), 1));
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createChunkTileEntity(Chunk chunk) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        for (TileEntity entity : chunk.func_177434_r().values()) {
            tiles.addTo((Object)entity.func_200662_C().getRegistryName(), 1);
        }
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createChunkEntities(Chunk chunk) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        ClassInheritanceMultiMap[] entities = chunk.func_177429_s();
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i] == null) continue;
            for (Entity entity : entities[i]) {
                tiles.addTo((Object)entity.func_200600_R().getRegistryName(), 1);
            }
        }
        tiles.removeInt((Object)EntityType.field_200729_aH.getRegistryName());
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createChunkBiomes(Chunk chunks) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        for (Biome biome : (Biome[])ReflectionHelper.getValueSave(BiomeContainer.class, chunks.func_225549_i_(), new String[]{"field_227054_f_", "biomes"})) {
            tiles.addTo((Object)biome.getRegistryName(), 1);
        }
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }
}

