/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;

public class IntCounter {
    final int limit;
    long lastValue;
    long value;
    IntPriorityQueue queue = new IntArrayFIFOQueue();
    long totalValue;

    public IntCounter(int counter) {
        this.limit = counter;
    }

    public void setNewValue(long newValue) {
        this.lastValue = this.value;
        int difference = (int)(newValue - this.value);
        this.value = newValue;
        this.totalValue += (long)difference;
        this.queue.enqueue(difference);
        if (this.queue.size() > this.limit) {
            this.totalValue -= (long)this.queue.dequeueInt();
        }
    }

    public float getTotalValue() {
        return this.totalValue == 0L || this.queue.isEmpty() ? 0.0f : (float)this.totalValue / (float)this.queue.size();
    }

    public long getLastValue() {
        return this.value;
    }

    public void clear() {
        this.lastValue = 0L;
        this.value = 0L;
        this.queue.clear();
        this.totalValue = 0L;
    }
}

