/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace;

import com.github.commoble.jumbofurnace.JumboFurnaceObjects;
import com.github.commoble.jumbofurnace.client.ClientEvents;
import com.github.commoble.jumbofurnace.config.ConfigHelper;
import com.github.commoble.jumbofurnace.config.ServerConfig;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceContainer;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreTileEntity;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceExteriorTileEntity;
import com.github.commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipeSerializer;
import com.github.commoble.jumbofurnace.recipes.RecipeSorter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="jumbofurnace")
public class JumboFurnace {
    public static final String MODID = "jumbofurnace";
    public static final IRecipeType<JumboFurnaceRecipe> JUMBO_SMELTING_RECIPE_TYPE = IRecipeType.func_222147_a((String)"jumbofurnace:jumbo_smelting");
    public static ServerConfig SERVER_CONFIG;

    public JumboFurnace() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        SERVER_CONFIG = ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::new);
        this.addModListeners(modBus);
        this.addForgeListeners(forgeBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.addClientListeners(modBus, forgeBus);
        }
    }

    private void addModListeners(IEventBus modBus) {
        DeferredRegister blocks = this.makeDeferredRegister(modBus, ForgeRegistries.BLOCKS);
        DeferredRegister items = this.makeDeferredRegister(modBus, ForgeRegistries.ITEMS);
        DeferredRegister tileEntities = this.makeDeferredRegister(modBus, ForgeRegistries.TILE_ENTITIES);
        DeferredRegister containers = this.makeDeferredRegister(modBus, ForgeRegistries.CONTAINERS);
        DeferredRegister recipeSerializers = this.makeDeferredRegister(modBus, ForgeRegistries.RECIPE_SERIALIZERS);
        blocks.register("jumbo_furnace", () -> new JumboFurnaceBlock(Block.Properties.func_200950_a((Block)Blocks.field_150460_al)));
        items.register("jumbo_furnace_jei", () -> new Item(new Item.Properties()){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
                tooltip.add((ITextComponent)new TranslationTextComponent("jumbofurnace.jumbo_furnace_info_tooltip", new Object[0]));
            }
        });
        tileEntities.register("jumbo_furnace_core", () -> TileEntityType.Builder.func_223042_a(JumboFurnaceCoreTileEntity::new, (Block[])new Block[]{JumboFurnaceObjects.BLOCK}).func_206865_a(null));
        tileEntities.register("jumbo_furnace_exterior", () -> TileEntityType.Builder.func_223042_a(JumboFurnaceExteriorTileEntity::new, (Block[])new Block[]{JumboFurnaceObjects.BLOCK}).func_206865_a(null));
        containers.register("jumbo_furnace", () -> new ContainerType(JumboFurnaceContainer::getClientContainer));
        recipeSerializers.register("jumbo_smelting", () -> new JumboFurnaceRecipeSerializer(JUMBO_SMELTING_RECIPE_TYPE));
    }

    private <T extends IForgeRegistryEntry<T>> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = new DeferredRegister(registry, MODID);
        register.register(modBus);
        return register;
    }

    private void addForgeListeners(IEventBus forgeBus) {
        forgeBus.addListener(this::onServerStarting);
        forgeBus.addListener(this::onEntityPlaceBlock);
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)RecipeSorter.INSTANCE);
    }

    private void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        block6: {
            Block block = event.getPlacedBlock().func_177230_c();
            if (event instanceof BlockEvent.EntityMultiPlaceEvent || block != Blocks.field_150460_al) break block6;
            IWorld world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState againstState = event.getPlacedAgainst();
            Entity entity = event.getEntity();
            ArrayList stacks = new ArrayList();
            List<BlockSnapshot> snapshots = MultiBlockHelper.getJumboFurnaceStates(world, pos, againstState, entity);
            for (BlockSnapshot snapshot : snapshots) {
                TileEntity te = world.func_175625_s(snapshot.getPos());
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                snapshot.getWorld().func_180501_a(snapshot.getPos(), snapshot.getReplacedBlock(), 3);
            }
            if (!stacks.isEmpty()) {
                if (entity instanceof PlayerEntity) {
                    for (ItemStack stack : stacks) {
                        ((PlayerEntity)entity).func_191521_c(stack);
                    }
                } else {
                    for (ItemStack stack : stacks) {
                        entity.func_199701_a_(stack);
                    }
                }
            }
        }
    }

    private static void addItemsToList(List<ItemStack> stacks, IItemHandler handler) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.extractItem(slot, 64, false);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
    }
}

