/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.jumbo_furnace;

import com.github.commoble.jumbofurnace.JumboFurnace;
import com.github.commoble.jumbofurnace.JumboFurnaceObjects;
import com.github.commoble.jumbofurnace.jumbo_furnace.FuelItemHandler;
import com.github.commoble.jumbofurnace.jumbo_furnace.InputItemHandler;
import com.github.commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import com.github.commoble.jumbofurnace.jumbo_furnace.OutputItemHandler;
import com.github.commoble.jumbofurnace.recipes.ClaimableRecipeWrapper;
import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import com.github.commoble.jumbofurnace.recipes.RecipeSorter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class JumboFurnaceCoreTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final String INPUT = "input";
    public static final String FUEL = "fuel";
    public static final String OUTPUT = "output";
    public static final String COOK_PROGRESS = "cook_progress";
    public static final String BURN_TIME = "burn_time";
    public static final String BURN_VALUE = "burn_value";
    public final InputItemHandler input = new InputItemHandler(this);
    public final ItemStackHandler fuel = new FuelItemHandler(this);
    public final OutputItemHandler output = new OutputItemHandler(this);
    public final LazyOptional<IItemHandler> inputOptional = LazyOptional.of(() -> this.input);
    public final LazyOptional<IItemHandler> fuelOptional = LazyOptional.of(() -> this.fuel);
    public final LazyOptional<IItemHandler> outputOptional = LazyOptional.of(() -> this.output);
    public int burnTimeRemaining = 0;
    public int lastItemBurnedValue = 200;
    public int cookProgress = 0;
    public boolean isRoomToCook = true;
    public boolean canConsumeFuel = false;
    public ClaimableRecipeWrapper cachedRecipes = this.input.getFreshRecipeInput();
    public boolean needsRecipeUpdate = false;
    public boolean needsOutputUpdate = false;
    public boolean needsFuelUpdate = false;

    public JumboFurnaceCoreTileEntity() {
        super(JumboFurnaceObjects.CORE_TE_TYPE);
    }

    public void func_145843_s() {
        this.inputOptional.invalidate();
        this.fuelOptional.invalidate();
        this.outputOptional.invalidate();
        super.func_145843_s();
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.input.deserializeNBT(compound.func_74775_l(INPUT));
        this.fuel.deserializeNBT(compound.func_74775_l(FUEL));
        this.output.deserializeNBT(compound.func_74775_l(OUTPUT));
        this.cookProgress = compound.func_74762_e(COOK_PROGRESS);
        this.burnTimeRemaining = compound.func_74762_e(BURN_TIME);
        this.lastItemBurnedValue = compound.func_74762_e(BURN_VALUE);
        this.onInputInventoryChanged();
        this.onOutputInventoryChanged();
        this.onFuelInventoryChanged();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a(INPUT, (INBT)this.input.serializeNBT());
        compound.func_218657_a(FUEL, (INBT)this.fuel.serializeNBT());
        compound.func_218657_a(OUTPUT, (INBT)this.output.serializeNBT());
        compound.func_74768_a(COOK_PROGRESS, this.cookProgress);
        compound.func_74768_a(BURN_TIME, this.burnTimeRemaining);
        compound.func_74768_a(BURN_VALUE, this.lastItemBurnedValue);
        return compound;
    }

    public int getBurnConsumption() {
        return Math.max(1, this.cachedRecipes.getRecipeCount());
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public void updateBurningBlockstates(boolean burning) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = this.field_174879_c.func_177972_a(direction);
            BlockState state = this.field_145850_b.func_180495_p(adjacentPos);
            if (!(state.func_177230_c() instanceof JumboFurnaceBlock)) continue;
            this.field_145850_b.func_175656_a(adjacentPos, (BlockState)state.func_206870_a((IProperty)JumboFurnaceBlock.LIT, (Comparable)Boolean.valueOf(burning)));
        }
    }

    public void onFuelInventoryChanged() {
        this.needsFuelUpdate = true;
    }

    public void onInputInventoryChanged() {
        this.needsRecipeUpdate = true;
    }

    public void onOutputInventoryChanged() {
        this.needsOutputUpdate = true;
    }

    public void updateRecipes() {
        ClaimableRecipeWrapper wrapper = this.input.getFreshRecipeInput();
        List<JumboFurnaceRecipe> recipes = RecipeSorter.INSTANCE.getSortedFurnaceRecipes(this.field_145850_b.func_199532_z());
        for (JumboFurnaceRecipe recipe : recipes) {
            while (wrapper.getRecipeCount() < JumboFurnace.SERVER_CONFIG.maxSimultaneousRecipes.get() && wrapper.matchAndClaimInputs(recipe, this.field_145850_b) && wrapper.hasUnusedInputsLeft()) {
            }
        }
        this.cachedRecipes = wrapper;
        this.needsRecipeUpdate = false;
        this.needsOutputUpdate = true;
    }

    public void updateOutput() {
        this.isRoomToCook = this.checkIfRoomToCook();
        this.needsOutputUpdate = false;
    }

    public boolean checkIfRoomToCook() {
        int slots = this.output.getSlots();
        ItemStackHandler outputSimulator = new ItemStackHandler(slots);
        for (int slot = 0; slot < slots; ++slot) {
            outputSimulator.setStackInSlot(slot, this.output.getStackInSlot(slot).func_77946_l());
        }
        for (IRecipe<ClaimableRecipeWrapper> recipe : this.cachedRecipes.getRecipes()) {
            ItemStack result = recipe.func_77572_b((IInventory)this.cachedRecipes).func_77946_l();
            for (int slot = 0; slot < slots && !result.func_190926_b(); ++slot) {
                result = outputSimulator.insertItem(slot, result, false);
            }
            if (result.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void updateFuel() {
        this.canConsumeFuel = this.checkIfCanConsumeFuel();
        this.needsFuelUpdate = false;
    }

    public boolean checkIfCanConsumeFuel() {
        int slots = this.fuel.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (ForgeHooks.getBurnTime((ItemStack)this.fuel.getStackInSlot(slot)) <= 0) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        boolean dirty = false;
        boolean wasBurningBeforeTick = this.isBurning();
        if (wasBurningBeforeTick) {
            this.burnTimeRemaining -= this.getBurnConsumption();
            dirty = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean hasSmeltableInputs;
            if (this.needsRecipeUpdate) {
                this.updateRecipes();
            }
            if (this.needsOutputUpdate) {
                this.updateOutput();
            }
            if (this.needsFuelUpdate) {
                this.updateFuel();
            }
            boolean bl = hasSmeltableInputs = this.cachedRecipes.getRecipeCount() > 0;
            if (this.isBurning() || this.canConsumeFuel && hasSmeltableInputs) {
                if (!this.isBurning() && hasSmeltableInputs) {
                    this.consumeFuel();
                }
                if (this.isBurning() && hasSmeltableInputs) {
                    ++this.cookProgress;
                    if (this.cookProgress >= JumboFurnace.SERVER_CONFIG.jumboFurnaceCookTime.get()) {
                        this.cookProgress = 0;
                        this.craft();
                    }
                    dirty = true;
                } else {
                    this.cookProgress = 0;
                    dirty = true;
                }
            } else if (!this.isBurning() && this.cookProgress > 0) {
                this.cookProgress = hasSmeltableInputs ? Math.max(0, this.cookProgress - 2) : 0;
                dirty = true;
            }
            boolean isBurningAfterTick = this.isBurning();
            if (isBurningAfterTick != wasBurningBeforeTick) {
                this.updateBurningBlockstates(isBurningAfterTick);
            }
            if (dirty) {
                this.func_70296_d();
                BlockPos.func_218281_b((BlockPos)this.func_174877_v().func_177982_a(-1, -1, -1), (BlockPos)this.func_174877_v().func_177982_a(1, 1, 1)).forEach(subPos -> {
                    BlockState state = this.field_145850_b.func_180495_p(subPos);
                    this.field_145850_b.func_195592_c(subPos, state.func_177230_c());
                });
            }
        }
    }

    public void consumeFuel() {
        int slots = this.fuel.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = this.fuel.extractItem(slot, 1, true);
            int burnTime = ForgeHooks.getBurnTime((ItemStack)stackInSlot);
            if (burnTime <= 0) continue;
            this.lastItemBurnedValue = burnTime;
            this.fuel.extractItem(slot, 1, false);
            this.burnTimeRemaining += burnTime;
            if (!stackInSlot.hasContainerItem()) break;
            this.fuel.setStackInSlot(slot, stackInSlot.getContainerItem());
            break;
        }
    }

    public void craft() {
        ArrayList<ItemStack> extraItems = new ArrayList<ItemStack>();
        List<IRecipe<ClaimableRecipeWrapper>> recipes = this.cachedRecipes.getRecipes();
        IItemHandler unusedInputs = this.cachedRecipes.getUnusedInputs();
        int unusedInputSlots = unusedInputs.getSlots();
        for (IRecipe<ClaimableRecipeWrapper> recipe : recipes) {
            ItemStack result = recipe.func_77572_b((IInventory)this.cachedRecipes);
            int outputSlots = this.output.getSlots();
            int resultCount = result.func_190916_E();
            for (int slot = 0; slot < outputSlots && !result.func_190926_b(); ++slot) {
                int oldCount = result.func_190916_E();
                result = this.output.insertCraftResult(slot, result, false);
                int newCount = result.func_190916_E();
                int itemsInserted = oldCount - newCount;
                float experience = (float)itemsInserted / (float)resultCount * (recipe instanceof JumboFurnaceRecipe ? ((JumboFurnaceRecipe)recipe).experience : 0.0f);
                this.output.addExperience(slot, experience);
            }
            if (!result.func_190926_b()) {
                extraItems.add(result);
            }
            for (ItemStack stack : recipe.func_179532_b((IInventory)this.cachedRecipes)) {
                ItemStack containerItem = stack.func_77946_l();
                for (int slot = 0; slot < unusedInputSlots && !containerItem.func_190926_b(); ++slot) {
                    containerItem = unusedInputs.insertItem(slot, containerItem, false);
                }
                if (containerItem.func_190926_b()) continue;
                extraItems.add(stack.func_77946_l());
            }
        }
        for (int slot = 0; slot < unusedInputSlots; ++slot) {
            this.input.setStackInSlot(slot, unusedInputs.getStackInSlot(slot));
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2));
        for (ItemStack stack : extraItems) {
            ItemStack stackCopy = stack.func_77946_l();
            if (te != null) {
                stackCopy = (ItemStack)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(handler -> {
                    ItemStack innerStackCopy = stack.func_77946_l();
                    int slots = handler.getSlots();
                    for (int slot = 0; slot < slots; ++slot) {
                        innerStackCopy = handler.insertItem(slot, innerStackCopy, false);
                    }
                    return innerStackCopy;
                }).orElse((Object)stackCopy);
            }
            if (stackCopy.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.field_174879_c.func_177958_n() + 0.5), (double)(this.field_174879_c.func_177956_o() - 1), (double)((double)this.field_174879_c.func_177952_p() + 0.5), (ItemStack)stack);
        }
    }
}

