/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.jumbofurnace.recipes;

import com.github.commoble.jumbofurnace.JumboFurnace;
import com.github.commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;

public class RecipeSorter
extends ReloadListener<Void> {
    public static final RecipeSorter INSTANCE = new RecipeSorter();
    private int currentGeneration = 0;
    private int lastKnownGeneration = -1;
    private List<JumboFurnaceRecipe> cachedSortedRecipes = new ArrayList<JumboFurnaceRecipe>();

    public List<JumboFurnaceRecipe> getSortedFurnaceRecipes(RecipeManager manager) {
        if (this.currentGeneration != this.lastKnownGeneration) {
            this.cachedSortedRecipes = this.sortFurnaceRecipes(manager);
            this.lastKnownGeneration = this.currentGeneration;
        }
        return this.cachedSortedRecipes;
    }

    private List<JumboFurnaceRecipe> sortFurnaceRecipes(RecipeManager manager) {
        Stream<JumboFurnaceRecipe> basicRecipes = manager.func_215366_a(IRecipeType.field_222150_b).values().stream().filter(recipe -> recipe instanceof FurnaceRecipe).map(recipe -> new JumboFurnaceRecipe((FurnaceRecipe)recipe));
        Stream<JumboFurnaceRecipe> advancedRecipes = manager.func_215366_a(JumboFurnace.JUMBO_SMELTING_RECIPE_TYPE).values().stream().filter(recipe -> recipe instanceof JumboFurnaceRecipe).map(recipe -> (JumboFurnaceRecipe)recipe);
        return Streams.concat((Stream[])new Stream[]{basicRecipes, advancedRecipes}).sorted(RecipeSorter::compareRecipes).collect(Collectors.toList());
    }

    public static int compareRecipes(JumboFurnaceRecipe a, JumboFurnaceRecipe b) {
        return b.getSpecificity() - a.getSpecificity();
    }

    protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        return null;
    }

    protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ++this.currentGeneration;
    }
}

