/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.mod.text.Command;
import cam72cam.mod.text.PlayerMessage;
import cam72cam.mod.world.World;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

public class IRCommand
extends Command {
    public String getPrefix() {
        return "immersiverailroading";
    }

    public String getUsage() {
        return "Usage: immersiverailroading (reload|debug)";
    }

    public boolean opRequired() {
        return true;
    }

    public boolean execute(World world, Consumer<PlayerMessage> sender, String[] args) {
        if (args.length != 1) {
            return false;
        }
        if (args[0].equals("reload")) {
            ImmersiveRailroading.warn((String)"Reloading Immersive Railroading definitions", (Object[])new Object[0]);
            try {
                DefinitionManager.initDefinitions();
            }
            catch (IOException e) {
                ImmersiveRailroading.catching((Throwable)e);
            }
            ImmersiveRailroading.info((String)"Done reloading Immersive Railroading definitions", (Object[])new Object[0]);
            return true;
        }
        if (args[0].equals("debug")) {
            List ents = world.getEntities(EntityRollingStock.class);
            ents.sort(Comparator.comparing(a -> a.getUUID().toString()));
            for (EntityRollingStock ent : ents) {
                sender.accept(PlayerMessage.direct((String)String.format("%s : %s - %s : %s", ent.getUUID(), ent.getId(), ent.getDefinitionID(), ent.getPosition())));
            }
            return true;
        }
        return false;
    }
}

