/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.fluid.FluidStack;
import cam72cam.mod.gui.GuiRegistry;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.sound.ISound;
import java.util.List;

public class LocomotiveDiesel
extends Locomotive {
    private ISound horn;
    private ISound idle;
    private float soundThrottle;
    private float internalBurn = 0.0f;
    private int turnOnOffDelay = 0;
    private float hornVolume = 0.0f;
    private static float hornStep = 0.25f;
    @TagSync
    @TagField(value="ENGINE_TEMPERATURE")
    private float engineTemperature = this.ambientTemperature();
    @TagSync
    @TagField(value="TURNED_ON")
    private boolean turnedOn = false;
    @TagSync
    @TagField(value="ENGINE_OVERHEATED")
    private boolean engineOverheated = false;

    @Override
    public int getInventoryWidth() {
        return 2;
    }

    public float getEngineTemperature() {
        return this.engineTemperature;
    }

    private void setEngineTemperature(float temp) {
        this.engineTemperature = temp;
    }

    public void setTurnedOn(boolean value) {
        this.turnedOn = value;
    }

    public boolean isTurnedOn() {
        return this.turnedOn;
    }

    public void setEngineOverheated(boolean value) {
        this.engineOverheated = value;
    }

    public boolean isEngineOverheated() {
        return this.engineOverheated && Config.ConfigBalance.canDieselEnginesOverheat;
    }

    public boolean isRunning() {
        if (!Config.isFuelRequired(this.gauge)) {
            return this.isTurnedOn();
        }
        return this.isTurnedOn() && !this.isEngineOverheated() && this.getLiquidAmount() > 0;
    }

    @Override
    public LocomotiveDieselDefinition getDefinition() {
        return super.getDefinition(LocomotiveDieselDefinition.class);
    }

    @Override
    public GuiRegistry.EntityGUI guiType() {
        return GuiTypes.DIESEL_LOCOMOTIVE;
    }

    @Override
    public void handleKeyPress(Player source, KeyTypes key) {
        switch (key) {
            case START_STOP_ENGINE: {
                if (this.turnOnOffDelay != 0) break;
                this.turnOnOffDelay = 10;
                this.setTurnedOn(!this.isTurnedOn());
                break;
            }
            default: {
                super.handleKeyPress(source, key);
            }
        }
    }

    private void setThrottleMap(EntityRollingStock stock, boolean direction) {
        if (stock instanceof LocomotiveDiesel && ((LocomotiveDiesel)stock).getDefinition().muliUnitCapable) {
            ((LocomotiveDiesel)stock).realSetThrottle(this.getThrottle() * (float)(direction ? 1 : -1));
            ((LocomotiveDiesel)stock).realAirBrake(this.getAirBrake());
        }
    }

    private void realSetThrottle(float newThrottle) {
        if (Config.isFuelRequired(this.gauge)) {
            newThrottle = Math.copySign(Math.min(Math.abs(newThrottle), this.getEngineTemperature() / 100.0f), newThrottle);
        }
        super.setThrottle(newThrottle);
    }

    private void realAirBrake(float newAirBrake) {
        super.setAirBrake(newAirBrake);
    }

    @Override
    public void setThrottle(float newThrottle) {
        this.realSetThrottle(newThrottle);
        if (this.getDefinition().muliUnitCapable) {
            this.mapTrain(this, true, false, this::setThrottleMap);
        }
    }

    @Override
    public void setAirBrake(float newAirBrake) {
        this.realAirBrake(newAirBrake);
        this.mapTrain(this, true, false, this::setThrottleMap);
    }

    @Override
    protected int getAvailableHP() {
        if (this.isRunning() && (this.getEngineTemperature() > 75.0f || !Config.isFuelRequired(this.gauge))) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return 0;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isClient) {
            if (ConfigSound.soundEnabled) {
                float absThrottle;
                if (this.horn == null) {
                    this.bell = ImmersiveRailroading.newSound(this.getDefinition().bell, true, 150.0f, this.soundGauge());
                    this.horn = ImmersiveRailroading.newSound(this.getDefinition().horn, this.getDefinition().getHornSus(), 100.0f, this.soundGauge());
                    this.idle = ImmersiveRailroading.newSound(this.getDefinition().idle, true, 80.0f, this.soundGauge());
                }
                if (this.isRunning()) {
                    if (!this.idle.isPlaying()) {
                        this.idle.play(this.getPosition());
                    }
                } else if (this.idle.isPlaying()) {
                    this.idle.stop();
                }
                if (this.hornTime != 0 && !this.horn.isPlaying() && this.isRunning()) {
                    if (this.getDefinition().getHornSus()) {
                        this.hornVolume = 0.5f;
                        this.horn.setVolume(this.hornVolume);
                    }
                    this.horn.play(this.getPosition());
                } else if (this.hornTime == 0 && this.horn.isPlaying() && this.getDefinition().getHornSus()) {
                    if ((double)this.hornVolume > 0.5) {
                        this.hornVolume = (float)((double)this.hornVolume - 0.25);
                        this.horn.setVolume(this.hornVolume);
                    } else {
                        this.horn.stop();
                    }
                }
                if (this.getDefinition().getHornSus() && this.hornTime != 0 && this.hornVolume < 1.0f) {
                    this.hornVolume = (float)((double)this.hornVolume + 0.25);
                    this.horn.setVolume(this.hornVolume);
                }
                if (this.soundThrottle > (absThrottle = Math.abs(this.getThrottle()))) {
                    this.soundThrottle -= Math.min(0.01f, this.soundThrottle - absThrottle);
                } else if (this.soundThrottle < absThrottle) {
                    this.soundThrottle += Math.min(0.01f, absThrottle - this.soundThrottle);
                }
                if (this.horn.isPlaying()) {
                    this.horn.setPosition(this.getPosition());
                    this.horn.setVelocity(this.getVelocity());
                    this.horn.update();
                }
                if (this.idle.isPlaying()) {
                    this.idle.setPitch(0.7f + this.soundThrottle / 4.0f);
                    this.idle.setVolume(Math.max(0.1f, this.soundThrottle));
                    this.idle.setPosition(this.getPosition());
                    this.idle.setVelocity(this.getVelocity());
                    this.idle.update();
                }
            }
            if (!ConfigGraphics.particlesEnabled) {
                return;
            }
            Vec3d fakeMotion = this.getVelocity();
            List<RenderComponent> exhausts = this.getDefinition().getComponents(RenderComponentType.DIESEL_EXHAUST_X, this.gauge);
            float throttle = Math.abs(this.getThrottle()) + 0.05f;
            if (exhausts != null && this.isRunning()) {
                for (RenderComponent exhaust : exhausts) {
                    Vec3d particlePos = this.getPosition().add(VecUtil.rotateWrongYaw(exhaust.center(), this.getRotationYaw() + 180.0f));
                    particlePos = particlePos.subtract(fakeMotion);
                    double smokeMod = (1.0 + Math.min(1.0, Math.max(0.2, Math.abs(this.getCurrentSpeed().minecraft()) * 2.0))) / 2.0;
                    this.addSmoke(particlePos, new Vec3d(fakeMotion.x, fakeMotion.y + 0.4 * this.gauge.scale(), fakeMotion.z), (int)((double)(40.0f * (1.0f + throttle)) * smokeMod), throttle, throttle, exhaust.width());
                }
            }
            return;
        }
        float engineTemperature = this.getEngineTemperature();
        float heatUpSpeed = 0.0029167f * (float)Config.ConfigBalance.dieselLocoHeatTimeScale / 1.7f;
        float ambientDelta = engineTemperature - this.ambientTemperature();
        float coolDownSpeed = heatUpSpeed * Math.copySign((float)Math.pow(ambientDelta / 130.0f, 2.0), ambientDelta);
        engineTemperature -= coolDownSpeed;
        if (this.getLiquidAmount() > 0 && this.isRunning()) {
            float consumption = Math.abs(this.getThrottle()) + 0.05f;
            float burnTime = BurnUtil.getBurnTime(this.getLiquid());
            if (burnTime == 0.0f) {
                burnTime = 200.0f;
            }
            burnTime *= (float)this.getDefinition().getFuelEfficiency() / 100.0f;
            burnTime *= (float)Config.ConfigBalance.locoDieselFuelEfficiency / 100.0f;
            while (this.internalBurn < 0.0f && this.getLiquidAmount() > 0) {
                this.internalBurn += burnTime;
                this.theTank.drain(new FluidStack(this.theTank.getContents().getFluid(), 1), false);
            }
            consumption *= 100.0f;
            consumption = (float)((double)consumption * this.gauge.scale());
            this.internalBurn -= consumption;
            if ((engineTemperature += heatUpSpeed * (Math.abs(this.getThrottle()) + 0.2f)) > 150.0f) {
                engineTemperature = 150.0f;
                this.setEngineOverheated(true);
            }
        }
        if (engineTemperature < 100.0f && this.isEngineOverheated()) {
            this.setEngineOverheated(false);
        }
        if (this.turnOnOffDelay > 0) {
            --this.turnOnOffDelay;
        }
        this.setEngineTemperature(engineTemperature);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.idle != null) {
            this.idle.stop();
        }
        if (this.horn != null) {
            this.horn.stop();
        }
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return BurnUtil.burnableFluids();
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getFuelCapacity(this.gauge);
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setEngineTemperature(this.ambientTemperature());
        this.setEngineOverheated(false);
        this.setTurnedOn(false);
    }
}

