/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.mod.math.Vec3d;
import java.util.List;

public class MultiRenderComponent {
    private final Vec3d min;
    private final Vec3d max;
    public final double scale;

    public MultiRenderComponent(List<RenderComponent> subComponents) {
        double minX = subComponents.get((int)0).min.x;
        double minY = subComponents.get((int)0).min.y;
        double minZ = subComponents.get((int)0).min.z;
        double maxX = subComponents.get((int)0).max.x;
        double maxY = subComponents.get((int)0).max.y;
        double maxZ = subComponents.get((int)0).max.z;
        for (RenderComponent rc : subComponents) {
            minX = Math.min(minX, rc.min.x);
            minY = Math.min(minY, rc.min.y);
            minZ = Math.min(minZ, rc.min.z);
            maxX = Math.max(maxX, rc.max.x);
            maxY = Math.max(maxY, rc.max.y);
            maxZ = Math.max(maxZ, rc.max.z);
        }
        this.min = new Vec3d(minX, minY, minZ);
        this.max = new Vec3d(maxX, maxY, maxZ);
        this.scale = subComponents.get((int)0).scale;
    }

    private MultiRenderComponent(Vec3d min, Vec3d max, double scale) {
        this.min = min;
        this.max = max;
        this.scale = scale;
    }

    public MultiRenderComponent scale(Gauge gauge) {
        return new MultiRenderComponent(this.min, this.max, gauge.scale());
    }

    public Vec3d center() {
        Vec3d min = this.min.scale(this.scale);
        Vec3d max = this.max.scale(this.scale);
        return new Vec3d((min.x + max.x) / 2.0, (min.y + max.y) / 2.0, (min.z + max.z) / 2.0);
    }

    public double height() {
        Vec3d min = this.min.scale(this.scale);
        Vec3d max = this.max.scale(this.scale);
        return max.y - min.y;
    }
}

