/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.CraftingMachineMode;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.ItemCastingCost;
import cam72cam.mod.energy.IEnergy;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.world.World;
import java.util.List;

public class CastingMultiblock
extends Multiblock {
    private static Multiblock.FuzzyProvider STONE = () -> Fuzzy.STONE_BRICK;
    private static Multiblock.FuzzyProvider SAND = () -> Fuzzy.SAND;
    public static final String NAME = "CASTING";
    private static final Vec3i render = new Vec3i(3, 3, 7);
    private static final Vec3i fluid = new Vec3i(3, 3, 3);
    private static final Vec3i craft = new Vec3i(3, 2, 3);
    private static final Vec3i output = new Vec3i(3, 2, 14);
    private static final Vec3i power = new Vec3i(3, 7, 0);
    public static final double max_volume = 810.0;

    private static Multiblock.FuzzyProvider[][][] cast_blueprint() {
        int z;
        Multiblock.FuzzyProvider[][][] bp = new Multiblock.FuzzyProvider[23][][];
        for (z = 0; z < 7; ++z) {
            Multiblock.FuzzyProvider[] base = new Multiblock.FuzzyProvider[]{AIR, AIR, AIR, AIR, AIR, AIR, AIR};
            if (z > 0 && z < 6) {
                base = z > 1 && z < 5 ? new Multiblock.FuzzyProvider[]{AIR, CastingMultiblock.S_SCAF(), CastingMultiblock.S_SCAF(), CastingMultiblock.S_SCAF(), CastingMultiblock.S_SCAF(), CastingMultiblock.S_SCAF(), AIR} : new Multiblock.FuzzyProvider[]{AIR, AIR, CastingMultiblock.S_SCAF(), CastingMultiblock.S_SCAF(), CastingMultiblock.S_SCAF(), AIR, AIR};
            }
            Multiblock.FuzzyProvider[] top = new Multiblock.FuzzyProvider[]{AIR, AIR, CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), AIR, AIR};
            Multiblock.FuzzyProvider[] topfirst = new Multiblock.FuzzyProvider[]{AIR, AIR, CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), AIR, AIR};
            if (z > 0 && z < 6) {
                if (z > 1 && z < 5) {
                    top = new Multiblock.FuzzyProvider[]{CastingMultiblock.CASING(), AIR, AIR, AIR, AIR, AIR, CastingMultiblock.CASING()};
                    topfirst = new Multiblock.FuzzyProvider[]{CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.CASING()};
                } else {
                    top = new Multiblock.FuzzyProvider[]{AIR, CastingMultiblock.CASING(), AIR, AIR, AIR, CastingMultiblock.CASING(), AIR};
                    topfirst = new Multiblock.FuzzyProvider[]{AIR, CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), CastingMultiblock.CASING(), AIR};
                }
            }
            bp[z] = new Multiblock.FuzzyProvider[8][];
            for (int y = 0; y < 8; ++y) {
                bp[z][y] = y < 3 ? base : (y == 3 ? topfirst : top);
            }
        }
        for (z = 7; z < 23; ++z) {
            bp[z] = z == 7 ? new Multiblock.FuzzyProvider[][]{{AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, AIR, AIR, CastingMultiblock.STEEL(), AIR, AIR, AIR}} : (z == 22 ? new Multiblock.FuzzyProvider[][]{{AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}} : new Multiblock.FuzzyProvider[][]{{AIR, STONE, SAND, SAND, SAND, STONE, AIR}, {AIR, STONE, SAND, SAND, SAND, STONE, AIR}, {AIR, STONE, SAND, SAND, SAND, STONE, AIR}});
        }
        return bp;
    }

    public CastingMultiblock() {
        super(NAME, CastingMultiblock.cast_blueprint());
    }

    @Override
    public Vec3i placementPos() {
        return new Vec3i(3, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, Vec3i origin, Rotation rot) {
        return new CastingInstance(world, origin, rot);
    }

    public class CastingInstance
    extends Multiblock.MultiblockInstance {
        public CastingInstance(World world, Vec3i origin, Rotation rot) {
            super(CastingMultiblock.this, world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(Player player, Player.Hand hand, Vec3i offset) {
            TileMultiblock outTe = this.getTile(output);
            if (outTe == null) {
                return false;
            }
            TileMultiblock craftTe = this.getTile(craft);
            if (craftTe == null) {
                return false;
            }
            if (!outTe.getContainer().get(0).isEmpty()) {
                if (this.world.isServer) {
                    this.world.dropItem(outTe.getContainer().get(0), player.getPosition());
                    outTe.getContainer().set(0, ItemStack.EMPTY);
                }
            } else if (this.world.isClient) {
                Vec3i pos = this.getPos(craft);
                GuiTypes.CASTING.open(player, pos);
            }
            return true;
        }

        @Override
        public boolean isRender(Vec3i offset) {
            return render.equals((Object)offset);
        }

        @Override
        public int getInvSize(Vec3i offset) {
            return output.equals((Object)offset) ? 1 : 0;
        }

        @Override
        public void tick(Vec3i offset) {
            TileMultiblock fluidTe;
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            IEnergy energy = powerTe.getEnergy(null);
            if (this.world.isClient) {
                if (offset.z > 7 && offset.y > 1 && this.isPouring()) {
                    Vec3d pos = new Vec3d(this.getPos(offset)).add(0.0, 1.0, 0.0).add(0.5, 0.5, 0.5);
                    if (Math.random() < 0.01) {
                        this.world.createParticle(World.ParticleType.SMOKE, pos, Vec3d.ZERO);
                        this.world.createParticle(World.ParticleType.SMOKE, pos, Vec3d.ZERO);
                    }
                    if (Math.random() < 0.001) {
                        Audio.playSound((World)this.world, (Vec3d)pos, (StandardSound)StandardSound.BLOCK_FIRE_EXTINGUISH, (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, (float)0.25f);
                    }
                }
                return;
            }
            if (offset.equals((Object)fluid)) {
                fluidTe = this.getTile(fluid);
                if (fluidTe == null) {
                    return;
                }
                IBoundingBox meltBounds = IBoundingBox.from((Vec3i)this.getPos(offset.add(0, 1, 0))).grow(new Vec3d(2.0, 0.0, 2.0));
                IBoundingBox damageBounds = meltBounds.expand(new Vec3d(0.0, 2.5, 0.0));
                List dropped = this.world.getDroppedItems(meltBounds);
                for (Object stack : dropped) {
                    ItemStack craftStack = stack.copy();
                    int cost = ItemCastingCost.getCastCost(craftStack);
                    if (cost != -999) {
                        cost /= craftStack.getCount();
                        while (stack.getCount() != 0 && (double)fluidTe.getCraftProgress() < 810.0 + (double)cost && this.hasPower()) {
                            energy.extract(this.powerRequired(), false);
                            stack.shrink(1);
                            fluidTe.setCraftProgress(fluidTe.getCraftProgress() + cost);
                        }
                        continue;
                    }
                    if (fluidTe.getCraftProgress() <= 0) continue;
                    stack.setCount(0);
                }
                List living = this.world.getEntities(ent -> (ent.isPlayer() || ent.isLiving()) && ent.getBounds().intersects(damageBounds), Entity.class);
                for (Entity alive : living) {
                    alive.directDamage("immersiverailroading:casting", 5.0);
                }
            }
            if (offset.equals((Object)craft)) {
                if (!this.hasPower()) {
                    return;
                }
                fluidTe = this.getTile(fluid);
                if (fluidTe == null) {
                    return;
                }
                TileMultiblock craftTe = this.getTile(craft);
                if (craftTe == null) {
                    return;
                }
                TileMultiblock outTe = this.getTile(output);
                if (outTe == null) {
                    return;
                }
                ItemStack item = craftTe.getCraftItem();
                if (item == null || item.isEmpty()) {
                    return;
                }
                CraftingMachineMode mode = craftTe.getCraftMode();
                if (mode == CraftingMachineMode.STOPPED) {
                    return;
                }
                if (!outTe.getContainer().get(0).isEmpty()) {
                    return;
                }
                int cost = ItemCastingCost.getCastCost(item);
                if (cost == -999) {
                    return;
                }
                if (craftTe.getCraftProgress() >= cost) {
                    ItemStack outputItem;
                    craftTe.setCraftProgress(0);
                    if (mode == CraftingMachineMode.SINGLE) {
                        craftTe.setCraftMode(CraftingMachineMode.STOPPED);
                    }
                    if ((outputItem = item.copy()).getTagCompound().isEmpty()) {
                        outputItem.clearTagCompound();
                    }
                    outTe.getContainer().set(0, outputItem);
                } else if (craftTe.getRenderTicks() % 10L == 0L && fluidTe.getCraftProgress() > 0) {
                    fluidTe.setCraftProgress(fluidTe.getCraftProgress() - 1);
                    craftTe.setCraftProgress(craftTe.getCraftProgress() + 1);
                }
            }
            if (offset.equals((Object)power)) {
                energy.extract(this.powerRequired(), false);
            }
        }

        @Override
        public boolean canInsertItem(Vec3i offset, int slot, ItemStack stack) {
            return false;
        }

        @Override
        public boolean isOutputSlot(Vec3i offset, int slot) {
            return false;
        }

        @Override
        public int getSlotLimit(Vec3i offset, int slot) {
            return output.equals((Object)offset) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(Vec3i offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            return powerTe.getEnergy(null).getCurrent() >= this.powerRequired();
        }

        public boolean isPouring() {
            TileMultiblock craftTe = this.getTile(craft);
            if (craftTe == null) {
                return false;
            }
            TileMultiblock fluidTe = this.getTile(fluid);
            if (fluidTe == null) {
                return false;
            }
            return craftTe.getCraftProgress() > 0 && fluidTe.getCraftProgress() > 0;
        }

        public double getSteelLevel() {
            TileMultiblock fluidTe = this.getTile(fluid);
            if (fluidTe == null) {
                return 0.0;
            }
            return (double)fluidTe.getCraftProgress() / 810.0;
        }

        public ItemStack getCraftItem() {
            TileMultiblock craftingTe = this.getTile(craft);
            if (craftingTe == null) {
                return ItemStack.EMPTY;
            }
            return craftingTe.getCraftItem();
        }

        private int powerRequired() {
            return (int)Math.ceil(32.0f * Config.ConfigBalance.machinePowerFactor);
        }
    }
}

