/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.resource.Identifier;
import com.google.gson.JsonObject;
import java.util.Set;

public class LocomotiveDieselDefinition
extends LocomotiveDefinition {
    private static Identifier default_idle = new Identifier("immersiverailroading", "sounds/diesel/default/idle.ogg");
    private static Identifier default_horn = new Identifier("immersiverailroading", "sounds/diesel/default/horn.ogg");
    private static Identifier default_bell = new Identifier("immersiverailroading", "sounds/diesel/default/bell.ogg");
    public Identifier idle;
    public Identifier horn;
    public Identifier bell;
    public boolean muliUnitCapable;
    private FluidQuantity fuelCapacity;
    private int fuelEfficiency;
    private boolean hornSus;

    public LocomotiveDieselDefinition(String defID, JsonObject data) throws Exception {
        super(LocomotiveDiesel.class, defID, data);
        if (this.fuelCapacity == null) {
            this.fuelCapacity = FluidQuantity.ZERO;
        }
    }

    @Override
    protected Set<String> parseComponents() {
        Set<String> groups = super.parseComponents();
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FUEL_TANK, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.ALTERNATOR, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.ENGINE_BLOCK, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.CRANKSHAFT, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.GEARBOX, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FLUID_COUPLING, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FINAL_DRIVE, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.TORQUE_CONVERTER, this, groups), true);
        for (int i = 100; i >= 0; --i) {
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.PISTON_X, this, groups, i), true);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.DIESEL_EXHAUST_X, this, groups, i), false);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.FAN_X, this, groups, i), true);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.DRIVE_SHAFT_X, this, groups, i), true);
        }
        return groups;
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.fuelCapacity = FluidQuantity.FromLiters((int)Math.ceil((double)properties.get("fuel_capacity_l").getAsInt() * this.internal_inv_scale * 10.0));
        this.fuelEfficiency = properties.get("fuel_efficiency_%").getAsInt();
        this.muliUnitCapable = !properties.has("multi_unit_capable") || properties.get("multi_unit_capable").getAsBoolean();
        this.hornSus = false;
        if (properties.has("horn_sustained")) {
            this.hornSus = properties.get("horn_sustained").getAsBoolean();
        }
        JsonObject sounds = data.has("sounds") ? data.get("sounds").getAsJsonObject() : null;
        this.idle = default_idle;
        this.horn = default_horn;
        this.bell = default_bell;
        if (sounds != null) {
            if (sounds.has("idle")) {
                this.idle = new Identifier("immersiverailroading", sounds.get("idle").getAsString()).getOrDefault(default_idle);
            }
            if (sounds.has("horn")) {
                this.horn = new Identifier("immersiverailroading", sounds.get("horn").getAsString()).getOrDefault(default_horn);
            }
            if (sounds.has("bell")) {
                this.bell = new Identifier("immersiverailroading", sounds.get("bell").getAsString()).getOrDefault(default_bell);
            }
        }
    }

    public boolean getHornSus() {
        return this.hornSus;
    }

    public FluidQuantity getFuelCapacity(Gauge gauge) {
        return this.fuelCapacity.scale(gauge.scale()).min(FluidQuantity.FromBuckets(1)).roundBuckets();
    }

    public int getFuelEfficiency() {
        return this.fuelEfficiency;
    }
}

