/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.registry.Quilling;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.resource.Identifier;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Set;

public class LocomotiveSteamDefinition
extends LocomotiveDefinition {
    private static Identifier default_whistle = new Identifier("immersiverailroading", "sounds/steam/default/whistle.ogg");
    private static Identifier default_idle = new Identifier("immersiverailroading", "sounds/steam/default/idle.ogg");
    private static Identifier default_chuff = new Identifier("immersiverailroading", "sounds/steam/default/chuff.ogg");
    private static Identifier default_pressure = new Identifier("immersiverailroading", "sounds/steam/default/pressure.ogg");
    private static Identifier default_bell = new Identifier("immersiverailroading", "sounds/steam/default/bell.ogg");
    public Quilling quill;
    public Identifier whistle;
    public Identifier idle;
    public Identifier chuff;
    public Identifier pressure;
    public Identifier bell;
    private FluidQuantity tankCapacity;
    private int maxPSI;
    private ValveGearType valveGear;
    private int numSlots;
    private int width;
    public boolean tender_auto_feed;

    public LocomotiveSteamDefinition(String defID, JsonObject data) throws Exception {
        super(LocomotiveSteam.class, defID, data);
        if (this.tankCapacity == null) {
            this.tankCapacity = FluidQuantity.ZERO;
        }
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.tankCapacity = FluidQuantity.FromLiters((int)Math.ceil((double)properties.get("water_capacity_l").getAsInt() * this.internal_inv_scale));
        this.maxPSI = (int)Math.ceil((double)properties.get("max_psi").getAsInt() * this.internal_inv_scale);
        this.valveGear = ValveGearType.valueOf(properties.get("valve_gear").getAsString().toUpperCase());
        JsonObject firebox = data.get("firebox").getAsJsonObject();
        this.numSlots = (int)Math.ceil((double)firebox.get("slots").getAsInt() * this.internal_inv_scale);
        this.width = (int)Math.ceil((double)firebox.get("width").getAsInt() * this.internal_inv_scale);
        this.tender_auto_feed = properties.has("tender_auto_feed") ? properties.get("tender_auto_feed").getAsBoolean() : true;
        JsonObject sounds = data.has("sounds") ? data.get("sounds").getAsJsonObject() : null;
        this.whistle = default_whistle;
        this.idle = default_idle;
        this.chuff = default_chuff;
        this.pressure = default_pressure;
        this.bell = default_bell;
        boolean whistleSet = false;
        if (sounds != null) {
            if (sounds.has("whistle")) {
                this.whistle = new Identifier("immersiverailroading", sounds.get("whistle").getAsString()).getOrDefault(default_whistle);
                whistleSet = true;
            }
            if (sounds.has("idle")) {
                this.idle = new Identifier("immersiverailroading", sounds.get("idle").getAsString()).getOrDefault(default_idle);
            }
            if (sounds.has("chuff")) {
                this.chuff = new Identifier("immersiverailroading", sounds.get("chuff").getAsString()).getOrDefault(default_chuff);
            }
            if (sounds.has("pressure")) {
                this.pressure = new Identifier("immersiverailroading", sounds.get("pressure").getAsString()).getOrDefault(default_pressure);
            }
            if (sounds.has("bell")) {
                this.bell = new Identifier("immersiverailroading", sounds.get("bell").getAsString()).getOrDefault(default_bell);
            }
            if (sounds.has("quilling")) {
                this.quill = new Quilling(sounds.get("quilling").getAsJsonArray());
                whistleSet = true;
            }
        }
        if (!(whistleSet || this.quill != null && this.quill.canLoad())) {
            this.quill = new Quilling(new Identifier("immersiverailroading", "sounds/steam/default/quill.ogg"));
        }
    }

    @Override
    protected boolean unifiedBogies() {
        return false;
    }

    @Override
    protected Set<String> parseComponents() {
        int i;
        Set<String> groups = super.parseComponents();
        switch (this.valveGear) {
            case STEPHENSON: 
            case WALSCHAERTS: 
            case TRI_WALSCHAERTS: 
            case HIDDEN: {
                for (i = 100; i >= 0; --i) {
                    this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.WHEEL_DRIVER_X, this, groups, i), true);
                }
                break;
            }
            case T1: 
            case GARRAT: 
            case MALLET_WALSCHAERTS: {
                for (i = 100; i >= 0; --i) {
                    this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.WHEEL_DRIVER_FRONT_X, this, groups, i), true);
                    this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.WHEEL_DRIVER_REAR_X, this, groups, i), true);
                }
                this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FRONT_LOCOMOTIVE, this, groups), true);
                break;
            }
            case CLIMAX: {
                break;
            }
        }
        for (i = 100; i >= 0; --i) {
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.BOILER_SEGMENT_X, this, groups, i), true);
        }
        for (i = 100; i >= 0; --i) {
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.PARTICLE_CHIMNEY_X, this, groups, i), false);
            this.addComponentIfExists(RenderComponent.parseID(RenderComponentType.PRESSURE_VALVE_X, this, groups, i), false);
        }
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.FIREBOX, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.SMOKEBOX, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.STEAM_CHEST_FRONT, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.STEAM_CHEST_REAR, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.STEAM_CHEST, this, groups), true);
        this.addComponentIfExists(RenderComponent.parse(RenderComponentType.PIPING, this, groups), true);
        ArrayList<String> sides = new ArrayList<String>();
        switch (this.valveGear) {
            case TRI_WALSCHAERTS: {
                sides.add("CENTER");
            }
            case STEPHENSON: 
            case WALSCHAERTS: {
                sides.add("RIGHT");
                sides.add("LEFT");
            }
            case T1: 
            case GARRAT: 
            case MALLET_WALSCHAERTS: {
                if (sides.size() == 0) {
                    sides.add("LEFT_FRONT");
                    sides.add("RIGHT_FRONT");
                    sides.add("LEFT_REAR");
                    sides.add("RIGHT_REAR");
                }
                RenderComponentType[] components = new RenderComponentType[]{RenderComponentType.SIDE_ROD_SIDE, RenderComponentType.MAIN_ROD_SIDE, RenderComponentType.PISTON_ROD_SIDE, RenderComponentType.CYLINDER_SIDE, RenderComponentType.UNION_LINK_SIDE, RenderComponentType.COMBINATION_LEVER_SIDE, RenderComponentType.VALVE_STEM_SIDE, RenderComponentType.RADIUS_BAR_SIDE, RenderComponentType.EXPANSION_LINK_SIDE, RenderComponentType.ECCENTRIC_ROD_SIDE, RenderComponentType.ECCENTRIC_CRANK_SIDE, RenderComponentType.REVERSING_ARM_SIDE, RenderComponentType.LIFTING_LINK_SIDE, RenderComponentType.REACH_ROD_SIDE};
                for (String side : sides) {
                    for (RenderComponentType name : components) {
                        this.addComponentIfExists(RenderComponent.parseSide(name, this, groups, side), true);
                    }
                }
            }
            case CLIMAX: {
                break;
            }
            case SHAY: {
                break;
            }
        }
        return groups;
    }

    public FluidQuantity getTankCapacity(Gauge gauge) {
        return this.tankCapacity.scale(gauge.scale()).min(FluidQuantity.FromBuckets(1)).roundBuckets();
    }

    public int getMaxPSI(Gauge gauge) {
        return (int)Math.ceil((double)this.maxPSI * gauge.scale());
    }

    public ValveGearType getValveGear() {
        return this.valveGear;
    }

    public int getInventorySize(Gauge gauge) {
        return (int)Math.ceil((double)this.numSlots * gauge.scale());
    }

    public int getInventoryWidth(Gauge gauge) {
        return (int)Math.max(3.0, Math.ceil((double)this.width * gauge.scale()));
    }
}

