/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render;

import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.entity.StockModel;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.obj.OBJRender;
import java.util.HashMap;
import java.util.Map;

public class StockRenderCache {
    private static Map<String, StockModel> render_cache = new HashMap<String, StockModel>();
    private static Map<TrackModel, OBJRender> track_cache = new HashMap<TrackModel, OBJRender>();

    public static void clearRenderCache() {
        for (StockModel stockModel : render_cache.values()) {
            stockModel.free();
        }
        for (OBJRender oBJRender : track_cache.values()) {
            oBJRender.free();
        }
        render_cache = new HashMap<String, StockModel>();
        track_cache = new HashMap<TrackModel, OBJRender>();
    }

    public static StockModel getRender(String defID) {
        EntityRollingStockDefinition def;
        if (!render_cache.containsKey(defID) && (def = DefinitionManager.getDefinition(defID)) != null) {
            render_cache.put(defID, new StockModel(def.getModel(), def.textureNames.keySet()));
        }
        return render_cache.get(defID);
    }

    public static OBJRender getTrackRenderer(TrackModel model) {
        if (!track_cache.containsKey((Object)model)) {
            track_cache.put(model, new OBJRender((OBJModel)model));
        }
        return track_cache.get((Object)model);
    }
}

