/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.entity;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.MultiRenderComponent;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.obj.OBJRender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class StockModel
extends OBJRender {
    private static final int MALLET_ANGLE_REAR = -45;
    private boolean isBuilt;
    private List<RenderComponentType> availComponents;
    private double distanceTraveled;

    public StockModel(OBJModel objModel, Collection<String> textureNames) {
        super(objModel, textureNames, ConfigGraphics.textureCacheSeconds);
    }

    private void initComponents(EntityBuildableRollingStock stock) {
        this.isBuilt = stock.isBuilt();
        if (!this.isBuilt) {
            this.availComponents = new ArrayList<RenderComponentType>();
            for (ItemComponentType item : stock.getItemComponents()) {
                this.availComponents.addAll(item.render);
            }
        }
    }

    private void drawComponent(RenderComponent component) {
        if (component != null) {
            if (!this.isBuilt) {
                if (!this.availComponents.contains((Object)component.type)) {
                    return;
                }
                this.availComponents.remove((Object)component.type);
            }
            MinecraftClient.startProfiler((String)"render");
            try (OpenGL.With matrix = OpenGL.matrix();){
                GL11.glScaled((double)component.scale, (double)component.scale, (double)component.scale);
                this.drawGroups(component.modelIDs);
            }
            MinecraftClient.endProfiler();
        }
    }

    private void drawComponents(List<RenderComponent> components) {
        if (components == null) {
            return;
        }
        for (RenderComponent component : components) {
            this.drawComponent(component);
        }
    }

    public void draw(EntityRollingStock stock, float partialTicks) {
        boolean isFarAway;
        boolean bl = isFarAway = MinecraftClient.getPlayer().getPosition().distanceTo(stock.getPosition()) > 100.0;
        if (stock instanceof EntityMoveableRollingStock) {
            EntityMoveableRollingStock mstock = (EntityMoveableRollingStock)stock;
            this.distanceTraveled = (double)mstock.distanceTraveled + mstock.getCurrentSpeed().minecraft() * (double)mstock.getTickSkew() * (double)partialTicks * 1.1;
        } else {
            this.distanceTraveled = 0.0;
        }
        try (OpenGL.With tex = this.bindTexture(stock.getTexture(), isFarAway);){
            if (stock instanceof LocomotiveSteam) {
                this.drawSteamLocomotive((LocomotiveSteam)stock);
            } else if (stock instanceof LocomotiveDiesel) {
                this.drawDieselLocomotive((LocomotiveDiesel)stock);
            } else if (stock instanceof EntityMoveableRollingStock) {
                this.drawStandardStock((EntityMoveableRollingStock)stock);
            } else {
                this.draw();
            }
            this.drawCargo(stock);
        }
    }

    public void drawCargo(EntityRollingStock stock) {
        if (stock instanceof Freight) {
            Freight freight = (Freight)stock;
            FreightDefinition def = freight.getDefinition();
            int fill = freight.getPercentCargoFull();
            List<RenderComponent> cargoLoads = def.getComponents(RenderComponentType.CARGO_FILL_X, stock.gauge);
            if (cargoLoads != null) {
                for (RenderComponent cargoLoad : cargoLoads) {
                    if (cargoLoad.id > fill) continue;
                    this.drawComponent(cargoLoad);
                    if (!def.shouldShowCurrentLoadOnly()) continue;
                    break;
                }
            }
        }
    }

    private void drawStandardStock(EntityMoveableRollingStock stock) {
        EntityRollingStockDefinition def;
        block50: {
            Throwable throwable;
            OpenGL.With wheelMatrix;
            Vec3d wheelPos;
            double relDist;
            double circumference;
            List<RenderComponent> wheels2;
            Throwable throwable2;
            OpenGL.With matrix;
            block49: {
                def = stock.getDefinition();
                this.initComponents(stock);
                this.drawComponent(def.getComponent(RenderComponentType.FRAME, stock.gauge));
                this.drawComponent(def.getComponent(RenderComponentType.SHELL, stock.gauge));
                this.drawFrameWheels(stock);
                if (def.getComponent(RenderComponentType.BOGEY_POS, "FRONT", stock.gauge) != null) {
                    matrix = OpenGL.matrix();
                    throwable2 = null;
                    try {
                        GL11.glTranslated((double)(-def.getBogeyFront(stock.gauge)), (double)0.0, (double)0.0);
                        GL11.glRotated((double)(180.0f - stock.getFrontYaw()), (double)0.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)(-(180.0f - stock.getRotationYaw())), (double)0.0, (double)1.0, (double)0.0);
                        GL11.glTranslated((double)def.getBogeyFront(stock.gauge), (double)0.0, (double)0.0);
                        this.drawComponent(def.getComponent(RenderComponentType.BOGEY_POS, "FRONT", stock.gauge));
                        wheels2 = def.getComponents(RenderComponentType.BOGEY_POS_WHEEL_X, "FRONT", stock.gauge);
                        if (wheels2 == null) break block49;
                        for (RenderComponent wheel : wheels2) {
                            circumference = wheel.height() * 3.1415927410125732;
                            relDist = this.distanceTraveled % circumference;
                            wheelPos = wheel.center();
                            wheelMatrix = OpenGL.matrix();
                            throwable = null;
                            try {
                                GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
                                GL11.glRotated((double)((float)(360.0 * relDist / circumference)), (double)0.0, (double)0.0, (double)1.0);
                                GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
                                this.drawComponent(wheel);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (wheelMatrix == null) continue;
                                if (throwable != null) {
                                    try {
                                        wheelMatrix.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                wheelMatrix.close();
                            }
                        }
                    }
                    catch (Throwable wheels2) {
                        throwable2 = wheels2;
                        throw wheels2;
                    }
                    finally {
                        if (matrix != null) {
                            if (throwable2 != null) {
                                try {
                                    matrix.close();
                                }
                                catch (Throwable wheels2) {
                                    throwable2.addSuppressed(wheels2);
                                }
                            } else {
                                matrix.close();
                            }
                        }
                    }
                }
            }
            if (def.getComponent(RenderComponentType.BOGEY_POS, stock.gauge) != null) {
                matrix = OpenGL.matrix();
                throwable2 = null;
                try {
                    GL11.glTranslated((double)(-def.getBogeyRear(stock.gauge)), (double)0.0, (double)0.0);
                    GL11.glRotated((double)(180.0f - stock.getRearYaw()), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)(-(180.0f - stock.getRotationYaw())), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslated((double)def.getBogeyRear(stock.gauge), (double)0.0, (double)0.0);
                    this.drawComponent(def.getComponent(RenderComponentType.BOGEY_POS, "REAR", stock.gauge));
                    wheels2 = def.getComponents(RenderComponentType.BOGEY_POS_WHEEL_X, "REAR", stock.gauge);
                    if (wheels2 == null) break block50;
                    for (RenderComponent wheel : wheels2) {
                        circumference = wheel.height() * 3.1415927410125732;
                        relDist = this.distanceTraveled % circumference;
                        wheelPos = wheel.center();
                        wheelMatrix = OpenGL.matrix();
                        throwable = null;
                        try {
                            GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
                            GL11.glRotated((double)((float)(360.0 * relDist / circumference)), (double)0.0, (double)0.0, (double)1.0);
                            GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
                            this.drawComponent(wheel);
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (wheelMatrix == null) continue;
                            if (throwable != null) {
                                try {
                                    wheelMatrix.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            wheelMatrix.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (matrix != null) {
                        if (throwable2 != null) {
                            try {
                                matrix.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            matrix.close();
                        }
                    }
                }
            }
        }
        if (this.isBuilt) {
            this.drawComponent(def.getComponent(RenderComponentType.REMAINING, stock.gauge));
        }
    }

    private void drawFrameWheels(EntityMoveableRollingStock stock) {
        EntityRollingStockDefinition def = stock.getDefinition();
        List<RenderComponent> wheels = def.getComponents(RenderComponentType.FRAME_WHEEL_X, stock.gauge);
        if (wheels != null) {
            for (RenderComponent wheel : wheels) {
                double circumference = wheel.height() * 3.1415927410125732;
                double relDist = this.distanceTraveled % circumference;
                Vec3d wheelPos = wheel.center();
                OpenGL.With matrix = OpenGL.matrix();
                Throwable throwable = null;
                try {
                    GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
                    GL11.glRotated((double)((float)(360.0 * relDist / circumference)), (double)0.0, (double)0.0, (double)1.0);
                    GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
                    this.drawComponent(wheel);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (matrix == null) continue;
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    matrix.close();
                }
            }
        }
    }

    private void drawDieselLocomotive(EntityMoveableRollingStock stock) {
        EntityRollingStockDefinition def = stock.getDefinition();
        this.drawStandardStock(stock);
        this.drawComponent(def.getComponent(RenderComponentType.FUEL_TANK, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.ALTERNATOR, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.ENGINE_BLOCK, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.GEARBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FLUID_COUPLING, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FINAL_DRIVE, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.TORQUE_CONVERTER, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.FAN_X, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.DRIVE_SHAFT_X, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CAB, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.WHISTLE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.HORN, stock.gauge));
    }

    private void drawSteamLocomotive(LocomotiveSteam stock) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        this.initComponents(stock);
        this.drawBogies(stock);
        this.drawFrameWheels(stock);
        switch (def.getValveGear()) {
            case WALSCHAERTS: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center(), false);
                this.drawWalschaerts(stock, "RIGHT", -90, wheel.height(), center.center(), wheel.center(), false);
                break;
            }
            case TRI_WALSCHAERTS: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center(), false);
                this.drawWalschaerts(stock, "RIGHT", -240, wheel.height(), center.center(), wheel.center(), false);
                this.drawWalschaerts(stock, "CENTER", -120, wheel.height(), wheels.get(0).center(), wheels.get(0).center(), false);
                break;
            }
            case MALLET_WALSCHAERTS: 
            case GARRAT: {
                OpenGL.With matrix = OpenGL.matrix();
                Object center = null;
                try {
                    RenderComponent frontLocomotive = def.getComponent(RenderComponentType.FRONT_LOCOMOTIVE, stock.gauge);
                    Vec3d frontVec = frontLocomotive.center();
                    Vec3d frontPos = stock.predictFrontBogeyPosition((float)(-frontVec.x - (double)def.getBogeyFront(stock.gauge)));
                    Vec3d frontNext = stock.predictFrontBogeyPosition((float)(-frontVec.x - (double)def.getBogeyFront(stock.gauge) - 0.5));
                    float frontWheelYaw = VecUtil.toYaw(frontPos.subtract(frontNext));
                    float frontYaw = VecUtil.toYaw(frontPos) + stock.getRotationYaw() + 180.0f;
                    float frontPitch = -VecUtil.toPitch(VecUtil.rotateYaw(frontPos, stock.getRotationYaw() + 180.0f)) + 90.0f + stock.getRotationPitch();
                    GL11.glRotated((double)frontYaw, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)frontPitch, (double)0.0, (double)0.0, (double)1.0);
                    if (frontPos.distanceTo(frontNext) > 0.1) {
                        GL11.glTranslated((double)frontVec.x, (double)frontVec.y, (double)frontVec.z);
                        GL11.glRotated((double)(frontWheelYaw + stock.getRotationYaw() - frontYaw + 180.0f), (double)0.0, (double)1.0, (double)0.0);
                        GL11.glTranslated((double)(-frontVec.x), (double)(-frontVec.y), (double)(-frontVec.z));
                    }
                    List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_FRONT_X, stock.gauge);
                    MultiRenderComponent center2 = new MultiRenderComponent(wheels).scale(stock.gauge);
                    this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_FRONT, stock.gauge));
                    this.drawComponent(frontLocomotive);
                    this.drawDrivingWheels(stock, wheels);
                    RenderComponent wheel = wheels.get(wheels.size() / 2);
                    boolean reverse = def.getValveGear() == ValveGearType.GARRAT;
                    this.drawWalschaerts(stock, "LEFT_FRONT", 0, wheel.height(), center2.center(), wheel.center(), reverse);
                    this.drawWalschaerts(stock, "RIGHT_FRONT", -90, wheel.height(), center2.center(), wheel.center(), reverse);
                }
                catch (Throwable frontLocomotive) {
                    center = frontLocomotive;
                    throw frontLocomotive;
                }
                finally {
                    if (matrix != null) {
                        if (center != null) {
                            try {
                                matrix.close();
                            }
                            catch (Throwable frontLocomotive) {
                                ((Throwable)center).addSuppressed(frontLocomotive);
                            }
                        } else {
                            matrix.close();
                        }
                    }
                }
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, stock.gauge);
                center = new MultiRenderComponent(wheels).scale(stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawWalschaerts(stock, "LEFT_REAR", -45, ((MultiRenderComponent)center).height(), ((MultiRenderComponent)center).center(), wheel.center(), false);
                this.drawWalschaerts(stock, "RIGHT_REAR", -135, ((MultiRenderComponent)center).height(), ((MultiRenderComponent)center).center(), wheel.center(), false);
                break;
            }
            case CLIMAX: {
                break;
            }
            case SHAY: {
                break;
            }
            case HIDDEN: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                break;
            }
            case STEPHENSON: {
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_X, stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                this.drawStephenson(stock, "LEFT", 0, wheel.height(), center.center(), wheel.center());
                this.drawStephenson(stock, "RIGHT", -90, wheel.height(), center.center(), wheel.center());
                break;
            }
            case T1: {
                this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_FRONT, stock.gauge));
                List<RenderComponent> wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_FRONT_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                MultiRenderComponent center = new MultiRenderComponent(wheels).scale(stock.gauge);
                RenderComponent wheel = wheels.get(wheels.size() / 2);
                this.drawT1(stock, "LEFT_FRONT", 0, wheel.height(), center.center(), wheel.center());
                this.drawT1(stock, "RIGHT_FRONT", -90, wheel.height(), center.center(), wheel.center());
                wheels = def.getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, stock.gauge);
                this.drawDrivingWheels(stock, wheels);
                center = new MultiRenderComponent(wheels).scale(stock.gauge);
                wheel = wheels.get(wheels.size() / 2);
                this.drawT1(stock, "LEFT_REAR", -45, wheel.height(), center.center(), wheel.center());
                this.drawT1(stock, "RIGHT_REAR", -135, wheel.height(), center.center(), wheel.center());
            }
        }
        this.drawComponent(def.getComponent(RenderComponentType.FRAME, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SHELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BOILER_SEGMENT_X, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.FIREBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.SMOKEBOX, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.STEAM_CHEST_REAR, stock.gauge));
        this.drawComponent(def.getComponent(RenderComponentType.PIPING, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CYLINDER_SIDE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.CAB, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.WHISTLE, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.BELL, stock.gauge));
        this.drawComponents(def.getComponents(RenderComponentType.HORN, stock.gauge));
        if (stock.isBuilt()) {
            this.drawComponent(def.getComponent(RenderComponentType.REMAINING, stock.gauge));
        }
    }

    private void drawDrivingWheels(LocomotiveSteam stock, List<RenderComponent> wheels) {
        RenderComponent center = wheels.get(wheels.size() / 2);
        double circumference = center.height() * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference;
        if (center.type == RenderComponentType.WHEEL_DRIVER_REAR_X) {
            wheelAngle += -45.0;
        }
        for (RenderComponent wheel : wheels) {
            Vec3d wheelPos = wheel.center();
            OpenGL.With matrix = OpenGL.matrix();
            Throwable throwable = null;
            try {
                GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
                GL11.glRotated((double)((float)wheelAngle), (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
                this.drawComponent(wheel);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (matrix == null) continue;
                if (throwable != null) {
                    try {
                        matrix.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                matrix.close();
            }
        }
    }

    private void drawBogies(EntityMoveableRollingStock stock) {
        block51: {
            Throwable throwable;
            OpenGL.With wheelMatrix;
            Vec3d wheelPos;
            double relDist;
            double circumference;
            Throwable throwable2;
            OpenGL.With matrix;
            List<RenderComponent> rearBogeyWheels;
            RenderComponent rearBogey;
            EntityRollingStockDefinition def;
            block50: {
                def = stock.getDefinition();
                RenderComponent frontBogey = def.getComponent(RenderComponentType.BOGEY_FRONT, stock.gauge);
                List<RenderComponent> frontBogeyWheels = def.getComponents(RenderComponentType.BOGEY_FRONT_WHEEL_X, stock.gauge);
                rearBogey = def.getComponent(RenderComponentType.BOGEY_REAR, stock.gauge);
                rearBogeyWheels = def.getComponents(RenderComponentType.BOGEY_REAR_WHEEL_X, stock.gauge);
                if (frontBogey != null) {
                    Vec3d frontVec = frontBogey.center();
                    Vec3d frontPos = stock.predictFrontBogeyPosition((float)(-frontVec.x - (double)def.getBogeyFront(stock.gauge)));
                    Vec3d frontNext = stock.predictFrontBogeyPosition((float)(-frontVec.x - (double)def.getBogeyFront(stock.gauge) - 0.5));
                    float frontWheelYaw = VecUtil.toYaw(frontPos.subtract(frontNext));
                    float frontYaw = VecUtil.toYaw(frontPos) + stock.getRotationYaw() + 180.0f;
                    float frontPitch = -VecUtil.toPitch(VecUtil.rotateYaw(frontPos, stock.getRotationYaw() + 180.0f)) + 90.0f + stock.getRotationPitch();
                    matrix = OpenGL.matrix();
                    throwable2 = null;
                    try {
                        GL11.glRotated((double)frontYaw, (double)0.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)frontPitch, (double)0.0, (double)0.0, (double)1.0);
                        if (frontPos.distanceTo(frontNext) > 0.1) {
                            GL11.glTranslated((double)frontVec.x, (double)frontVec.y, (double)frontVec.z);
                            GL11.glRotated((double)(frontWheelYaw + stock.getRotationYaw() - frontYaw + 180.0f), (double)0.0, (double)1.0, (double)0.0);
                            GL11.glTranslated((double)(-frontVec.x), (double)(-frontVec.y), (double)(-frontVec.z));
                        }
                        this.drawComponent(frontBogey);
                        if (frontBogeyWheels == null) break block50;
                        for (RenderComponent wheel : frontBogeyWheels) {
                            circumference = wheel.height() * 3.1415927410125732;
                            relDist = this.distanceTraveled % circumference;
                            wheelPos = wheel.center();
                            wheelMatrix = OpenGL.matrix();
                            throwable = null;
                            try {
                                GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
                                GL11.glRotatef((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                                GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
                                this.drawComponent(wheel);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (wheelMatrix == null) continue;
                                if (throwable != null) {
                                    try {
                                        wheelMatrix.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                wheelMatrix.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (matrix != null) {
                            if (throwable2 != null) {
                                try {
                                    matrix.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                matrix.close();
                            }
                        }
                    }
                }
            }
            if (rearBogey != null) {
                Vec3d rearVec = rearBogey.center();
                EntityMoveableRollingStock.PosRot rearPos = stock.predictRearBogeyPosition((float)(-rearVec.x - (double)def.getBogeyRear(stock.gauge)));
                EntityMoveableRollingStock.PosRot rearNext = stock.predictRearBogeyPosition((float)(-rearVec.x - (double)def.getBogeyRear(stock.gauge) - 0.5));
                float rearWheelYaw = VecUtil.toYaw(rearPos.subtract(rearNext));
                float rearYaw = VecUtil.toYaw(rearPos) + stock.getRotationYaw();
                float rearPitch = VecUtil.toPitch(VecUtil.rotateYaw(rearPos, stock.getRotationYaw() + 180.0f)) - 90.0f + stock.getRotationPitch();
                matrix = OpenGL.matrix();
                throwable2 = null;
                try {
                    GL11.glRotated((double)rearYaw, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)rearPitch, (double)0.0, (double)0.0, (double)1.0);
                    if (rearPos.distanceTo(rearNext) > 0.1) {
                        GL11.glTranslated((double)rearVec.x, (double)rearVec.y, (double)rearVec.z);
                        GL11.glRotated((double)(rearWheelYaw + stock.getRotationYaw() - rearYaw + 180.0f), (double)0.0, (double)1.0, (double)0.0);
                        GL11.glTranslated((double)(-rearVec.x), (double)(-rearVec.y), (double)(-rearVec.z));
                    }
                    this.drawComponent(rearBogey);
                    if (rearBogeyWheels == null) break block51;
                    for (RenderComponent wheel : rearBogeyWheels) {
                        circumference = wheel.height() * 3.1415927410125732;
                        relDist = this.distanceTraveled % circumference;
                        wheelPos = wheel.center();
                        wheelMatrix = OpenGL.matrix();
                        throwable = null;
                        try {
                            GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
                            GL11.glRotatef((float)((float)(360.0 * relDist / circumference)), (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
                            this.drawComponent(wheel);
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (wheelMatrix == null) continue;
                            if (throwable != null) {
                                try {
                                    wheelMatrix.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            wheelMatrix.close();
                        }
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (matrix != null) {
                        if (throwable2 != null) {
                            try {
                                matrix.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                        } else {
                            matrix.close();
                        }
                    }
                }
            }
        }
    }

    private void drawStephenson(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        RenderComponent connectingRod = this.requireComponent(def, RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = this.requireComponent(def, RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = this.requireComponent(def, RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodRadius = connRodPos.x - wheelCenter.x;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, (float)wheelAngle);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            this.drawComponent(connectingRod);
        }
        Vec3d drivingRodRotPoint = new Vec3d(drivingRod.max().x - drivingRod.height() / 2.0, drivingRod.center().y, drivingRod.max().z);
        float drivingRodAngle = (float)Math.toDegrees(Math.atan2(connRodMovment.z, drivingRod.length() - drivingRod.height()));
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            GL11.glTranslated((double)drivingRodRotPoint.x, (double)drivingRodRotPoint.y, (double)drivingRodRotPoint.z);
            GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-drivingRodRotPoint.x), (double)(-drivingRodRotPoint.y), (double)(-drivingRodRotPoint.z));
            this.drawComponent(drivingRod);
        }
        double pistonDelta = connRodMovment.x - connRodRadius;
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            this.drawComponent(pistonRod);
        }
    }

    private void drawT1(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        RenderComponent connectingRod = this.requireComponent(def, RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = this.requireComponent(def, RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = this.requireComponent(def, RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodRadius = connRodPos.x - wheelCenter.x;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, (float)wheelAngle);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            this.drawComponent(connectingRod);
        }
        Vec3d drivingRodRotPoint = new Vec3d(drivingRod.max().x - drivingRod.height() / 2.0, drivingRod.center().y, drivingRod.max().z);
        float drivingRodAngle = (float)Math.toDegrees(Math.atan2(connRodMovment.z, drivingRod.length() - drivingRod.height()));
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            GL11.glTranslated((double)drivingRodRotPoint.x, (double)drivingRodRotPoint.y, (double)drivingRodRotPoint.z);
            GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-drivingRodRotPoint.x), (double)(-drivingRodRotPoint.y), (double)(-drivingRodRotPoint.z));
            this.drawComponent(drivingRod);
        }
        double pistonDelta = connRodMovment.x - connRodRadius;
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            this.drawComponent(pistonRod);
        }
    }

    private RenderComponent requireComponent(LocomotiveSteamDefinition def, RenderComponentType rct, String side, Gauge gauge) {
        RenderComponent comp = def.getComponent(rct, side, gauge);
        if (comp == null) {
            ImmersiveRailroading.error((String)"Missing component for %s: %s %s", (Object[])new Object[]{def.name(), rct, side});
        }
        return comp;
    }

    private void drawWalschaerts(LocomotiveSteam stock, String side, int wheelAngleOffset, double diameter, Vec3d wheelCenter, Vec3d wheelPos, boolean reverse) {
        LocomotiveSteamDefinition def = stock.getDefinition();
        double circumference = diameter * 3.1415927410125732;
        double relDist = this.distanceTraveled % circumference;
        double wheelAngle = 360.0 * relDist / circumference + (double)wheelAngleOffset;
        if (reverse) {
            wheelAngle -= 90.0;
        }
        RenderComponent connectingRod = this.requireComponent(def, RenderComponentType.SIDE_ROD_SIDE, side, stock.gauge);
        RenderComponent drivingRod = this.requireComponent(def, RenderComponentType.MAIN_ROD_SIDE, side, stock.gauge);
        RenderComponent pistonRod = this.requireComponent(def, RenderComponentType.PISTON_ROD_SIDE, side, stock.gauge);
        RenderComponent crossHead = this.requireComponent(def, RenderComponentType.UNION_LINK_SIDE, side, stock.gauge);
        RenderComponent combinationLever = this.requireComponent(def, RenderComponentType.COMBINATION_LEVER_SIDE, side, stock.gauge);
        RenderComponent returnCrank = this.requireComponent(def, RenderComponentType.ECCENTRIC_CRANK_SIDE, side, stock.gauge);
        RenderComponent returnCrankRod = this.requireComponent(def, RenderComponentType.ECCENTRIC_ROD_SIDE, side, stock.gauge);
        RenderComponent slottedLink = this.requireComponent(def, RenderComponentType.EXPANSION_LINK_SIDE, side, stock.gauge);
        RenderComponent radiusBar = this.requireComponent(def, RenderComponentType.RADIUS_BAR_SIDE, side, stock.gauge);
        Vec3d connRodPos = connectingRod.center();
        double connRodRadius = connRodPos.x - wheelCenter.x;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, (float)wheelAngle);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            this.drawComponent(connectingRod);
        }
        Vec3d drivingRodRotPoint = new Vec3d((reverse ? drivingRod.min() : drivingRod.max()).x - drivingRod.height() / 2.0, drivingRod.center().y, (reverse ? drivingRod.min() : drivingRod.max()).z);
        float drivingRodAngle = (float)Math.toDegrees(Math.atan2(reverse ? -connRodMovment.z : connRodMovment.z, drivingRod.length() - drivingRod.height()));
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            GL11.glTranslated((double)drivingRodRotPoint.x, (double)drivingRodRotPoint.y, (double)drivingRodRotPoint.z);
            GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-drivingRodRotPoint.x), (double)(-drivingRodRotPoint.y), (double)(-drivingRodRotPoint.z));
            this.drawComponent(drivingRod);
        }
        double pistonDelta = connRodMovment.x - connRodRadius;
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            this.drawComponent(pistonRod);
            this.drawComponent(crossHead);
        }
        Vec3d returnCrankRotPoint = reverse ? returnCrank.min().add(returnCrank.height() / 2.0, returnCrank.height() / 2.0, 0.0) : returnCrank.max().add(-returnCrank.height() / 2.0, -returnCrank.height() / 2.0, 0.0);
        Vec3d wheelRotationOffset = reverse ? VecUtil.fromWrongYaw(returnCrankRotPoint.x - wheelPos.x, (float)wheelAngle) : VecUtil.fromWrongYaw(returnCrankRotPoint.x - wheelPos.x, (float)wheelAngle);
        Vec3d returnCrankOriginOffset = wheelPos.add(wheelRotationOffset.x, wheelRotationOffset.z, 0.0);
        double returnCrankAngle = wheelAngle + 90.0 + 30.0;
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)returnCrankOriginOffset.x, (double)returnCrankOriginOffset.y, (double)0.0);
            GL11.glRotated((double)returnCrankAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-returnCrankRotPoint.x), (double)(-returnCrankRotPoint.y), (double)0.0);
            this.drawComponent(returnCrank);
        }
        double returnCrankLength = -(returnCrank.length() - returnCrank.height() / 2.0 - returnCrankRod.height() / 2.0);
        Vec3d returnCrankRotationOffset = VecUtil.fromWrongYaw(returnCrankLength, (float)returnCrankAngle + (float)(reverse ? 90 : -90));
        Vec3d returnCrankRodOriginOffset = returnCrankOriginOffset.add(returnCrankRotationOffset.x, returnCrankRotationOffset.z, 0.0);
        Vec3d returnCrankRodRotPoint = reverse ? returnCrankRod.min().add(returnCrankRod.height() / 2.0, returnCrankRod.height() / 2.0, 0.0) : returnCrankRod.max().add(-returnCrankRod.height() / 2.0, -returnCrankRod.height() / 2.0, 0.0);
        double returnCrankRodLength = returnCrankRod.length() - returnCrankRod.height() / 2.0;
        double slottedLinkLowest = slottedLink.min().y + slottedLink.width() / 2.0;
        double returnCrankRodFudge = reverse ? Math.abs(slottedLink.center().x - (returnCrankRodOriginOffset.x + returnCrankRodLength)) / 3.0 : Math.abs(slottedLink.center().x - (returnCrankRodOriginOffset.x - returnCrankRodLength)) / 3.0;
        float returnCrankRodRot = reverse ? -VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.y + returnCrankRodFudge, 0.0, returnCrankRodLength)) : VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.y + returnCrankRodFudge, 0.0, returnCrankRodLength));
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)returnCrankRodOriginOffset.x, (double)returnCrankRodOriginOffset.y, (double)0.0);
            GL11.glRotated((double)returnCrankRodRot, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-returnCrankRodRotPoint.x), (double)(-returnCrankRodRotPoint.y), (double)0.0);
            this.drawComponent(returnCrankRod);
        }
        Vec3d returnCrankRodRotationOffset = VecUtil.fromWrongYaw(returnCrankRodLength, returnCrankRodRot + (float)(reverse ? -90 : 90));
        Vec3d returnCrankRodFarPoint = returnCrankRodOriginOffset.add(returnCrankRodRotationOffset.x, returnCrankRodRotationOffset.z, 0.0);
        Vec3d slottedLinkRotPoint = slottedLink.center();
        double slottedLinkRot = Math.toDegrees(Math.atan2(-slottedLinkRotPoint.x + returnCrankRodFarPoint.x, slottedLinkRotPoint.y - returnCrankRodFarPoint.y));
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)slottedLinkRotPoint.x, (double)slottedLinkRotPoint.y, (double)0.0);
            GL11.glRotated((double)slottedLinkRot, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-slottedLinkRotPoint.x), (double)(-slottedLinkRotPoint.y), (double)0.0);
            this.drawComponent(slottedLink);
        }
        float throttle = stock.getThrottle();
        double forwardMax = (slottedLink.min().y - slottedLinkRotPoint.y) * 0.4;
        double forwardMin = (slottedLink.max().y - slottedLinkRotPoint.y) * 0.65;
        double throttleSlotPos = 0.0;
        throttleSlotPos = throttle > 0.0f ? forwardMax * (double)throttle : forwardMin * (double)(-throttle);
        double radiusBarSliding = Math.sin(Math.toRadians(-slottedLinkRot)) * throttleSlotPos;
        Vec3d radiusBarClose = reverse ? radiusBar.min() : radiusBar.max();
        float raidiusBarAngle = reverse ? -(VecUtil.toWrongYaw(new Vec3d(radiusBar.length(), 0.0, throttleSlotPos)) + 90.0f) : VecUtil.toWrongYaw(new Vec3d(radiusBar.length(), 0.0, throttleSlotPos += slottedLinkRotPoint.y - radiusBar.max().y)) + 90.0f;
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)0.0, (double)throttleSlotPos, (double)0.0);
            GL11.glTranslated((double)radiusBarSliding, (double)0.0, (double)0.0);
            GL11.glTranslated((double)radiusBarClose.x, (double)radiusBarClose.y, (double)0.0);
            GL11.glRotated((double)raidiusBarAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-radiusBarClose.x), (double)(-radiusBarClose.y), (double)0.0);
            this.drawComponent(radiusBar);
        }
        Vec3d radiusBarFar = reverse ? radiusBar.max() : radiusBar.min();
        Vec3d radiusBarFarPoint = radiusBarFar.add(radiusBarSliding + combinationLever.width() / 2.0, 0.0, 0.0);
        Vec3d combinationLeverRotPos = combinationLever.min().add(combinationLever.width() / 2.0, combinationLever.width() / 2.0, 0.0);
        Vec3d delta = radiusBarFarPoint.subtract(combinationLeverRotPos.add(pistonDelta, 0.0, 0.0));
        float combinationLeverAngle = VecUtil.toWrongYaw(new Vec3d(delta.x, 0.0, delta.y));
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            GL11.glTranslated((double)combinationLeverRotPos.x, (double)combinationLeverRotPos.y, (double)0.0);
            GL11.glRotated((double)combinationLeverAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-combinationLeverRotPos.x), (double)(-combinationLeverRotPos.y), (double)0.0);
            this.drawComponent(combinationLever);
        }
    }
}

