/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.render.entity.StockModel;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.obj.OBJTextureSheet;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class StockItemModel
implements ItemRender.ISpriteItemModel {
    public StandardModel getModel(World world, ItemStack stack) {
        return new StandardModel().addCustom(() -> this.render(stack));
    }

    private void render(ItemStack stack) {
        ItemRollingStock.Data data = new ItemRollingStock.Data(stack);
        double scale = data.gauge.scale();
        if (data.def == null) {
            stack.setCount(0);
            return;
        }
        StockModel model = StockRenderCache.getRender(data.def.defID);
        if (model == null) {
            stack.setCount(0);
            return;
        }
        try (OpenGL.With matrix = OpenGL.matrix();
             OpenGL.With tex = model.bindTexture(data.texture, true);
             OpenGL.With cull = OpenGL.bool((int)2884, (boolean)false);){
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            scale = 0.2 * Math.sqrt(scale);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            model.draw();
        }
    }

    public String getSpriteKey(ItemStack stack) {
        ItemRollingStock.Data data = new ItemRollingStock.Data(stack);
        if (data.def == null) {
            System.out.println(stack.getTagCompound());
            return null;
        }
        return data.def.defID + (data.def.getModel().hash + ((OBJTextureSheet)StockRenderCache.getRender((String)data.def.defID).textures.get(null)).hash);
    }

    public StandardModel getSpriteModel(ItemStack stack) {
        ItemRollingStock.Data data = new ItemRollingStock.Data(stack);
        EntityRollingStockDefinition def = data.def;
        StockModel model = StockRenderCache.getRender(def.defID);
        model.createVBA();
        return new StandardModel().addCustom(() -> {
            try (OpenGL.With matrix = OpenGL.matrix();
                 OpenGL.With tex = model.bindTexture(true);){
                Gauge std = Gauge.from(1.435);
                double modelLength = def.getLength(std);
                double size = Math.max(def.getHeight(std), def.getWidth(std));
                double scale = -1.6 / size;
                GL11.glTranslated((double)0.0, (double)0.85, (double)-0.5);
                GL11.glScaled((double)scale, (double)scale, (double)(scale / (modelLength / 2.0)));
                GL11.glRotated((double)85.0, (double)0.0, (double)1.0, (double)0.0);
                model.draw();
            }
            model.textures.forEach((k, ts) -> ts.dealloc());
        });
    }
}

