/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.multiblock;

import cam72cam.immersiverailroading.multiblock.CastingMultiblock;
import cam72cam.immersiverailroading.render.multiblock.IMultiblockRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.resource.Identifier;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class CastingRender
implements IMultiblockRender {
    private OBJRender renderer;
    private List<String> flowing_steel;
    private List<String> steel_level;
    private List<String> rest;

    @Override
    public void render(TileMultiblock te, float partialTicks) {
        if (this.renderer == null) {
            try {
                this.renderer = new OBJRender(new OBJModel(new Identifier("immersiverailroading:models/multiblocks/casting_machine.obj"), 0.0f));
                this.flowing_steel = new ArrayList<String>();
                this.steel_level = new ArrayList<String>();
                this.rest = new ArrayList<String>();
                for (String name : this.renderer.model.groups.keySet()) {
                    if (name.contains("FLOWING_STEEL")) {
                        this.flowing_steel.add(name);
                        continue;
                    }
                    if (name.contains("STEEL_LEVEL")) {
                        this.steel_level.add(name);
                        continue;
                    }
                    this.rest.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try (OpenGL.With matrix = OpenGL.matrix();
             OpenGL.With tex = this.renderer.bindTexture();){
            double steelLevel;
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glRotated((double)(te.getRotation() - 90.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-2.5, (double)-3.0, (double)6.5);
            CastingMultiblock.CastingInstance tmb = (CastingMultiblock.CastingInstance)te.getMultiblock();
            if (tmb.isPouring()) {
                this.renderer.drawGroups(this.flowing_steel);
            }
            if ((steelLevel = tmb.getSteelLevel() * 4.5) != 0.0) {
                try (OpenGL.With m = OpenGL.matrix();){
                    GL11.glTranslated((double)0.0, (double)steelLevel, (double)0.0);
                    this.renderer.drawGroups(this.steel_level);
                }
            }
            this.renderer.drawGroups(this.rest);
        }
    }
}

