/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.model.TrackModel;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.world.World;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import util.Matrix4;

public class RailBuilderRender {
    private static DisplayListCache displayLists = new DisplayListCache();

    public static void renderRailBuilder(RailInfo info, World world) {
        Throwable throwable;
        TrackModel model = DefinitionManager.getTrack(info.settings.track, info.settings.gauge.value());
        if (model == null) {
            return;
        }
        OBJRender trackRenderer = StockRenderCache.getTrackRenderer(model);
        Integer displayList = (Integer)displayLists.get(info.uniqueID);
        if (displayList == null) {
            displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            throwable = null;
            try (OpenGL.With matrix = OpenGL.matrix();){
                for (BuilderBase.VecYawPitch piece : info.getBuilder(world).getRenderData()) {
                    Matrix4 m = new Matrix4();
                    m.translate(piece.x, piece.y, piece.z);
                    m.rotate(Math.toRadians(piece.getYaw()), 0.0, 1.0, 0.0);
                    m.rotate(Math.toRadians(piece.getPitch()), 1.0, 0.0, 0.0);
                    m.rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0);
                    if (piece.getLength() != -1.0f) {
                        m.scale((double)piece.getLength() / info.settings.gauge.scale(), 1.0, 1.0);
                    }
                    double scale = info.settings.gauge.scale();
                    m.scale(scale, scale, scale);
                    m.transpose();
                    FloatBuffer fbm = BufferUtils.createFloatBuffer((int)16);
                    fbm.put(new float[]{(float)m.m00, (float)m.m01, (float)m.m02, (float)m.m03, (float)m.m10, (float)m.m11, (float)m.m12, (float)m.m13, (float)m.m20, (float)m.m21, (float)m.m22, (float)m.m23, (float)m.m30, (float)m.m31, (float)m.m32, (float)m.m33});
                    fbm.flip();
                    OpenGL.multMatrix((FloatBuffer)fbm);
                    if (piece.getGroups().size() != 0) {
                        ArrayList<String> groups = new ArrayList<String>();
                        for (String baseGroup : piece.getGroups()) {
                            for (String groupName : trackRenderer.model.groups()) {
                                if (!groupName.contains(baseGroup)) continue;
                                groups.add(groupName);
                            }
                        }
                        trackRenderer.drawGroups(groups);
                    } else {
                        trackRenderer.draw();
                    }
                    try {
                        m.invert();
                        fbm = BufferUtils.createFloatBuffer((int)16);
                        fbm.put(new float[]{(float)m.m00, (float)m.m01, (float)m.m02, (float)m.m03, (float)m.m10, (float)m.m11, (float)m.m12, (float)m.m13, (float)m.m20, (float)m.m21, (float)m.m22, (float)m.m23, (float)m.m30, (float)m.m31, (float)m.m32, (float)m.m33});
                        fbm.flip();
                        OpenGL.multMatrix((FloatBuffer)fbm);
                    }
                    catch (Error | Exception e) {
                        GL11.glPopMatrix();
                        GL11.glPushMatrix();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            GL11.glEndList();
            displayLists.put(info.uniqueID, displayList);
        }
        throwable = null;
        try (OpenGL.With tex = trackRenderer.bindTexture();){
            MinecraftClient.startProfiler((String)"dl");
            GL11.glCallList((int)displayList);
            MinecraftClient.endProfiler();
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }
}

