/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.thirdparty.CommonAPI;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.mod.math.Vec3i;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class ComputerCraft {
    public static void init() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new IPeripheralProvider(){

            @Nullable
            public LazyOptional<IPeripheral> getPeripheral(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Direction enumFacing) {
                TileRailBase rail = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(new Vec3i(blockPos), TileRailBase.class);
                if (rail != null) {
                    if (rail.getAugment() == Augment.DETECTOR) {
                        return LazyOptional.of(() -> new DetectorPeripheral(world, blockPos));
                    }
                    if (rail.getAugment() == Augment.LOCO_CONTROL) {
                        return LazyOptional.of(() -> new LocoControlPeripheral(world, blockPos));
                    }
                }
                return LazyOptional.empty();
            }
        });
    }

    private static Object getObjParam(Object[] params, int id, String name) throws LuaException {
        if (params.length > id) {
            return params[id];
        }
        throw new LuaException("Required parameter \"" + name + "\"");
    }

    private static double getDoubleParam(Object[] params, int id, String name) throws LuaException {
        Object obj = ComputerCraft.getObjParam(params, id, name);
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (NumberFormatException ex) {
            throw new LuaException("Required parameter \"" + name + "\" is not a number");
        }
    }

    private static class LocoControlPeripheral
    extends BasePeripheral {
        private static LinkedHashMap<String, APICall> methods = new LinkedHashMap();

        public LocoControlPeripheral(World world, BlockPos blockPos) {
            super(world, blockPos, methods);
        }

        @Nonnull
        public String getType() {
            return "ir_augment_control";
        }

        static {
            methods.putAll(DetectorPeripheral.methods);
            methods.put("setThrottle", (api, params) -> {
                api.setThrottle(ComputerCraft.getDoubleParam(params, 0, "throttle"));
                return null;
            });
            methods.put("setBrake", (api, params) -> {
                api.setAirBrake(ComputerCraft.getDoubleParam(params, 0, "brake"));
                return null;
            });
            methods.put("setHorn", (api, params) -> {
                api.setHorn((int)ComputerCraft.getDoubleParam(params, 0, "horn"));
                return null;
            });
            methods.put("setBell", (api, params) -> {
                api.setBell((int)ComputerCraft.getDoubleParam(params, 0, "bell"));
                return null;
            });
        }
    }

    private static class DetectorPeripheral
    extends BasePeripheral {
        private static LinkedHashMap<String, APICall> methods = new LinkedHashMap();

        public DetectorPeripheral(World world, BlockPos blockPos) {
            super(world, blockPos, methods);
        }

        @Nonnull
        public String getType() {
            return "ir_augment_detector";
        }

        static {
            methods.put("info", (api, params) -> new Object[]{api.info()});
            methods.put("consist", (api, params) -> new Object[]{api.consist(false)});
            methods.put("getTag", (api, params) -> new Object[]{api.getTag()});
            methods.put("setTag", (api, params) -> {
                api.setTag(ComputerCraft.getObjParam(params, 0, "tag").toString());
                return null;
            });
        }
    }

    private static abstract class BasePeripheral
    implements IDynamicPeripheral {
        private final World world;
        private final BlockPos pos;
        private final String[] fnNames;
        private final APICall[] fnImpls;

        public BasePeripheral(World world, BlockPos blockPos, LinkedHashMap<String, APICall> methods) {
            this.world = world;
            this.pos = blockPos;
            this.fnNames = methods.keySet().toArray(new String[0]);
            this.fnImpls = methods.values().toArray(new APICall[0]);
        }

        @Nonnull
        public String[] getMethodNames() {
            return this.fnNames;
        }

        @Nullable
        public MethodResult callMethod(@Nonnull IComputerAccess iComputerAccess, @Nonnull ILuaContext iLuaContext, int i, @Nonnull IArguments objects) {
            try {
                CommonAPI api = CommonAPI.create(this.world, this.pos);
                if (api != null && i < this.fnImpls.length) {
                    return MethodResult.of((Object[])this.fnImpls[i].apply(api, objects.getAll()));
                }
            }
            catch (Exception ex) {
                ImmersiveRailroading.catching((Throwable)ex);
            }
            return null;
        }

        public boolean equals(@Nullable IPeripheral iPeripheral) {
            return iPeripheral == this;
        }
    }

    @FunctionalInterface
    private static interface APICall {
        public Object[] apply(CommonAPI var1, Object[] var2) throws LuaException;
    }
}

