/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.BuilderIterator;
import cam72cam.immersiverailroading.track.BuilderStraight;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderSwitch
extends BuilderBase
implements IIterableTrack {
    private BuilderIterator turnBuilder;
    private BuilderStraight straightBuilder;
    private BuilderStraight realStraightBuilder;
    private final BuilderStraight straightBuilderReal;

    public BuilderSwitch(RailInfo info, World world, Vec3i pos) {
        super(info, world, pos);
        RailInfo turnInfo = info.withType(info.customInfo.placementPosition.equals((Object)info.placementInfo.placementPosition) ? TrackItems.TURN : TrackItems.CUSTOM);
        RailInfo straightInfo = info.clone();
        this.turnBuilder = (BuilderIterator)turnInfo.getBuilder(world, pos);
        this.straightBuilder = new BuilderStraight(straightInfo, world, pos, true);
        this.realStraightBuilder = new BuilderStraight(straightInfo, world, pos, true);
        double maxOverlap = 0.0;
        this.straightBuilder.positions.retainAll(this.turnBuilder.positions);
        for (Pair straight : this.straightBuilder.positions) {
            maxOverlap = Math.max(maxOverlap, new Vec3d((double)((Integer)straight.getKey()).intValue(), 0.0, (double)((Integer)straight.getValue()).intValue()).length());
        }
        straightInfo = straightInfo.withLength((int)Math.ceil(maxOverlap *= 1.2) + 3);
        this.straightBuilder = new BuilderStraight(straightInfo, world, pos, true);
        this.straightBuilderReal = new BuilderStraight(straightInfo.withType(TrackItems.STRAIGHT), world, pos, true);
        this.turnBuilder.overrideFlexible = true;
        for (TrackBase turn : this.turnBuilder.tracks) {
            if (!(turn instanceof TrackRail)) continue;
            turn.overrideParent(this.straightBuilder.getParentPos());
        }
        for (TrackBase straight : this.straightBuilder.tracks) {
            if (!(straight instanceof TrackGag)) continue;
            straight.setFlexible();
        }
    }

    @Override
    public List<BuilderBase> getSubBuilders() {
        List<BuilderBase> subTurns = this.turnBuilder.getSubBuilders();
        List<BuilderBase> subStraights = this.straightBuilderReal.getSubBuilders();
        if (subTurns == null && subStraights == null) {
            return null;
        }
        ArrayList<BuilderBase> res = new ArrayList<BuilderBase>();
        if (subTurns == null) {
            res.add(this.turnBuilder);
        } else {
            res.addAll(subTurns);
        }
        if (subStraights == null) {
            res.add(this.straightBuilderReal);
        } else {
            res.addAll(subStraights);
        }
        return res;
    }

    @Override
    public int costTies() {
        return this.straightBuilder.costTies() + this.turnBuilder.costTies();
    }

    @Override
    public int costRails() {
        return this.straightBuilder.costRails() + this.turnBuilder.costRails();
    }

    @Override
    public int costBed() {
        return this.straightBuilder.costBed() + this.turnBuilder.costBed();
    }

    @Override
    public int costFill() {
        return this.straightBuilder.costFill() + this.turnBuilder.costFill();
    }

    @Override
    public void setDrops(List<ItemStack> drops) {
        this.straightBuilder.setDrops(drops);
    }

    @Override
    public boolean canBuild() {
        return this.straightBuilder.canBuild() && this.turnBuilder.canBuild();
    }

    @Override
    public void build() {
        this.straightBuilder.build();
        this.turnBuilder.build();
    }

    @Override
    public void clearArea() {
        this.straightBuilder.clearArea();
        this.turnBuilder.clearArea();
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        List<TrackBase> data = this.straightBuilder.getTracksForRender();
        data.addAll(this.turnBuilder.getTracksForRender());
        return data;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        List<BuilderBase.VecYawPitch> data = this.straightBuilder.getRenderData();
        data.addAll(this.turnBuilder.getRenderData());
        return data;
    }

    @Override
    public List<PosStep> getPath(double stepSize) {
        return this.realStraightBuilder.getPath(stepSize);
    }
}

