/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapped;
import cam72cam.mod.serialization.TagMapper;

@TagMapped(value=TagMapper.class)
public class Speed {
    private static final double speedRatio = 72.0;
    public static final Speed ZERO = Speed.fromMetric(0.0);
    private double internalSpeed;

    public static Speed fromMinecraft(double speed) {
        return new Speed(speed);
    }

    public static Speed fromMetric(double speed) {
        return new Speed(speed / 72.0);
    }

    private Speed(double speed) {
        this.internalSpeed = speed;
    }

    public double minecraft() {
        return this.internalSpeed;
    }

    public double metric() {
        return this.internalSpeed * 72.0;
    }

    public String metricString() {
        return String.format("%.2f km/h", this.metric());
    }

    public boolean isZero() {
        return this.internalSpeed == 0.0;
    }

    public static class TagMapper
    implements cam72cam.mod.serialization.TagMapper<Speed> {
        public TagMapper.TagAccessor<Speed> apply(Class<Speed> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> d.setDouble(fieldName, Double.valueOf(((Speed)o).internalSpeed)), d -> new Speed(d.getDouble(fieldName)));
        }
    }
}

