/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.shaded.mariuszgromada.math.mxparser;

import com.ldtteam.shaded.mariuszgromada.math.mxparser.Argument;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Expression;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.PrimitiveElement;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.PrimesCache;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.parsertokens.Token;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class mXparser {
    static final String VERSION = "4.0.0";
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    private static String CONSOLE_OUTPUT = "";
    private static String CONSOLE_PREFIX;
    private static String CONSOLE_OUTPUT_PREFIX;
    private static int CONSOLE_ROW_NUMBER;
    public static PrimesCache primesCache;
    public static final int PRIMES_CACHE_NOT_INITIALIZED = -1;
    private static int THREADS_NUMBER;
    static final Expression mXparserExp;
    static boolean ulpRounding;
    public static final String LICENSE = "                      mXparser - version 4.0.0\n         A flexible mathematical eXpressions parser for JAVA.\n\nYou may use this software under the condition of Simplified BSD License:\n\nCopyright 2010-2017 MARIUSZ GROMADA. All rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are\npermitted provided that the following conditions are met:\n\n   1. Redistributions of source code must retain the above copyright notice, this list of\n      conditions and the following disclaimer.\n\n   2. Redistributions in binary form must reproduce the above copyright notice, this list\n      of conditions and the following disclaimer in the documentation and/or other materials\n      provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA ``AS IS'' AND ANY EXPRESS OR IMPLIED\nWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND\nFITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MARIUSZ GROMADA OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON\nANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\nADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThe views and conclusions contained in the software and documentation are those of the\nauthors and should not be interpreted as representing official policies, either expressed\nor implied, of MARIUSZ GROMADA.\n\nIf you have any questions/bugs feel free to contact:\n\n    Mariusz Gromada\n    mariuszgromada.org@gmail.com\n    http://mathspace.plt/\n    http://mathparser.org/\n    http://github.com/mariuszgromada/MathParser.org-mXparser\n    http://mariuszgromada.github.io/MathParser.org-mXparser/\n    http://mxparser.sourceforge.net/\n    http://bitbucket.org/mariuszgromada/mxparser/\n    http://mxparser.codeplex.com/\n    http://janetsudoku.mariuszgromada.org/\n";

    public static final void initPrimesCache() {
        primesCache = new PrimesCache();
    }

    public static final void initPrimesCache(int mximumNumberInCache) {
        primesCache = new PrimesCache(mximumNumberInCache);
    }

    public static final void initPrimesCache(PrimesCache primesCache) {
        mXparser.primesCache = primesCache;
    }

    public static void setNoPrimesCache() {
        primesCache = null;
    }

    public static final int getMaxNumInPrimesCache() {
        if (primesCache != null) {
            return primesCache.getMaxNumInCache();
        }
        return -1;
    }

    public static final int getThreadsNumber() {
        return THREADS_NUMBER;
    }

    public static final void setDefaultThreadsNumber() {
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
    }

    public static final void setThreadsNumber(int threadsNumber) {
        if (threadsNumber > 0) {
            THREADS_NUMBER = threadsNumber;
        }
    }

    public static final double getFunctionValue(Expression f, Argument x, double x0) {
        x.setArgumentValue(x0);
        return f.calculate();
    }

    public static final double[] arrayList2double(ArrayList<Double> numbers) {
        if (numbers == null) {
            return null;
        }
        int size = numbers.size();
        double[] newNumbers = new double[size];
        for (int i = 0; i < size; ++i) {
            newNumbers[i] = numbers.get(i);
        }
        return newNumbers;
    }

    public static final double[] getFunctionValues(Expression f, Argument index, double from, double to, double delta) {
        double[] values;
        if (Double.isNaN(delta) || Double.isNaN(from) || Double.isNaN(to) || delta == 0.0) {
            return null;
        }
        int n = 0;
        if (to >= from && delta > 0.0) {
            for (double i = from; i < to; i += delta) {
                ++n;
            }
            values = new double[++n];
            int j = 0;
            for (double i = from; i < to; i += delta) {
                values[j] = mXparser.getFunctionValue(f, index, i);
                ++j;
            }
            values[j] = mXparser.getFunctionValue(f, index, to);
        } else if (to <= from && delta < 0.0) {
            for (double i = from; i > to; i += delta) {
                ++n;
            }
            values = new double[++n];
            int j = 0;
            for (double i = from; i > to; i += delta) {
                values[j] = mXparser.getFunctionValue(f, index, i);
                ++j;
            }
            values[j] = mXparser.getFunctionValue(f, index, to);
        } else if (from == to) {
            n = 1;
            values = new double[n];
            values[0] = mXparser.getFunctionValue(f, index, from);
        } else {
            values = null;
        }
        return values;
    }

    public static final void setRandomGenerator(Random randomGenerator) {
        if (randomGenerator != null) {
            ProbabilityDistributions.randomGenerator = randomGenerator;
        }
    }

    public static final void setExactComparison() {
        BinaryRelations.setExactComparison();
    }

    public static final void setEpsilonComparison() {
        BinaryRelations.setEpsilonComparison();
    }

    public static final void setEpsilon(double epsilon) {
        BinaryRelations.setEpsilon(epsilon);
    }

    public static final void setDefaultEpsilon() {
        BinaryRelations.setDefaultEpsilon();
    }

    public static final double getEpsilon() {
        return BinaryRelations.getEpsilon();
    }

    public static final boolean checkIfEpsilonMode() {
        return BinaryRelations.checkIfEpsilonMode();
    }

    public static final boolean checkIfExactMode() {
        return BinaryRelations.checkIfExactMode();
    }

    public static final void enableUlpRounding() {
        ulpRounding = true;
    }

    public static final void disableUlpRounding() {
        ulpRounding = false;
    }

    public static final boolean checkIfUlpRounding() {
        return ulpRounding;
    }

    public static final String numberToHexString(int number) {
        return Integer.toHexString(number);
    }

    public static final String numberToHexString(long number) {
        return Long.toHexString(number);
    }

    public static final String numberToHexString(double number) {
        return mXparser.numberToHexString((long)number);
    }

    public static final String hexString2AsciiString(String hexString) {
        String asciiString = "";
        for (int i = 0; i < hexString.length(); i += 2) {
            String hexByteStr = hexString.substring(i, i + 2);
            int hexByteInt = Integer.parseInt(hexByteStr, 16);
            asciiString = asciiString + (char)hexByteInt;
        }
        return asciiString;
    }

    public static final String numberToAsciiString(int number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static final String numberToAsciiString(long number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static final String numberToAsciiString(double number) {
        return mXparser.hexString2AsciiString(mXparser.numberToHexString(number));
    }

    public static final void consolePrintln(Object o) {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_PREFIX;
        }
        System.out.println(o);
        ++CONSOLE_ROW_NUMBER;
        System.out.print(CONSOLE_PREFIX);
        CONSOLE_OUTPUT = CONSOLE_OUTPUT + o + "\n" + CONSOLE_OUTPUT_PREFIX;
    }

    public static final void consolePrintln() {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_PREFIX;
        }
        System.out.println();
        ++CONSOLE_ROW_NUMBER;
        System.out.print(CONSOLE_PREFIX);
        CONSOLE_OUTPUT = CONSOLE_OUTPUT + "\n" + CONSOLE_OUTPUT_PREFIX;
    }

    public static final void consolePrint(Object o) {
        if (CONSOLE_ROW_NUMBER == 1 && CONSOLE_OUTPUT.equals("")) {
            System.out.print(CONSOLE_PREFIX);
            CONSOLE_OUTPUT = CONSOLE_PREFIX;
        }
        System.out.print(o);
        CONSOLE_OUTPUT = CONSOLE_OUTPUT + o;
    }

    public static final void resetConsoleOutput() {
        CONSOLE_OUTPUT = "";
        CONSOLE_ROW_NUMBER = 1;
    }

    public void setDefaultConsolePrefix() {
        CONSOLE_PREFIX = "[mXparser-v.4.0.0] ";
    }

    public void setDefaultConsoleOutputPrefix() {
        CONSOLE_OUTPUT_PREFIX = "[mXparser-v.4.0.0] ";
    }

    public void setConsolePrefix(String consolePrefix) {
        CONSOLE_PREFIX = consolePrefix;
    }

    public void setConsoleOutputPrefix(String consoleOutputPrefix) {
        CONSOLE_OUTPUT_PREFIX = consoleOutputPrefix;
    }

    public static final String getConsoleOutput() {
        return CONSOLE_OUTPUT;
    }

    public static final String getHelp() {
        return mXparserExp.getHelp();
    }

    public static final String getHelp(String word) {
        return mXparserExp.getHelp(word);
    }

    public static final void consolePrintHelp() {
        System.out.println(mXparser.getHelp());
    }

    public static final void consolePrintHelp(String word) {
        System.out.println(mXparser.getHelp(word));
    }

    static final boolean regexMatch(String str, String pattern) {
        return Pattern.matches(pattern, str);
    }

    public static final void consolePrintTokens(ArrayList<Token> tokens) {
        Expression.showTokens(tokens);
    }

    public String getLicense() {
        return LICENSE;
    }

    public static void wait(int n) {
        long t1;
        long t0 = System.currentTimeMillis();
        while ((t1 = System.currentTimeMillis()) - t0 < (long)n) {
        }
    }

    static {
        CONSOLE_OUTPUT_PREFIX = CONSOLE_PREFIX = "[mXparser-v.4.0.0] ";
        CONSOLE_ROW_NUMBER = 1;
        THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
        mXparserExp = new Expression(new PrimitiveElement[0]);
        ulpRounding = true;
    }
}

