/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.shaded.mariuszgromada.math.mxparser.regressiontesting;

import com.ldtteam.shaded.mariuszgromada.math.mxparser.Argument;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Constant;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Expression;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Function;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.PrimitiveElement;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.RecursiveArgument;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mXparser;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.regressiontesting.FunExt;

public class RegTestExpression {
    private static Expression[] exp;

    /*
     * Opcode count of 26382 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static boolean runTest1(int testId) {
        mXparser.consolePrint("[" + testId + "] ");
        boolean testResult = false;
        double value = 0.0;
        double reg = 0.0;
        double sum = 0.0;
        String expStr = "";
        switch (testId) {
            case 0: {
                expStr = "";
                mXparser.consolePrint("Empty expression string ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                if (Double.isNaN(value)) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " --> ");
                break;
            }
            case 1: {
                expStr = "2+1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 2: {
                expStr = "1-2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 3: {
                expStr = "2*5";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 4: {
                expStr = "20/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 5.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 5: {
                expStr = "-2+22";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 20.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 6: {
                expStr = "3-(-5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 8.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 7: {
                expStr = "+5-(+7)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -2.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 8: {
                expStr = "-5+(-7)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -12.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 9: {
                expStr = "-2*(3-5)+7";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 11.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 10: {
                expStr = "5.5*(2-3 + (5.3-7.89)/2)/2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -6.31125;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 11: {
                expStr = "2-(32-4)/(23+(4)/(5))-(2-4)*(4+6-98.2)+4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -171.5764705882353;
                if (MathFunctions.abs(value - reg) < 1.0E-12) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 12: {
                expStr = "2^3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Math.pow(2.0, 3.0);
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 13: {
                expStr = "2^(-3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Math.pow(2.0, -3.0);
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 14: {
                expStr = "2^0.7";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Math.pow(2.0, 0.7);
                if (MathFunctions.abs(value - reg) < 1.0E-14) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 15: {
                expStr = "4^3^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Math.pow(4.0, Math.pow(3.0, 2.0));
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 16: {
                expStr = "(4^3)^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Math.pow(Math.pow(4.0, 3.0), 2.0);
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 17: {
                expStr = "0.9^0.8^0.7^0.6^0.5";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.914888338607593;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 18: {
                expStr = "2=2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 19: {
                expStr = "2=3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 20: {
                expStr = "2<>3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 21: {
                expStr = "2<>2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 22: {
                expStr = "3>2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 23: {
                expStr = "2>2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 24: {
                expStr = "3>2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 25: {
                expStr = "2<3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 26: {
                expStr = "2<2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 27: {
                expStr = "3<2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 28: {
                expStr = "2>=2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 29: {
                expStr = "3>=2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 30: {
                expStr = "1>=2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 31: {
                expStr = "1<=2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 32: {
                expStr = "1<=1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 33: {
                expStr = "1<=0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 34: {
                expStr = "1 & 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 35: {
                expStr = "1 & -1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 36: {
                expStr = "1 & 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 37: {
                expStr = "0 & 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 38: {
                expStr = "0 & 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 39: {
                expStr = "1 | -1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 40: {
                expStr = "0 | -1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 41: {
                expStr = "1 | 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 42: {
                expStr = "0 | 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 43: {
                expStr = "3>2 | 2>3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 44: {
                expStr = "3>5 | 2>3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 45: {
                expStr = "not((3>4) & (2>=2))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 46: {
                expStr = "not(-5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 47: {
                expStr = "not(0)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 48: {
                expStr = "if(0,1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 49: {
                expStr = "if(5,1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 50: {
                expStr = "sum(n,1,10,n)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 55.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 51: {
                expStr = "prod(n,1,5,n)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 120.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 52: {
                Argument x = new Argument("x", 5.0);
                expStr = "sin(x)-sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 53: {
                Argument d = new Argument("d", 0.01);
                expStr = "pi-2*sum(x,-1,1,d*sqrt(1-x^2),d)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, d);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 54: {
                Argument x = new Argument("x", 1.0);
                expStr = "1 - ( sin(x)^2+cos(x)^2 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 55: {
                Argument x = new Argument("x", 1.0);
                expStr = "1 - ( sec(x)^2 - tan(x)^2 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 56: {
                Argument x = new Argument("x", 1.0);
                expStr = "1 - ( cosec(x)^2 - ctan(x)^2 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 57: {
                Argument x = new Argument("x", 1.0);
                expStr = "1 - ( cosec(x)^2 - ctan(x)^2 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 58: {
                Argument x = new Argument("x", 1.0);
                expStr = "1 - ( csc(x)^2 - ctg(x)^2 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 59: {
                Argument x = new Argument("x", 1.0);
                expStr = "1 - ( sec(x)^2 - tg(x)^2 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 60: {
                Argument x = new Argument("x", 1.0);
                expStr = "tan(x) - sin(x)/cos(x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 61: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "sin(x+y) - (sin(x)*cos(y)+cos(x)*sin(y))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 62: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "sin(x-y) - (sin(x)*cos(y)-cos(x)*sin(y))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 63: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "cos(x+y) - (cos(x)*cos(y)-sin(x)*sin(y))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 64: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "cos(x-y) - (cos(x)*cos(y)+sin(x)*sin(y))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 65: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "tg(x+y) - (tg(x)+tg(y)) / (1 - tg(x)*tg(y))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 66: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "tg(x-y) - (tg(x)-tg(y)) / (1 + tg(x)*tg(y))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 67: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "ctg(x+y) - (ctg(x)*ctg(y)-1) / (ctg(y)+ctg(x))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 68: {
                Argument x = new Argument("x", 2.0);
                Argument n = new Argument("n", 10.0);
                expStr = "sin(n*x) - sum(i,0,n,(-1)^i*C(n,2*i+1)*(cos(x)^(n-2*i-1))*(sin(x)^(2*i+1))) ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 69: {
                Argument n = new Argument("n", 50.0);
                expStr = "n*2^(n-1) - sum(i,1,n,i*C(n,i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 70: {
                expStr = "prod(i,2,6,1+1/i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.5;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 71: {
                expStr = "prod(i,1,6,10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Math.pow(10.0, 6.0);
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 72: {
                expStr = "prod(i,1,6,i,0.5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                for (double ii = 1.0; ii < 6.0; ii += 0.5) {
                    reg *= ii;
                }
                if (value == (reg *= 6.0)) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 73: {
                expStr = "sum(n,1,5,prod(i,1,n,n*i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                sum = 0.0;
                for (double nn = 1.0; nn <= 5.0; nn += 1.0) {
                    reg = 1.0;
                    for (double ii = 1.0; ii <= nn; ii += 1.0) {
                        reg *= nn * ii;
                    }
                    sum += reg;
                }
                reg = sum;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 74: {
                Argument n = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument fib = new RecursiveArgument("fib", "fib(n-1)+fib(n-2)", n, new PrimitiveElement[0]);
                fib.addBaseCase(0, 0.0);
                fib.addBaseCase(1, 1.0);
                expStr = "sum(n,0,5,fib(n))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, fib);
                value = exp[testId].calculate();
                reg = 12.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 75: {
                Argument n = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument fact = new RecursiveArgument("fact", "n*fact(n-1)", n, new PrimitiveElement[0]);
                fact.addBaseCase(0, 1.0);
                expStr = "5!-fact(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, fact);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 76: {
                Argument x = new Argument("x", 2.0);
                expStr = "cos(x)-der(sin(x),x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 77: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "-sin(x+y)-der(der(sin(x+y),x),y)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 0.001) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 78: {
                Argument x = new Argument("x", 2.0);
                Argument y = new Argument("y", 3.0);
                expStr = "cos(x*y)-x*y*sin(x*y)-der(der(sin(x*y),x),y)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 0.001) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 79: {
                Argument n = new Argument("n", -5.0);
                expStr = "C(n,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 15.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 80: {
                Argument x = new Argument("x", 0.0);
                expStr = "der+(abs(x),x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 81: {
                Argument x = new Argument("x", 0.0);
                expStr = "der-(abs(x),x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = -1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 82: {
                Argument x = new Argument("x", 4.0);
                expStr = "cos(x)-der(sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!),x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 83: {
                Argument n = new Argument("n", 7.0);
                Argument k = new Argument("k", 4.0);
                expStr = "C(n,k) - ( C(n-1,k-1)+C(n-1,k) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 84: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k) - prod(i,1,k,n-i+1) / prod(i,1,k,i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 85: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k) - prod(i,1,k,(n-i+1)/i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 86: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k) - C(n,n-k)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 87: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,0)+C(n,n)+C(0,0)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 3.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 88: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k+1)-C(n,k)*(n-k)/(k+1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 89: {
                Argument n = new Argument("n", 13.0);
                expStr = "2^n-sum(k,0,n,C(n,k))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 90: {
                Argument n = new Argument("n", 13.0);
                expStr = "C(2*n,n)-sum(k,0,n,C(n,k)^2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 91: {
                Argument n = new Argument("n", 13.0);
                expStr = "sum(k,0,n,(-1)^k*C(n,k))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 92: {
                Argument n = new Argument("n", 13.0);
                Argument m = new Argument("m", 3.0);
                Argument s = new Argument("s", 5.0);
                Argument r = new Argument("r", 4.0);
                expStr = "C(r+s,m+n)-sum(k,0,n,C(r,m+k)*C(s,n-k))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, m, r, s);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 93: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k)-(n/k)*C(n-1,k-1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 94: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "(n-k)*C(n,k)-n*C(n-1,k)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 95: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k) <= n^k/k!";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 96: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k) <= (n*e/k)^k";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 97: {
                Argument n = new Argument("n", 13.0);
                Argument k = new Argument("k", 6.0);
                expStr = "C(n,k) >= (n/k)^k";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 98: {
                Argument x = new Argument("x", 3.0);
                expStr = "sin(3)-sin(2)-int(cos(x),x,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 99: {
                Argument i = new Argument("i", 5.0);
                expStr = "2*i+sum(i,1,10,i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, i);
                value = exp[testId].calculate();
                reg = 65.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 100: {
                Argument x = new Argument("x", 3.0);
                expStr = "sin(x)-sin(x-1)-int(cos(x),x,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 101: {
                Function f = new Function("mg", "sin(x)+cos(y)", "x", "y");
                Argument x = new Argument("x", 3.0);
                Argument y = new Argument("y", 2.0);
                expStr = "sin(x)+cos(y)-mg(x,y)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-12) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 102: {
                Function f = new Function("mg", "sin(x)+cos(y)", "x", "y");
                expStr = "der(sin(x)+cos(y),x)-der(mg(x,y),x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0), new Argument("y", 2.0));
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 103: {
                Function f = new Function("f", "x^2", "x");
                Function g = new Function("g", "f(x)^2", "x");
                g.addDefinitions(f);
                expStr = "g(x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(g);
                value = exp[testId].calculate();
                reg = 81.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 104: {
                Function f = new Function("f", "sin(x)", "x");
                Function g = new Function("g", "cos(x)", "x");
                expStr = "der( f(x)*g(x), x) - ( der(f(x), x)*g(x) + f(x)*der(g(x), x) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f, g);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 105: {
                Function f = new Function("f", "sin(x)", "x");
                Function g = new Function("g", "cos(x)", "x");
                expStr = "der( f(x)/g(x), x) - ( der(f(x), x)*g(x) - f(x)*der(g(x), x) )/g(x)^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f, g);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 106: {
                Function f = new Function("f", "sin(x)", "x");
                expStr = "der( int(f(t), t, 0, x), x) - f(x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 107: {
                Function f = new Function("f", "sin(x)", "x");
                Function g = new Function("g", "cos(x)", "x");
                expStr = "der(f(x)+g(x), x) - ( der(f(x), x) + der(g(x),x) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f, g);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 108: {
                Argument a = new Argument("a", 2.0);
                Argument b = new Argument("b", 2.0);
                Function f = new Function("f", "sin(x)", "x");
                Function g = new Function("g", "cos(x)", "x");
                expStr = "der(a*f(x)+b*g(x), x) - ( a*der(f(x), x) + b*der(g(x),x) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0), a, b);
                exp[testId].addDefinitions(f, g);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 109: {
                Function f = new Function("f", "sin(x)", "x");
                Function g = new Function("g", "cos(x)", "x");
                Function h = new Function("h", "x^2", "x");
                expStr = "der(f(x)*g(x)*h(x), x) - ( der(f(x), x)*g(x)*h(x) + f(x)*der(g(x), x)*h(x) + f(x)*g(x)*der(h(x), x))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f, g, h);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 110: {
                Function f = new Function("f", "sin(x)", "x");
                expStr = "der(ln(f(x)), x) - der(f(x), x) / f(x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 111: {
                Function f = new Function("f", "sin(x)", "x");
                Argument a = new Argument("a", Math.PI);
                expStr = "der( f(x)^a, x) - a*f(x)^(a-1)*der(f(x), x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0), a);
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 112: {
                Function f = new Function("f", "sin(x)^2", "x");
                Function g = new Function("g", "cos(x)^2", "x");
                expStr = "der( f(x)^g(x), x) - f(x)^g(x)*( der(f(x), x)*g(x)/f(x) + der(g(x), x)*ln(f(x)) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new Argument("x", 3.0));
                exp[testId].addDefinitions(f, g);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 113: {
                Function f = new Function("f", "sin(x)", "x");
                Function g = new Function("g", "cos(x)", "x");
                Function h = new Function("h", "int(f(t),t,0,x)", "x");
                h.addDefinitions(f);
                Argument a = new Argument("a", 2.0);
                Argument b = new Argument("b", 4.0);
                Argument x = new Argument("x", 3.0);
                expStr = "int(f(x)*g(x),x,a,b) - ( h(b)*g(b)-h(a)*g(a) - int( h(x)*der(g(x),x), x, a, b) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, a, b);
                exp[testId].addDefinitions(f, g, h);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 114: {
                Function f = new Function("f", "ln(x)", "x");
                Function g = new Function("g", "x^2+2", "x");
                Argument x = new Argument("x", 10.0);
                Argument t = new Argument("t", "g(x)", x);
                t.addDefinitions(g);
                expStr = "der( f(g(x)), x) - der( f(t), t)*der( g(x), x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, t);
                exp[testId].addDefinitions(f, g);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 115: {
                Argument n = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument fact1 = new RecursiveArgument("fact1", "n*fact1(n-1)", n, new PrimitiveElement[0]);
                fact1.addBaseCase(0, 1.0);
                RecursiveArgument fact2 = new RecursiveArgument("fact2", "if(n>0, n*fact2(n-1), 1)", n, new PrimitiveElement[0]);
                expStr = "sum(i,0,10,fact1(i)-fact2(i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, fact1, fact2);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 116: {
                Argument n = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument fib1 = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", n, new PrimitiveElement[0]);
                fib1.addBaseCase(0, 0.0);
                fib1.addBaseCase(1, 1.0);
                RecursiveArgument fib2 = new RecursiveArgument("fib2", "if( n>1, fib2(n-1)+fib2(n-2), if(n=1,1,0) )", n, new PrimitiveElement[0]);
                expStr = "sum(i,0,10,fib1(i)-fib2(i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, fib1, fib2);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 117: {
                Function Cnk = new Function("Cnk", "if( k>0, if( k<n, Cnk(n-1,k-1)+Cnk(n-1,k), 1), 1)", "n", "k");
                expStr = "C(10,5)-Cnk(10,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(Cnk);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 118: {
                Argument n = new Argument("n", new PrimitiveElement[0]);
                RecursiveArgument fib1 = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", n, new PrimitiveElement[0]);
                fib1.addBaseCase(0, 0.0);
                fib1.addBaseCase(1, 1.0);
                RecursiveArgument fib2 = new RecursiveArgument("fib2", "if( n>1, fib2(n-1)+fib2(n-2), if(n>0,1,0) )", n, new PrimitiveElement[0]);
                Function fib3 = new Function("fib3", "if(n>1, fib3(n-1)+fib3(n-2), if(n>0,1,0))", "n");
                expStr = "sum(i,1,10,(fib1(i) = fib2(i)) & (fib2(i) = fib3(i)) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, fib1, fib2);
                exp[testId].addDefinitions(fib3);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 119: {
                Argument m = new Argument("m", new PrimitiveElement[0]);
                Argument n = new Argument("n", "m-1", m);
                Argument x = new Argument("x", 3.0);
                Function H = new Function("H", "if(m>1, 2*x*H(n,x)-2*n*H(n-1,x), if(m>0, 2*x, 1) )", m, x, n);
                H.setParametersNumber(2);
                expStr = "H(0,x) + H(1,x) + H(2,x) + H(3,x) - ( (1) + (2*x) + (4*x^2-2) + (8*x^3-12*x) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                exp[testId].addDefinitions(H);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 120: {
                Argument m = new Argument("m", 4.0);
                Argument n = new Argument("n", "m-1", m);
                Argument x = new Argument("x", 3.0);
                Function H = new Function("H", "if(m>1, 2*x*H(n,x)-2*n*H(n-1,x), if(m>0, 2*x, 1) )", m, x, n);
                H.setParametersNumber(2);
                Argument k = new Argument("k", 5.0);
                expStr = "der( H(k,x), x) - 2*k*H(k-1,x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, k);
                exp[testId].addDefinitions(H);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 121: {
                Function T = new Function("T", "if(k>1, 2*x*T(k-1,x)-T(k-2,x), if(k>0, x, 1) )", "k", "x");
                Argument k = new Argument("k", 5.0);
                Argument x = new Argument("x", 3.0);
                expStr = "T(k,x) - ( (x + sqrt(x^2-1))^k + (x - sqrt(x^2-1))^k)/2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, k);
                exp[testId].addDefinitions(T);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 122: {
                Function T1 = new Function("T1", "if(k>1, 2*x*T1(k-1,x)-T1(k-2,x), if(k>0, x, 1) )", "k", "x");
                Function T2 = new Function("T2", "if(x >= 1, cosh(k*arcosh(x)), if(x <= -1, ((-1)^k)*cosh(k*arcosh(-x)), cos(k*acos(x))) )", "k", "x");
                Argument k = new Argument("k", 5.0);
                expStr = "T1(k,3)-T2(k,3) + T1(k,-3)-T2(k,-3) + T1(k,-0.5)-T2(k,-0.5) + T1(k,0.5)-T2(k,0.5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, k);
                exp[testId].addDefinitions(T1, T2);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) <= 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 123: {
                expStr = "pi+e+[gam]+[phi]+[PN]+[B*]+[F'd]+[F'a]+[C2]+[M1]+[B2]+[B4]+[BN'L]+[Kat]+[K*]+[K.]+[B'L]+[RS'm]+[EB'e]+[Bern]+[GKW'l]+[HSM's]+[lm]+[Cah]+[Ll]+[AG]+[L*]+[L.]+[Dz3]+[A3n]+[Bh]+[Pt]+[L2]+[Nv]+[Ks]+[Kh]+[FR]+[La]+[P2]+[Om]+[MRB]+[li2]+[EG]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 57.81734127102257;
                if (MathFunctions.abs(value - reg) <= 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 124: {
                Argument m = new Argument("m", 4.0);
                Argument n = new Argument("n", "m-1", m);
                Argument x = new Argument("x", 3.0);
                Function H = new Function("H", "if(m>1, 2*x*H(n,x)-2*n*H(n-1,x), if(m>0, 2*x, 1) )", m, x, n);
                H.setParametersNumber(2);
                Argument k = new Argument("k", 5.0);
                expStr = "der( H(k,x), x) - 2*k*H(k-1,x)";
                RegTestExpression.exp[testId] = new Expression(expStr, x, k);
                exp[testId].addDefinitions(H);
                boolean syn1 = exp[testId].checkSyntax();
                m.setArgumentName("m");
                if (syn1 && !exp[testId].getSyntaxStatus()) {
                    testResult = true;
                }
                mXparser.consolePrint(exp[testId].getErrorMessage() + " reg ... " + "Syntax status unknown." + " --> ");
                break;
            }
            case 125: {
                expStr = "2==2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 126: {
                expStr = "2 != 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 127: {
                expStr = "2 ~= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 128: {
                expStr = "1 && 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 129: {
                expStr = "1 || -1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
            }
            case 130: {
                expStr = "~1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 131: {
                expStr = "2+~(1-1)!";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 132: {
                Argument x = new Argument("x", 2.0);
                expStr = "if( int(2*x,x,0,pi) > 0 , 1, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 133: {
                Argument x = new Argument("x", 2.0);
                expStr = "if( -int(2*x,x,0,pi) > 0 , 1, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 134: {
                mXparser.setEpsilon(1.0E-8);
                expStr = "sum(n, 0, 10, if ( if( sin(n*pi/2) > 0, 1, 2) >= 2, 4, 2) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 38.0;
                if (value == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 135: {
                expStr = "sin(0)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 136: {
                expStr = "cos(0) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 137: {
                expStr = "tan(0) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 138: {
                expStr = "tg(0) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 139: {
                expStr = "ctan(pi/2) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 140: {
                expStr = "ctg(pi/2) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 141: {
                expStr = "cot(pi/2) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 142: {
                expStr = "sec(0) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 143: {
                expStr = "cosec(pi/2) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 144: {
                expStr = "csc(pi/2) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 145: {
                expStr = "asin(0.5) - pi/6";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 146: {
                expStr = "arsin(0) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 147: {
                expStr = "arcsin(1) - pi/2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 148: {
                expStr = "acos(0) - pi/2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 149: {
                expStr = "arcos(0.5) - pi/3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 150: {
                expStr = "arccos(-1) - pi";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 151: {
                expStr = "atan(0) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 152: {
                expStr = "arctan(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 153: {
                expStr = "atg(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 154: {
                expStr = "arctg(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 155: {
                expStr = "actan(0) - pi/2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 156: {
                expStr = "arcctan(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 157: {
                expStr = "actg(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 158: {
                expStr = "arcctg(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 159: {
                expStr = "acot(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 160: {
                expStr = "arccot(1) - pi/4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 161: {
                expStr = "ln(e) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 162: {
                expStr = "ln(e^2) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 163: {
                expStr = "log2(8) - 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 164: {
                expStr = "log10(1000) - 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 165: {
                expStr = "rad(180) - pi";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 166: {
                expStr = "exp(2) - e^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 167: {
                expStr = "sqrt(25) - 5";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 168: {
                expStr = "sinh(ln([phi])) - 0.5";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 169: {
                expStr = "cosh(ln([phi])) - 0.5*sqrt(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 170: {
                expStr = "tanh(ln([phi])) - 1/sqrt(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 171: {
                expStr = "tgh(ln([phi])) - 1/sqrt(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 172: {
                expStr = "ctanh(ln([phi])) - sqrt(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 173: {
                expStr = "coth(ln([phi])) - sqrt(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 174: {
                expStr = "ctgh(ln([phi])) - sqrt(5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 175: {
                expStr = "sech(ln([phi])) - 1/(0.5*sqrt(5))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 176: {
                expStr = "csch(ln([phi])) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 177: {
                expStr = "cosech(ln([phi])) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 178: {
                expStr = "deg(pi) - 180";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 179: {
                expStr = "abs(-1) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 180: {
                expStr = "sgn(1) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 181: {
                expStr = "sgn(0) - 0";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 182: {
                expStr = "floor(1.2) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 183: {
                expStr = "floor(1.9) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 184: {
                expStr = "floor(-1.9) - (-2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 185: {
                expStr = "ceil(1.2) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 186: {
                expStr = "ceil(1.9) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 187: {
                expStr = "ceil(-1.2) - (-1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 188: {
                expStr = "asinh(0.5) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 189: {
                expStr = "arsinh(0.5) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 190: {
                expStr = "acosh(0.5*sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 191: {
                expStr = "arcosh(0.5*sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 192: {
                expStr = "arccosh(0.5*sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 193: {
                expStr = "atanh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 194: {
                expStr = "arctanh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 195: {
                expStr = "atgh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 196: {
                expStr = "arctgh(1/sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 197: {
                expStr = "actanh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 198: {
                expStr = "arcctanh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 199: {
                expStr = "acoth(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 200: {
                expStr = "arcoth(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 201: {
                expStr = "arccoth(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 202: {
                expStr = "actgh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 203: {
                expStr = "arcctgh(sqrt(5)) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 204: {
                expStr = "asech(1/(0.5*sqrt(5))) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 205: {
                expStr = "arsech(1/(0.5*sqrt(5))) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 206: {
                expStr = "arcsech(1/(0.5*sqrt(5))) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 207: {
                expStr = "acsch(2) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 208: {
                expStr = "arcsch(2) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 209: {
                expStr = "arccsch(2) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 210: {
                expStr = "acosech(2) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 211: {
                expStr = "arcosech(2) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 212: {
                expStr = "arccosech(2) - ln([phi])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 213: {
                expStr = "log(2,8) - 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 214: {
                expStr = "min(2,3) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 215: {
                expStr = "max(2,3) - 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 216: {
                expStr = "mod(10,6) - 4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 217: {
                expStr = "if(1,2,3) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 218: {
                expStr = "if(0,2,3) - 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 219: {
                expStr = "iff(1, 2) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 220: {
                expStr = "iff(0, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Double.NaN;
                if (Double.isNaN(value)) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 221: {
                expStr = "iff(0, 2, 1, 2) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 222: {
                expStr = "iff(0, 2, 1, 2, 3, 4) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 223: {
                expStr = "iff(0, 2, 1, 2, 0, 4) - 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 224: {
                expStr = "iff(0, 2, 0, 2, 1, 4) - 4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(value - reg) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 225: {
                expStr = "iff(0, 2, 0, 2, 0, 4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = Double.NaN;
                if (Double.isNaN(value)) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 226: {
                Argument x = new Argument("x", 2.0);
                expStr = "Sinc(x) - prod(n, 1, 16, cos(x / 2^n) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 227: {
                Argument x = new Argument("x", 2.0);
                expStr = "sinc(x) - prod(n, 1, 100, (1 - x^2 / n^2) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 228: {
                Argument x = new Argument("x", 2.0);
                expStr = "Sa(x) - prod(n, 1, 100, (1 - x^2 / n^2) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 229: {
                Argument n = new Argument("n", 10.0);
                expStr = "Bell(n) - sum(k, 0, n, Stirl2(n,k) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 230: {
                Argument n = new Argument("n", 10.0);
                Argument k = new Argument("k", 5.0);
                expStr = "Worp(n, k) - k! * Stirl2(n+1, k+1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 231: {
                Argument n = new Argument("n", 10.0);
                expStr = "Bern(n,0) - sum(k, 0, n, ( (-1)^k )* ( Worp(n, k) / ( k+1 ) ) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 232: {
                Argument n = new Argument("n", 15.0);
                Argument k = new Argument("k", 5.0);
                expStr = "sum(p, k, n, Stirl1(n, p) * C(p,k)) - Stirl1(n+1, k+1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, k);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 233: {
                expStr = "chi(1, 0, 2) + CHi(1, 0, 2) + Chi(1, 0, 2) + cHi(1, 0, 2) + chi(0, 0, 2) + CHi(0, 0, 2) + Chi(0, 0, 2) + cHi(0, 0, 2) + chi(2, 0, 2) + CHi(2, 0, 2) + Chi(2, 0, 2) + cHi(2, 0, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 8.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 234: {
                expStr = "2 + 10#7 + 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 8.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 235: {
                Argument x = new Argument("x", 5.0);
                expStr = "int( chi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 236: {
                Argument x = new Argument("x", 5.0);
                expStr = "int( CHi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 237: {
                Argument x = new Argument("x", 5.0);
                expStr = "int( Chi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 238: {
                Argument x = new Argument("x", 5.0);
                expStr = "int( cHi(t, 0, x), t, 0, x) - x";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 239: {
                expStr = "ConFrac(1,2,3,5,6,7) - ConPol(1,2,3,4,5,6,7) / ConPol(2,3,4,5,6,7)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.001) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 240: {
                expStr = "min(1,2,3,4,5,-5,343,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -5.0;
                if (MathFunctions.abs(reg - value) < 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 241: {
                expStr = "max(1,2,3,4,5,-5,343,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 343.0;
                if (MathFunctions.abs(reg - value) < 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 242: {
                Argument x = new Argument("x", 0.5);
                expStr = "ConPol(x,x,x,x,x,x) - sum(k, 0, 6, C(6-k, k) * x^(6-2*k))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 243: {
                Argument m = new Argument("m", 5.0);
                Argument n = new Argument("n", 10.0);
                expStr = "Euler(n,m) -  sum(k,0,m, C(n+1,k)*((m+1-k)^n)*(-1)^k)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, n, m);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 244: {
                Argument x = new Argument("x", 2.0);
                Function f = new Function("f", "sin(x)+cos(x)", "x");
                expStr = "diff(f(x), x) - ( f(x+1)-f(x) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 245: {
                Argument x = new Argument("x", 2.0);
                Argument dh = new Argument("h", 1.0);
                Function f = new Function("f", "sin(x)+cos(x)", "x");
                expStr = "diff(f(x), x, h/2) - ( f(x+h/2)-f(x) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, dh);
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 246: {
                Argument x = new Argument("x", 2.0);
                Function f = new Function("f", "sin(x)+cos(x)", "x");
                expStr = "difb(f(x), x) - ( f(x)-f(x-1) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 247: {
                Argument x = new Argument("x", 2.0);
                Argument dh = new Argument("h", 1.0);
                Function f = new Function("f", "sin(x)+cos(x)", "x");
                expStr = "difb(f(x), x, h/2) - ( f(x)-f(x-h/2) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, dh);
                exp[testId].addDefinitions(f);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 248: {
                Function fibr = new Function("fib", "if(n>1, fib(n-1)+fib(n-2), if(n>0,1,0))", "n");
                expStr = "sum(i,0,10,Fib(i) - fib(i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(fibr);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 249: {
                Function luc = new Function("luc", "if(n>1, luc(n-1)+luc(n-2), if(n>0,1,2))", "n");
                expStr = "sum(i,0,10,Luc(i) - luc(i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(luc);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 250: {
                expStr = "sum(i,1,10,harm(i)) - sum(i,1,10,sum(k,1,i,1/k))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 251: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p --> q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 252: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p <-- q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 253: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p <-- q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 254: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p <-> q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 255: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p (+) q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 256: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p /\\ q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 257: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p \\/ q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 258: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p ~& q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 259: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p ~&& q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 260: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p ~/\\ q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 261: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p ~| q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 262: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p ~|| q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 263: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "p ~\\/ q";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 264: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                Constant rr = new Constant("r", 1.0);
                expStr = "(p /\\ q) \\/ (~p) \\/ (~q)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q, rr);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 265: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                Constant rr = new Constant("r", 1.0);
                expStr = "(p --> q) <-> (~q --> ~p)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q, rr);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 266: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                Constant rr = new Constant("r", 1.0);
                expStr = "( (p --> q) /\\ (q --> r) ) --> (p --> r)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q, rr);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 267: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                Constant rr = new Constant("r", 1.0);
                expStr = "( (p \\/ q) /\\ (p --> r) /\\ (q --> r) ) --> r";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q, rr);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 268: {
                Constant p = new Constant("p", 0.0);
                Constant q = new Constant("q", 1.0);
                expStr = "~(p /\\ q) <-> (~p \\/ ~q)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(p, q);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 269: {
                expStr = "gcd(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 270: {
                expStr = "gcd(12,9)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 271: {
                expStr = "gcd(12,6,18)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 6.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 272: {
                expStr = "lcm(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 273: {
                expStr = "lcm(12,9)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 36.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 274: {
                expStr = "lcm(12,6,18)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 36.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 275: {
                expStr = "sum(i,1,10,harm(i)) - sum(i,1,10,Harm(1,i))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 276: {
                expStr = "1/4*2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.5;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 277: {
                expStr = "n1_geq_2(0)";
                Constant c1 = new Constant("c1", 0.26);
                RecursiveArgument z1 = new RecursiveArgument("z1", "z1(n-1)^2+c1", "n");
                z1.addDefinitions(c1);
                z1.addBaseCase(0, 0.0);
                Function n1_geq_2 = new Function("n1_geq_2", "if( z1(k) > 2, k, n1_geq_2(k+1) )", "k");
                n1_geq_2.addDefinitions(z1);
                mXparser.consolePrint(c1.getConstantName() + " = " + c1.getConstantValue() + " ; " + z1.getArgumentName() + " = " + z1.getArgumentExpressionString() + " ; " + n1_geq_2.getFunctionName() + " = " + n1_geq_2.getFunctionExpressionString() + " ; " + expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(n1_geq_2);
                value = exp[testId].calculate();
                reg = 30.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 278: {
                expStr = "n2_geq_2(0)";
                Constant c2 = new Constant("c2", 0.26);
                Function z2 = new Function("z2", "if( n>0, z2(n-1)^2+c2, 0)", "n");
                z2.addDefinitions(c2);
                Function n2_geq_2 = new Function("n2_geq_2", "if( z2(k) > 2, k, n2_geq_2(k+1) )", "k");
                n2_geq_2.addDefinitions(z2);
                mXparser.consolePrint(c2.getConstantName() + " = " + c2.getConstantValue() + " ; " + z2.getFunctionName() + " = " + z2.getFunctionExpressionString() + " ; " + n2_geq_2.getFunctionName() + " = " + n2_geq_2.getFunctionExpressionString() + " ; " + expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(n2_geq_2);
                value = exp[testId].calculate();
                reg = 30.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 279: {
                expStr = "n1_geq_2(0) - n2_geq_2(0)";
                Constant c1 = new Constant("c1", 0.26);
                RecursiveArgument z1 = new RecursiveArgument("z1", "z1(n-1)^2+c1", "n");
                z1.addDefinitions(c1);
                z1.addBaseCase(0, 0.0);
                Function n1_geq_2 = new Function("n1_geq_2", "if( z1(k) > 2, k, n1_geq_2(k+1) )", "k");
                n1_geq_2.addDefinitions(z1);
                Constant c2 = new Constant("c2", 0.26);
                Function z2 = new Function("z2", "if( n>0, z2(n-1)^2+c2, 0)", "n");
                z2.addDefinitions(c2);
                Function n2_geq_2 = new Function("n2_geq_2", "if( z2(k) > 2, k, n2_geq_2(k+1) )", "k");
                n2_geq_2.addDefinitions(z2);
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(n1_geq_2, n2_geq_2);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 280: {
                expStr = "sum(i, 1, 20, IsPrime(i) )";
                Function IsFactor = new Function("IsFactor", "if( a>b, 0, if( n#a = 0, 1, IsFactor(n, a+1, b) ) )", "n", "a", "b");
                Function IsPrime = new Function("IsPrime", "if( n<2, 0, ~IsFactor(n, 2, sqrt(n)) )", "n");
                IsPrime.addDefinitions(IsFactor);
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(IsPrime);
                value = exp[testId].calculate();
                reg = 8.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 281: {
                expStr = "abs( sin(0.5)-s(0.5))+abs( cos(0.7)-c(0.7) )";
                Constant aa = new Constant("a", 1.0E-5);
                Function ss = new Function("s", "if( abs(x) < a, x, 2*s(x/2)*c(x/2) )", "x");
                Function cc = new Function("c", "if( abs(x) < a, 1, c(x/2)^2 - s(x/2)^2 )", "x");
                ss.addDefinitions(aa);
                ss.addDefinitions(cc);
                cc.addDefinitions(aa);
                cc.addDefinitions(ss);
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(ss, cc);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 282: {
                expStr = "f1(1,2)-f2(1,2)";
                Function f1 = new Function("f1", "sin(x)+cos(y)", "x", "y");
                Function f2 = new Function("f2(x,y) = sin(x)+cos(y)", new PrimitiveElement[0]);
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                exp[testId].addDefinitions(f1, f2);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 283: {
                expStr = "a = 5.1, expr = 2*a";
                Constant a1 = new Constant("a = 5.1", new PrimitiveElement[0]);
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression("2*a", new PrimitiveElement[0]);
                exp[testId].addDefinitions(a1);
                value = exp[testId].calculate();
                reg = 10.2;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 284: {
                expStr = "a = sin(pi/2), expr = a";
                Constant a2 = new Constant("a = sin(pi/2)", new PrimitiveElement[0]);
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression("a", new PrimitiveElement[0]);
                exp[testId].addDefinitions(a2);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 285: {
                expStr = "fib(n)= fib(n-1)+fib(n-2), fib(10) = ";
                mXparser.consolePrint(expStr + " ...... ");
                RecursiveArgument fib10 = new RecursiveArgument("fib(n)= fib(n-1)+fib(n-2)", new PrimitiveElement[0]);
                fib10.addBaseCase(0, 0.0);
                fib10.addBaseCase(1, 1.0);
                RegTestExpression.exp[testId] = new Expression("fib(10)", fib10);
                value = exp[testId].calculate();
                reg = 55.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 286: {
                expStr = "fib(n) = if(n>1, fib(n-1) + fib(n-2), if(n = 1, 1, 0)), fib(10) = ";
                mXparser.consolePrint(expStr + " ...... ");
                Function fibb = new Function("fib(n) = if(n>1, fib(n-1) + fib(n-2), if(n = 1, 1, 0))", new PrimitiveElement[0]);
                RegTestExpression.exp[testId] = new Expression("fib(10)", fibb);
                value = exp[testId].calculate();
                reg = 55.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 287: {
                expStr = "5^2 * 7^3 * 11^1 * 67^1 * 49201^1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                String hello = mXparser.numberToAsciiString(exp[testId].calculate());
                String regHello = "Hello";
                if (regHello.equals(hello)) {
                    testResult = true;
                }
                mXparser.consolePrint(hello + " reg ... " + regHello + " --> ");
                break;
            }
            case 288: {
                expStr = "71^1 * 218549^1 * 6195547^1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                String world = mXparser.numberToAsciiString(exp[testId].calculate());
                String regWorld = "World!";
                if (regWorld.equals(world)) {
                    testResult = true;
                }
                mXparser.consolePrint(world + " reg ... " + regWorld + " --> ");
                break;
            }
            case 289: {
                expStr = "min(3,4)+max(-2,-1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 290: {
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 291: {
                mXparser.initPrimesCache(50);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 292: {
                mXparser.initPrimesCache(55);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 293: {
                mXparser.initPrimesCache(97);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 294: {
                mXparser.initPrimesCache(99);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 295: {
                mXparser.initPrimesCache(101);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 296: {
                mXparser.initPrimesCache(999);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 297: {
                mXparser.initPrimesCache(2000);
                expStr = "sum(i, 0, 1000, ispr(i) )";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 298: {
                mXparser.setNoPrimesCache();
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 299: {
                mXparser.initPrimesCache(50);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 300: {
                mXparser.initPrimesCache(55);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 301: {
                mXparser.initPrimesCache(97);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 302: {
                mXparser.initPrimesCache(99);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 303: {
                mXparser.initPrimesCache(101);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 304: {
                mXparser.initPrimesCache(999);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 305: {
                mXparser.initPrimesCache(2000);
                expStr = "Pi(1000)";
                mXparser.consolePrint(expStr + " primes cache size: " + mXparser.getMaxNumInPrimesCache() + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 168.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 306: {
                expStr = "Ei( ln([RS'm]) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 307: {
                expStr = "-e*Ei(-1) - [EG]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 308: {
                expStr = "abs( Ei(-1)  / (0.219383934395520274 * 10^0 ) ) + abs( Ei(-4)  / (0.377935240984890648 * 10^-2 ) ) + abs( Ei(-6)  / (0.360082452162658659 * 10^-3 ) ) + abs( Ei(-8)  / (0.376656228439249018 * 10^-4 ) ) + abs( Ei(-11) / (0.140030030424744178 * 10^-5 ) ) + abs( Ei(-16) / (0.664048724944104278 * 10^-8 ) ) + abs( Ei(-21) / (0.345320126714675627 * 10^-10 ) ) + abs( Ei(-26) / (0.189468588567497824 * 10^-12 ) ) + abs( Ei(-31) / (0.107676703861623826 * 10^-14 ) ) + abs( Ei(-36) / (0.627333900976224159 * 10^-17 ) ) + abs( Ei(-41) / (0.372316677645997772 * 10^-19 ) ) + abs( Ei(-46) / (0.224153175974429975 * 10^-21 ) ) + abs( Ei(-50) / (0.378326402955045902 * 10^-23 ) ) + abs( Ei(1)  / (0.189511781635593676 * 10^1 ) ) + abs( Ei(4)  / (0.196308744700562200 * 10^2 ) ) + abs( Ei(6)  / (0.859897621424392048 * 10^2 ) ) + abs( Ei(8)  / (0.440379899534838269 * 10^3 ) ) + abs( Ei(11) / (0.607140637409861151 * 10^4 ) ) + abs( Ei(16) / (0.595560998670837002 * 10^6 ) ) + abs( Ei(21) / (0.661271863554849213 * 10^8 ) ) + abs( Ei(26) / (0.784294099189818637 * 10^10 ) ) + abs( Ei(31) / (0.969455575968393966 * 10^12 ) ) + abs( Ei(36) / (0.123285207991209769 * 10^15 ) ) + abs( Ei(41) / (0.160066491432450411 * 10^17 ) ) + abs( Ei(46) / (0.211134238864782419 * 10^19 ) ) + abs( Ei(50) / (0.105856368971316910 * 10^21 ) ) - 26";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-12) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 309: {
                expStr = "sum(x; -11; 11; [gam] + ln(abs(x)) + sum(k, 1, 50, x^k / (k*k!)) - Ei(x), 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 310: {
                expStr = "Li(0) + [li2]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 311: {
                mXparser.initPrimesCache(10000000);
                expStr = "Pi(10000000) / Li(10000000)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.001) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 312: {
                Argument x = new Argument("x = 100000000", new PrimitiveElement[0]);
                expStr = "( ( x / ln(x) ) * sum(k, 0, 20, k! / ln(x)^k ) ) / li(x)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 313: {
                Function fefe = new Function("fefe(x)=2*x", new PrimitiveElement[0]);
                expStr = "fefe(2) + fefe(3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, fefe);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(reg - value) < 1.0E-5) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 314: {
                expStr = "add(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 55.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 315: {
                expStr = "multi(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3628800.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 316: {
                expStr = "mean(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 5.5;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 317: {
                expStr = "var(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 9.166666667;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 318: {
                expStr = "std(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.027650354;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 319: {
                expStr = "avg(i, 1, 10, i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 5.5;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 320: {
                expStr = "vari(i, 1, 10, i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 9.166666667;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 321: {
                expStr = "stdi(i, 1, 10, i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.027650354;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 322: {
                expStr = "mini(i, -10, 10, i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -10.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 323: {
                expStr = "maxi(i, -10, 10, i)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(reg - value) < 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 324: {
                expStr = "maxi(i, 1, 100000, [Uni])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 325: {
                expStr = "mini(i, 1, 100000, [Uni])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 326: {
                expStr = "avg(i, 1, 100000, [Uni])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.5;
                if (MathFunctions.abs(reg - value) < 1.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 327: {
                expStr = "vari(i, 1, 100000, [Uni])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.08333333333333333;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 328: {
                expStr = "stdi(i, 1, 100000, [Uni])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = MathFunctions.sqrt(0.08333333333333333);
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 329: {
                expStr = "maxi(i, 1, 100000, [Int1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 330: {
                expStr = "mini(i, 1, 100000, [Int1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -10.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 331: {
                expStr = "avg(i, 1, 100000, [Int1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 1.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 332: {
                expStr = "vari(i, 1, 100000, [Int1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = (MathFunctions.power(21.0, 2.0) - 1.0) / 12.0;
                if (MathFunctions.abs(reg - value) < 1.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 333: {
                expStr = "stdi(i, 1, 100000, [Int1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = MathFunctions.sqrt((MathFunctions.power(21.0, 2.0) - 1.0) / 12.0);
                if (MathFunctions.abs(reg - value) < 0.1) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 334: {
                expStr = "maxi(i, 1, 100000, [Int2])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 100.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 335: {
                expStr = "mini(i, 1, 100000, [Int2])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -100.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 336: {
                expStr = "maxi(i, 1, 1000000, [Int3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 337: {
                expStr = "mini(i, 1, 1000000, [Int3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 338: {
                expStr = "maxi(i, 1, 10000000, [Int4])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 339: {
                expStr = "mini(i, 1, 10000000, [Int4])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -10000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 340: {
                expStr = "maxi(i, 1, 10000000, [Int5])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 100000.0;
                if (MathFunctions.abs(reg - value) <= 10.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 341: {
                expStr = "mini(i, 1, 10000000, [Int5])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -100000.0;
                if (MathFunctions.abs(reg - value) <= 10.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 342: {
                expStr = "maxi(i, 1, 10000000, [Int6])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000000.0;
                if (MathFunctions.abs(reg - value) <= 100.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 343: {
                expStr = "mini(i, 1, 10000000, [Int6])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1000000.0;
                if (MathFunctions.abs(reg - value) <= 100.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 344: {
                expStr = "maxi(i, 1, 10000000, [Int7])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E7;
                if (MathFunctions.abs(reg - value) <= 1000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 345: {
                expStr = "mini(i, 1, 10000000, [Int7])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1.0E7;
                if (MathFunctions.abs(reg - value) <= 1000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 346: {
                expStr = "maxi(i, 1, 10000000, [Int8])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E8;
                if (MathFunctions.abs(reg - value) <= 10000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 347: {
                expStr = "mini(i, 1, 10000000, [Int8])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1.0E8;
                if (MathFunctions.abs(reg - value) <= 10000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 348: {
                expStr = "maxi(i, 1, 10000000, [Int9])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E9;
                if (MathFunctions.abs(reg - value) <= 100000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 349: {
                expStr = "mini(i, 1, 10000000, [Int9])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1.0E9;
                if (MathFunctions.abs(reg - value) <= 100000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 350: {
                expStr = "maxi(i, 1, 10000000, [Int])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.147483647E9;
                if (MathFunctions.abs(reg - value) <= 214748.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 351: {
                expStr = "mini(i, 1, 10000000, [Int])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -2.147483648E9;
                if (MathFunctions.abs(reg - value) <= 214748.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 352: {
                expStr = "maxi(i, 1, 100000, [nat1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 353: {
                expStr = "mini(i, 1, 100000, [nat1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 354: {
                expStr = "maxi(i, 1, 100000, [nat2])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 100.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 355: {
                expStr = "mini(i, 1, 100000, [nat2])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 356: {
                expStr = "maxi(i, 1, 100000, [nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 357: {
                expStr = "mini(i, 1, 100000, [nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 358: {
                expStr = "maxi(i, 1, 1000000, [nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 359: {
                expStr = "mini(i, 1, 1000000, [nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 360: {
                expStr = "maxi(i, 1, 10000000, [nat4])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 361: {
                expStr = "mini(i, 1, 10000000, [nat4])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 362: {
                expStr = "maxi(i, 1, 10000000, [nat5])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 100000.0;
                if (MathFunctions.abs(reg - value) <= 5.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 363: {
                expStr = "mini(i, 1, 10000000, [nat5])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 5.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 364: {
                expStr = "maxi(i, 1, 10000000, [nat6])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000000.0;
                if (MathFunctions.abs(reg - value) <= 50.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 365: {
                expStr = "mini(i, 1, 10000000, [nat6])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 50.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 366: {
                expStr = "maxi(i, 1, 10000000, [nat7])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E7;
                if (MathFunctions.abs(reg - value) <= 500.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 367: {
                expStr = "mini(i, 1, 10000000, [nat7])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 500.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 368: {
                expStr = "maxi(i, 1, 10000000, [nat8])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E8;
                if (MathFunctions.abs(reg - value) <= 5000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 369: {
                expStr = "mini(i, 1, 10000000, [nat8])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 5000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 370: {
                expStr = "maxi(i, 1, 10000000, [nat9])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E9;
                if (MathFunctions.abs(reg - value) <= 50000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 371: {
                expStr = "mini(i, 1, 10000000, [nat9])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 50000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 372: {
                expStr = "maxi(i, 1, 10000000, [nat])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.147483647E9;
                if (MathFunctions.abs(reg - value) <= 112374.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 373: {
                expStr = "mini(i, 1, 10000000, [nat])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 112374.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 374: {
                expStr = "maxi(i, 1, 100000, [Nat1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 375: {
                expStr = "mini(i, 1, 100000, [Nat1])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 376: {
                expStr = "maxi(i, 1, 100000, [Nat2])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 100.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 377: {
                expStr = "mini(i, 1, 100000, [Nat2])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 378: {
                expStr = "maxi(i, 1, 100000, [Nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 379: {
                expStr = "mini(i, 1, 100000, [Nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 380: {
                expStr = "maxi(i, 1, 1000000, [Nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 381: {
                expStr = "mini(i, 1, 1000000, [Nat3])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 382: {
                expStr = "maxi(i, 1, 10000000, [Nat4])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10000.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 383: {
                expStr = "mini(i, 1, 10000000, [Nat4])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) < 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 384: {
                expStr = "maxi(i, 1, 10000000, [Nat5])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 100000.0;
                if (MathFunctions.abs(reg - value) <= 5.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 385: {
                expStr = "mini(i, 1, 10000000, [Nat5])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 5.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 386: {
                expStr = "maxi(i, 1, 10000000, [Nat6])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1000000.0;
                if (MathFunctions.abs(reg - value) <= 50.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 387: {
                expStr = "mini(i, 1, 10000000, [Nat6])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 50.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 388: {
                expStr = "maxi(i, 1, 10000000, [Nat7])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E7;
                if (MathFunctions.abs(reg - value) <= 500.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 389: {
                expStr = "mini(i, 1, 10000000, [Nat7])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 500.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 390: {
                expStr = "maxi(i, 1, 10000000, [Nat8])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E8;
                if (MathFunctions.abs(reg - value) <= 5000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 391: {
                expStr = "mini(i, 1, 10000000, [Nat8])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 5000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 392: {
                expStr = "maxi(i, 1, 10000000, [Nat9])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0E9;
                if (MathFunctions.abs(reg - value) <= 50000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 393: {
                expStr = "mini(i, 1, 10000000, [Nat9])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 50000.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 394: {
                expStr = "maxi(i, 1, 10000000, [Nat])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.147483647E9;
                if (MathFunctions.abs(reg - value) <= 112374.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 395: {
                expStr = "mini(i, 1, 10000000, [Nat])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 112374.0) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 396: {
                expStr = "int( pUni(x, -1, 3), x, -1, 3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 397: {
                Argument x = new Argument("x = rUni(-1, 3)", new PrimitiveElement[0]);
                expStr = "der( cUni(x, -1, 3), x) - pUni(x, -1, 3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 398: {
                Argument x = new Argument("x = rUni(-1, 3)", new PrimitiveElement[0]);
                expStr = "x - qUni( cUni(x, -1, 3), -1, 3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 399: {
                expStr = "mini(i, 1, 1000000, rUni(-1, 3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 400: {
                expStr = "maxi(i, 1, 1000000, rUni(-1, 3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 401: {
                expStr = "mini(i, 1, 1000000, pUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 402: {
                expStr = "maxi(i, 1, 1000000, pUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.25;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 403: {
                expStr = "mini(i, 1, 1000000, cUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 404: {
                expStr = "maxi(i, 1, 1000000, cUni( rUni(-10, 10), -1, 3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 405: {
                Argument x = new Argument("x = rUni(-2,4)", new PrimitiveElement[0]);
                Argument y = new Argument("y = rUni(-2,4)", new PrimitiveElement[0]);
                expStr = "cUni( min(x, y), -1, 3) <= cUni( max(x, y), -1, 3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 406: {
                expStr = "round(2.2, 0)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 407: {
                expStr = "round(2.6, 0)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 408: {
                expStr = "round(2.66, 1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.7;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 409: {
                expStr = "round(2.123456, 5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.12346;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 410: {
                expStr = "avg(i, 1, 1000000, [Nor])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 411: {
                expStr = "stdi(i, 1, 1000000, [Nor])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 412: {
                expStr = "vari(i, 1, 1000000, [Nor])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 413: {
                expStr = "avg(i, 1, 1000000, rNor(1,5) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 414: {
                expStr = "stdi(i, 1, 1000000, rNor(3,3) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 415: {
                expStr = "vari(i, 1, 1000000, rNor(-10, 5) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 25.0;
                if (MathFunctions.abs(reg - value) <= 0.2) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 416: {
                expStr = "int( pNor(x, 0, 1), x, -10, 0.5) - cNor( 0.5, 0, 1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-4) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 417: {
                Argument x = new Argument("x = 0.5", new PrimitiveElement[0]);
                expStr = "der( cNor(x, 1, 2), x) - pNor(x, 1, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 418: {
                expStr = "int( pNor(x, 1, 2), x, 0.5, 1.5) - ( cNor(1.5, 1, 2) - cNor(0.5, 1, 2) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 419: {
                Argument x = new Argument("x = [Nor]", new PrimitiveElement[0]);
                expStr = "pNor(x, 0, 1) - pNor(-x, 0, 1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 420: {
                Argument x = new Argument("x = [Uni]", new PrimitiveElement[0]);
                expStr = "cNor(2-x, 2, 2) - ( 1 - cNor(2+x, 2, 2) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 421: {
                Argument x = new Argument("x = [Nor]", new PrimitiveElement[0]);
                expStr = "qNor(0.5, -4, 5) + 4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 422: {
                Argument x = new Argument("x = rUni(-10,10)", new PrimitiveElement[0]);
                Argument y = new Argument("y = rUni(-10,10)", new PrimitiveElement[0]);
                expStr = "cNor( min(x, y), -1, 3) <= cNor( max(x, y), -1, 3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x, y);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 0.002) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 423: {
                expStr = "290933.27886809571646 - sum(x, 0.01, 10, Ei(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 424: {
                expStr = "-97.065869924036363159 - sum(x, -10, -0.01, Ei(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 425: {
                expStr = "144.17558195220803441 - sum(x, 0, 2, erf(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 426: {
                expStr = "-144.17558195220797757 - sum(x, -2, 0, erf(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 427: {
                expStr = "56.824418047792065067 - sum(x, 0, 2, erfc(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 428: {
                expStr = "345.17558195220811967 - sum(x, -2, 0, erfc(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 429: {
                expStr = "42.417037259662720317 - sum(x, 0, 0.9, erfInv(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 430: {
                expStr = "-42.417037259662699000 - sum(x, -0.9, 0, erfInv(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 431: {
                expStr = "55.303894660741931943 - sum(x, 0.01, 1, erfcInv(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 432: {
                expStr = "-55.303894660741946154 - sum(x, 1, 1.99, erfcInv(x), 0.01)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-8) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 433: {
                expStr = "round(2.125, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.13;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 434: {
                expStr = "round(2.135, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.14;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 435: {
                expStr = "round(2.145, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.15;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 436: {
                expStr = "round(3.125, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.13;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 437: {
                expStr = "round(3.135, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.14;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 438: {
                expStr = "round(3.145, 2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.15;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 439: {
                expStr = "rList(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 440: {
                expStr = "rList(1, 1, 1, 1, 1, 1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 441: {
                expStr = "mini(i, 1, 10000, rList(3, 2, 7, 6, 10, 15, 12) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 442: {
                expStr = "maxi(i, 1, 10000, rList(3, 2, 7, 6, 10, 15, 12) )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 15.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
        }
        if (testResult) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return testResult;
    }

    private static boolean runTest2(int testId) {
        mXparser.consolePrint("[" + testId + "] ");
        boolean testResult = false;
        double value = 0.0;
        double reg = 0.0;
        String expStr = "";
        switch (testId) {
            case 443: {
                mXparser.disableUlpRounding();
                mXparser.setExactComparison();
                expStr = "0.1+0.1+0.1 <> 0.3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 444: {
                mXparser.disableUlpRounding();
                mXparser.setEpsilonComparison();
                expStr = "0.1+0.1+0.1 = 0.3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 445: {
                mXparser.enableUlpRounding();
                mXparser.setExactComparison();
                expStr = "0.1+0.1+0.1 = 0.3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 446: {
                mXparser.setEpsilon(0.5);
                expStr = "2 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 447: {
                mXparser.setEpsilon(0.5);
                expStr = "2.5 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 448: {
                mXparser.setEpsilon(0.5);
                expStr = "2.7 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 449: {
                mXparser.setEpsilon(0.5);
                expStr = "3 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 450: {
                mXparser.setEpsilon(0.5);
                expStr = "3.2 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 451: {
                mXparser.setEpsilon(0.5);
                expStr = "3.5 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 452: {
                mXparser.setEpsilon(0.5);
                expStr = "4 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 453: {
                mXparser.setEpsilon(0.5);
                expStr = "2 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 454: {
                mXparser.setEpsilon(0.5);
                expStr = "2.5 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 455: {
                mXparser.setEpsilon(0.5);
                expStr = "2.7 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 456: {
                mXparser.setEpsilon(0.5);
                expStr = "3 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 457: {
                mXparser.setEpsilon(0.5);
                expStr = "3.2 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 458: {
                mXparser.setEpsilon(0.5);
                expStr = "3.5 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 459: {
                mXparser.setEpsilon(0.5);
                expStr = "4 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 460: {
                mXparser.setEpsilon(0.5);
                expStr = "2 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 461: {
                mXparser.setEpsilon(0.5);
                expStr = "2.5 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 462: {
                mXparser.setEpsilon(0.5);
                expStr = "2.7 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 463: {
                mXparser.setEpsilon(0.5);
                expStr = "3 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 464: {
                mXparser.setEpsilon(0.5);
                expStr = "3.2 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 465: {
                mXparser.setEpsilon(0.5);
                expStr = "3.5 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 466: {
                mXparser.setEpsilon(0.5);
                expStr = "4 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 467: {
                mXparser.setEpsilon(0.5);
                expStr = "2 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 468: {
                mXparser.setEpsilon(0.5);
                expStr = "2.5 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 469: {
                mXparser.setEpsilon(0.5);
                expStr = "2.7 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 470: {
                mXparser.setEpsilon(0.5);
                expStr = "3 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 471: {
                mXparser.setEpsilon(0.5);
                expStr = "3.2 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 472: {
                mXparser.setEpsilon(0.5);
                expStr = "3.5 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 473: {
                mXparser.setEpsilon(0.5);
                expStr = "4 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 474: {
                mXparser.setEpsilon(0.5);
                expStr = "2 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 475: {
                mXparser.setEpsilon(0.5);
                expStr = "2.5 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 476: {
                mXparser.setEpsilon(0.5);
                expStr = "2.7 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 477: {
                mXparser.setEpsilon(0.5);
                expStr = "3 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 478: {
                mXparser.setEpsilon(0.5);
                expStr = "3.2 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 479: {
                mXparser.setEpsilon(0.5);
                expStr = "3.5 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 480: {
                mXparser.setEpsilon(0.5);
                expStr = "4 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 481: {
                mXparser.setEpsilon(0.5);
                expStr = "2 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 482: {
                mXparser.setEpsilon(0.5);
                expStr = "2.5 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 483: {
                mXparser.setEpsilon(0.5);
                expStr = "2.7 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 484: {
                mXparser.setEpsilon(0.5);
                expStr = "3 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 485: {
                mXparser.setEpsilon(0.5);
                expStr = "3.2 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 486: {
                mXparser.setEpsilon(0.5);
                expStr = "3.5 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 487: {
                mXparser.setEpsilon(0.5);
                expStr = "4 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 488: {
                mXparser.setExactComparison();
                expStr = "2 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 489: {
                mXparser.setExactComparison();
                expStr = "3 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 490: {
                mXparser.setExactComparison();
                expStr = "4 < 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 491: {
                mXparser.setExactComparison();
                expStr = "2 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 492: {
                mXparser.setExactComparison();
                expStr = "3 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 493: {
                mXparser.setExactComparison();
                expStr = "4 <= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 494: {
                mXparser.setExactComparison();
                expStr = "2 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 495: {
                mXparser.setExactComparison();
                expStr = "3 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 496: {
                mXparser.setExactComparison();
                expStr = "4 > 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 497: {
                mXparser.setExactComparison();
                expStr = "2 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 498: {
                mXparser.setExactComparison();
                expStr = "3 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 499: {
                mXparser.setExactComparison();
                expStr = "4 >= 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 500: {
                mXparser.setExactComparison();
                expStr = "2 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 501: {
                mXparser.setExactComparison();
                expStr = "3 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 502: {
                mXparser.setExactComparison();
                expStr = "4 = 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 503: {
                mXparser.setExactComparison();
                expStr = "2 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 504: {
                mXparser.setExactComparison();
                expStr = "3 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 505: {
                mXparser.setExactComparison();
                expStr = "4 <> 3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-13) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 506: {
                expStr = "ulp(0.1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.3877787807814457E-17;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 507: {
                mXparser.setExactComparison();
                expStr = "sum(i, 1, 3, 0.1) = 0.3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 508: {
                mXparser.setExactComparison();
                Argument a = new Argument("a", new PrimitiveElement[0]);
                Argument b = new Argument("b", new PrimitiveElement[0]);
                a.setArgumentValue(1.0);
                b.setArgumentValue(5.0);
                expStr = "if(a=6,-b,15)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, a, b);
                value = exp[testId].calculate();
                reg = 15.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 509: {
                mXparser.setExactComparison();
                expStr = "5!^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 14400.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 510: {
                mXparser.setExactComparison();
                expStr = "5!-3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 117.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 511: {
                mXparser.setExactComparison();
                expStr = "5!+3";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 123.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 512: {
                mXparser.setExactComparison();
                expStr = "10/5-(5!)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -118.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 513: {
                mXparser.setExactComparison();
                expStr = "10/5+(5!)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 122.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 514: {
                mXparser.setExactComparison();
                expStr = "10/5+5!";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 122.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 515: {
                mXparser.setExactComparison();
                expStr = "1<-2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 516: {
                mXparser.setExactComparison();
                expStr = "1e1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 10.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-16) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 517: {
                mXparser.setEpsilonComparison();
                expStr = "100*[%]-1000*[%%]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 518: {
                mXparser.setEpsilonComparison();
                expStr = "[Y]-[sept]+( [Y]/[Z]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 519: {
                mXparser.setEpsilonComparison();
                expStr = "[Z]-[sext]+( [Z]/[E]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 520: {
                mXparser.setEpsilonComparison();
                expStr = "[E]-[quint]+( [E]/[P]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 521: {
                mXparser.setEpsilonComparison();
                expStr = "[P]-[quad]+( [P]/[T]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 522: {
                mXparser.setEpsilonComparison();
                expStr = "[T]-[tril]+( [T]/[G]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 523: {
                mXparser.setEpsilonComparison();
                expStr = "[G]-[bil]+( [G]/[M]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 524: {
                mXparser.setEpsilonComparison();
                expStr = "[M]-[mil]+( [M]/[k]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 525: {
                mXparser.setEpsilonComparison();
                expStr = "[k]-[th]+( [k]/[hecto]-10 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 526: {
                mXparser.setEpsilonComparison();
                expStr = "[hecto]-[hund]+( [hecto]/[deca]-10 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 527: {
                mXparser.setEpsilonComparison();
                expStr = "[deca]-[ten]+( [deca]-10 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 528: {
                mXparser.setEpsilonComparison();
                expStr = "[deci]^2-[%]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 529: {
                mXparser.setEpsilonComparison();
                expStr = "[deci]/[centi]-10";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 530: {
                mXparser.setEpsilonComparison();
                expStr = "[centi]/[milli]-10";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 531: {
                mXparser.setEpsilonComparison();
                expStr = "[milli]/[mic]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 532: {
                mXparser.setEpsilonComparison();
                expStr = "[mic]/[n]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 533: {
                mXparser.setEpsilonComparison();
                expStr = "[n]/[p]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 534: {
                mXparser.setEpsilonComparison();
                expStr = "[p]/[f]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 535: {
                mXparser.setEpsilonComparison();
                expStr = "[f]/[a]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 536: {
                mXparser.setEpsilonComparison();
                expStr = "[a]/[z]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 537: {
                mXparser.setEpsilonComparison();
                expStr = "[z]/[y]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 538: {
                mXparser.setEpsilonComparison();
                expStr = "1000*[m]-[km]+(10*[mm]-[cm])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 539: {
                mXparser.setEpsilonComparison();
                expStr = "([inch]-2.54*[cm])+([ft]-0.3048*[m])+([yd]-0.9144*[m])+([mile]-1.609344*[km])+([nmi]-1.852*[km])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 540: {
                mXparser.setEpsilonComparison();
                expStr = "[m2]-100*[cm]*100*[cm]+[m2]-10000*[cm2]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 541: {
                mXparser.setEpsilonComparison();
                expStr = "[cm2]-10*[mm]*10*[mm]+[cm2]-100*[mm2]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 542: {
                mXparser.setEpsilonComparison();
                expStr = "[are]-10*[m]*10*[m]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 543: {
                mXparser.setEpsilonComparison();
                expStr = "[ha]-100*[m]*100*[m]+[ha]-100*[are]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 544: {
                mXparser.setEpsilonComparison();
                expStr = "[acre]-66*[ft]*660*[ft]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 545: {
                mXparser.setEpsilonComparison();
                expStr = "[km2]-100*[ha]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 546: {
                mXparser.setEpsilonComparison();
                expStr = "[cm3]-10*[mm]*10*[mm]*10*[mm]+[cm3]-1000*[mm3]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 547: {
                mXparser.setEpsilonComparison();
                expStr = "[m3]-1000*[l]+[m3]-[m]*[m]*[m]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 548: {
                mXparser.setEpsilonComparison();
                expStr = "[km3]-[bil]*[m3]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 549: {
                mXparser.setEpsilonComparison();
                expStr = "[l]-[th]*[ml]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 550: {
                mXparser.setEpsilonComparison();
                expStr = "[gall]-3.78541178*[l]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 551: {
                mXparser.setEpsilonComparison();
                expStr = "[pint]-473.176473*[ml]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 552: {
                mXparser.setEpsilonComparison();
                expStr = "[min]-60*[s]+[h]-60*[min]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 553: {
                mXparser.setEpsilonComparison();
                expStr = "[day]-24*[h]+[week]-7*[day]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 554: {
                mXparser.setEpsilonComparison();
                expStr = "[yearj]-365.25*[day]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 555: {
                mXparser.setEpsilonComparison();
                expStr = "[kg]-1000*[gr]+[kg]-100*[dag]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 556: {
                mXparser.setEpsilonComparison();
                expStr = "[dag]-10*[gr]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 557: {
                mXparser.setEpsilonComparison();
                expStr = "[gr]-[th]*[mg]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 558: {
                mXparser.setEpsilonComparison();
                expStr = "[t]-1000*[kg]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 559: {
                mXparser.setEpsilonComparison();
                expStr = "[oz]-28.3495231*[gr]+[lb]-453.59237*[gr]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 560: {
                mXparser.setEpsilonComparison();
                expStr = "[b]-1+[kb]/[b]-1024";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 561: {
                mXparser.setEpsilonComparison();
                expStr = "( [Mb]/[kb]-1024 ) + ( [Gb]/[Mb]-1024 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 562: {
                mXparser.setEpsilonComparison();
                expStr = "( [Tb]/[Gb]-1024 ) + ( [Pb]/[Tb]-1024 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 563: {
                mXparser.setEpsilonComparison();
                expStr = "( [Eb]/[Pb]-1024 ) + ( [Zb]/[Eb]-1024 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 564: {
                mXparser.setEpsilonComparison();
                expStr = "[Yb]/[Zb]-1024";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 565: {
                mXparser.setEpsilonComparison();
                expStr = "[B]-8*[b]+[kB]/[B]-1024";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 566: {
                mXparser.setEpsilonComparison();
                expStr = "( [MB]/[kB]-1024 ) + ( [GB]/[MB]-1024 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 567: {
                mXparser.setEpsilonComparison();
                expStr = "( [TB]/[GB]-1024 ) + ( [PB]/[TB]-1024 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 568: {
                mXparser.setEpsilonComparison();
                expStr = "( [EB]/[PB]-1024 ) + ( [ZB]/[EB]-1024 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 569: {
                mXparser.setEpsilonComparison();
                expStr = "[YB]/[ZB]-1024";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 570: {
                mXparser.setEpsilonComparison();
                expStr = "[J] - ( [kg]*[m2] ) / ( [s]*[s] )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 571: {
                mXparser.setEpsilonComparison();
                expStr = "[eV]-1.60217662*[a]*[deci]*[J]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 572: {
                mXparser.setEpsilonComparison();
                expStr = "( [keV]/[eV]-1000 ) + ( [MeV]/[keV]-1000 ) + ( [GeV]/[MeV]-1000 ) + ( [TeV]/[GeV]-1000 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 573: {
                mXparser.setEpsilonComparison();
                expStr = "[m/s] - ([m]/[s])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 574: {
                mXparser.setEpsilonComparison();
                expStr = "[km/h] - ([km]/[h])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 575: {
                mXparser.setEpsilonComparison();
                expStr = "[mi/h] - ([mile]/[h])";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 576: {
                mXparser.setEpsilonComparison();
                expStr = "[knot] - 0.514444444*[m/s]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 577: {
                mXparser.setEpsilonComparison();
                expStr = "[m/s2]-[m]/([s]^2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 578: {
                mXparser.setEpsilonComparison();
                expStr = "[km/h2]-[km]/[h]^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 579: {
                mXparser.setEpsilonComparison();
                expStr = "[mi/h2]-[mile]/[h]^2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 580: {
                mXparser.setEpsilonComparison();
                expStr = "2*pi*[rad]-360*[deg]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 581: {
                mXparser.setEpsilonComparison();
                expStr = "( [deg]/[']-60 ) + ( [']/[''] - 60 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 582: {
                mXparser.setEpsilonComparison();
                expStr = "[c] - 299792458*[m]/[s]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 583: {
                mXparser.setEpsilonComparison();
                expStr = "[hP] - [h-]*2*pi";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 584: {
                mXparser.setEpsilonComparison();
                expStr = "( [lP] - 1.616229*[y]*[p]*10*[m]) + ( [mP] - 2.176470*[n]*10*[kg] ) + ( [tP] - 5.39116*[y]*[z]*10*[s] )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 585: {
                mXparser.setEpsilonComparison();
                expStr = "[ly]-[c]*[yearj]";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 586: {
                mXparser.setEpsilonComparison();
                expStr = "[pc]/(3.08567758*[P]*10*[m])-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-7) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 587: {
                mXparser.setEpsilonComparison();
                expStr = "[kpc]/[pc]-1000";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 588: {
                mXparser.setEpsilonComparison();
                expStr = "( [Earth-R-eq]-[Earth-R-po] ) / ( 6378.1370*[km]-6356.7523*[km] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-10) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 589: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Earth-M] ) / [Earth-R]^2 ) / [g] - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 590: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Solar-M] ) / [Solar-R]^2 ) / ( 28.2*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 591: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Mercury-M] ) / [Mercury-R]^2 ) / ( 0.38*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 592: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Venus-M] ) / [Venus-R]^2 ) / ( 0.904*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 593: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Moon-M] ) / [Moon-R]^2 ) / ( 0.1654*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 594: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Mars-M] ) / [Mars-R]^2 ) / ( 0.376*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 595: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Jupiter-M] ) / [Jupiter-R]^2 ) / ( 2.527876492*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.1) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 596: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Saturn-M] ) / [Saturn-R]^2 ) / ( 1.065*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.1) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 597: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Uranus-M] ) / [Uranus-R]^2 ) / ( 0.886*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.1) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 598: {
                mXparser.setEpsilonComparison();
                expStr = "( ( [G.] * [Neptune-M] ) / [Neptune-R]^2 ) / ( 1.14*[g] ) - 1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 599: {
                mXparser.setEpsilonComparison();
                expStr = "[Earth-D]/[au]-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 600: {
                mXparser.setEpsilonComparison();
                expStr = "[Mercury-D] / ( 57909050*[km] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 601: {
                mXparser.setEpsilonComparison();
                expStr = "[Venus-D] / ( 108208000*[km] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 602: {
                mXparser.setEpsilonComparison();
                expStr = "[Mars-D] / ( 1.523679*[au] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 603: {
                mXparser.setEpsilonComparison();
                expStr = "[Jupiter-D] / ( 5.20260*[au] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 604: {
                mXparser.setEpsilonComparison();
                expStr = "[Saturn-D] / ( 1.429*[bil]*[km] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 605: {
                mXparser.setEpsilonComparison();
                expStr = "[Uranus-D] / ( 19.2184*[au] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 606: {
                mXparser.setEpsilonComparison();
                expStr = "[Neptune-D] / ( 30.110387*[au] )-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 0.01) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 607: {
                mXparser.setEpsilonComparison();
                expStr = "@~100";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -101.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 608: {
                mXparser.setEpsilonComparison();
                expStr = "-100 @^ 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -98.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 609: {
                mXparser.setEpsilonComparison();
                expStr = "-100 @| 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -98.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 610: {
                mXparser.setEpsilonComparison();
                expStr = "-100 @& 2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 611: {
                mXparser.setEpsilonComparison();
                expStr = "-100 @>> 4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -7.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 612: {
                mXparser.setEpsilonComparison();
                expStr = "-100 @<< 4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = -1600.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 613: {
                mXparser.setEpsilonComparison();
                expStr = "pi+1.23e-10";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 3.141592653712793;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 614: {
                mXparser.setEpsilonComparison();
                expStr = "sin(pi+1.23e-10)+e^1.1e1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = MathFunctions.sin(3.141592653712793) + MathFunctions.power(Math.E, 11.0);
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 615: {
                mXparser.setEpsilonComparison();
                expStr = "2e-2+2E+2+3.1e4";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 31200.02;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 616: {
                mXparser.setEpsilonComparison();
                expStr = "123.34344e-16*0.00001E-2";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.2334344E-21;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 617: {
                mXparser.setEpsilonComparison();
                expStr = "-123.34344e-16*(-0.00001E-2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 1.2334344E-21;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 618: {
                mXparser.setEpsilonComparison();
                Function ff = new Function("ff", new FunExt());
                expStr = "5*6-ff(5,6)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, ff);
                value = exp[testId].calculate();
                reg = 0.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-9) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 619: {
                mXparser.setEpsilonComparison();
                expStr = "solve(2*x-4, x, -10, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                reg = 2.0;
                if (MathFunctions.abs(reg - value) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 620: {
                mXparser.setEpsilonComparison();
                Argument x = new Argument("x=0", new PrimitiveElement[0]);
                expStr = "solve( der(sin(x), x), x, 0, pi )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, x);
                value = exp[testId].calculate();
                reg = 1.5707963267948966;
                if (MathFunctions.abs(reg - value) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + reg + " --> ");
                break;
            }
            case 621: {
                mXparser.setEpsilonComparison();
                expStr = "solve( sin(x), x, -pi-1, 1 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestExpression.exp[testId] = new Expression(expStr, new PrimitiveElement[0]);
                value = exp[testId].calculate();
                if (MathFunctions.abs(-Math.PI - value) <= 1.0E-6 || MathFunctions.abs(0.0 - value) <= 1.0E-6) {
                    testResult = true;
                }
                mXparser.consolePrint(value + " reg ... " + 0 + " or " + Math.PI + " --> ");
            }
        }
        if (testResult) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return testResult;
    }

    public static int start() {
        int numberOfTests = 621;
        int nOk = 0;
        int nError = 0;
        exp = new Expression[numberOfTests + 1];
        boolean[] tests = new boolean[numberOfTests + 1];
        long start = System.currentTimeMillis();
        for (int testId = 0; testId <= numberOfTests; ++testId) {
            mXparser.setEpsilonComparison();
            mXparser.setDefaultEpsilon();
            mXparser.enableUlpRounding();
            boolean test = testId < 443 ? RegTestExpression.runTest1(testId) : RegTestExpression.runTest2(testId);
            tests[testId] = test;
            if (test) {
                ++nOk;
            } else {
                ++nError;
            }
            if (!exp[testId].checkSyntax()) {
                mXparser.consolePrintln(exp[testId].getErrorMessage());
            }
            mXparser.consolePrintln(", time: " + exp[testId].getComputingTime() + " s.");
        }
        long end = System.currentTimeMillis();
        mXparser.consolePrintln("OK : " + nOk + ", ERRORs: " + nError + ", total time: " + (double)(end - start) / 1000.0 + " s.");
        for (int testId = 0; testId <= numberOfTests; ++testId) {
            if (tests[testId]) continue;
            mXparser.consolePrintln("ERROR: " + testId);
            mXparser.consolePrintln(exp[testId].getErrorMessage());
        }
        return nError;
    }

    public static void main(String[] args) {
        RegTestExpression.start();
    }
}

