/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.ldtteam.structurize.util.BlockInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class BlueprintBlockInfoTransformHandler {
    private static BlueprintBlockInfoTransformHandler ourInstance = new BlueprintBlockInfoTransformHandler();
    private Map<Predicate<BlockInfo>, Function<BlockInfo, BlockInfo>> blockInfoTransformHandler = new HashMap<Predicate<BlockInfo>, Function<BlockInfo, BlockInfo>>();

    public static BlueprintBlockInfoTransformHandler getInstance() {
        return ourInstance;
    }

    private BlueprintBlockInfoTransformHandler() {
    }

    public void AddTransformHandler(@NotNull Predicate<BlockInfo> transformPredicate, @NotNull Function<BlockInfo, BlockInfo> transformHandler) {
        this.blockInfoTransformHandler.put(transformPredicate, transformHandler);
    }

    public BlockInfo Transform(@NotNull BlockInfo blockInfo) {
        return this.getTransformHandler(blockInfo).apply(blockInfo);
    }

    private Function<BlockInfo, BlockInfo> getTransformHandler(@NotNull BlockInfo blockInfo) {
        return this.blockInfoTransformHandler.keySet().stream().filter(p -> p.test(blockInfo)).findFirst().map(p -> this.blockInfoTransformHandler.get(p)).orElse(Function.identity());
    }
}

