/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.interfaces;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public interface IBlueprintDataProvider {
    public static final String TAG_SCHEMATIC_NAME = "schematicName";
    public static final String TAG_CORNER_ONE = "corner1";
    public static final String TAG_CORNER_TWO = "corner2";
    public static final String TAG_TAG_POS = "tagPos";
    public static final String TAG_TAG_NAME = "tagName";
    public static final String TAG_TAG_NAME_LIST = "tagNameList";
    public static final String TAG_POS_TAG_MAP = "posTagMap";
    public static final String TAG_BLUEPRINTDATA = "blueprintDataProvider";

    public String getSchematicName();

    public void setSchematicName(String var1);

    public Map<BlockPos, List<String>> getPositionedTags();

    public void setPositionedTags(Map<BlockPos, List<String>> var1);

    public Tuple<BlockPos, BlockPos> getCornerPositions();

    public void setCorners(BlockPos var1, BlockPos var2);

    default public void writeSchematicDataToNBT(CompoundNBT originalCompound) {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a(TAG_SCHEMATIC_NAME, this.getSchematicName());
        BlockPosUtil.writeToNBT(compoundNBT, TAG_CORNER_ONE, (BlockPos)this.getCornerPositions().func_76341_a());
        BlockPosUtil.writeToNBT(compoundNBT, TAG_CORNER_TWO, (BlockPos)this.getCornerPositions().func_76340_b());
        IBlueprintDataProvider.writeMapToCompound(compoundNBT, this.getPositionedTags());
        originalCompound.func_218657_a(TAG_BLUEPRINTDATA, (INBT)compoundNBT);
    }

    public static void writeMapToCompound(CompoundNBT compoundNBT, Map<BlockPos, List<String>> tagPosMap) {
        ListNBT tagPosList = new ListNBT();
        for (Map.Entry<BlockPos, List<String>> entry : tagPosMap.entrySet()) {
            CompoundNBT posTagCompound = new CompoundNBT();
            BlockPosUtil.writeToNBT(posTagCompound, TAG_TAG_POS, entry.getKey());
            ListNBT tagList = new ListNBT();
            for (String tag : entry.getValue()) {
                CompoundNBT tagCompound = new CompoundNBT();
                tagCompound.func_74778_a(TAG_TAG_NAME, tag);
                tagList.add((Object)tagCompound);
            }
            posTagCompound.func_218657_a(TAG_TAG_NAME_LIST, (INBT)tagList);
            tagPosList.add((Object)posTagCompound);
        }
        compoundNBT.func_218657_a(TAG_POS_TAG_MAP, (INBT)tagPosList);
    }

    default public void readSchematicDataFromNBT(CompoundNBT originalCompound) {
        if (!originalCompound.func_74764_b(TAG_BLUEPRINTDATA)) {
            return;
        }
        CompoundNBT compoundNBT = originalCompound.func_74775_l(TAG_BLUEPRINTDATA);
        this.setSchematicName(compoundNBT.func_74779_i(TAG_SCHEMATIC_NAME));
        BlockPos corner1 = BlockPosUtil.readFromNBT(compoundNBT, TAG_CORNER_ONE);
        BlockPos corner2 = BlockPosUtil.readFromNBT(compoundNBT, TAG_CORNER_TWO);
        this.setCorners(corner1, corner2);
        this.setPositionedTags(IBlueprintDataProvider.readTagPosMapFrom(compoundNBT));
    }

    public static Map<BlockPos, List<String>> readTagPosMapFrom(CompoundNBT compoundNBT) {
        HashMap<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
        if (!compoundNBT.func_74764_b(TAG_POS_TAG_MAP)) {
            return tagPosMap;
        }
        ListNBT tagPosMapNBT = compoundNBT.func_150295_c(TAG_POS_TAG_MAP, 10);
        for (INBT tagPosMapEntry : tagPosMapNBT) {
            if (!(tagPosMapEntry instanceof CompoundNBT)) continue;
            CompoundNBT entry = (CompoundNBT)tagPosMapEntry;
            BlockPos tagPos = BlockPosUtil.readFromNBT(entry, TAG_TAG_POS);
            HashSet<String> tagList = new HashSet<String>();
            ListNBT tagListNbt = entry.func_150295_c(TAG_TAG_NAME_LIST, 10);
            for (INBT tagEntryNBT : tagListNbt) {
                if (!(tagEntryNBT instanceof CompoundNBT)) continue;
                CompoundNBT tagEntry = (CompoundNBT)tagEntryNBT;
                tagList.add(tagEntry.func_74779_i(TAG_TAG_NAME));
            }
            tagPosMap.put(tagPos, new ArrayList(tagList));
        }
        return tagPosMap;
    }

    default public void removeTag(BlockPos pos, String tag) {
        Map<BlockPos, List<String>> data = this.getPositionedTags();
        if (data.containsKey(pos)) {
            data.get(pos).remove(tag);
            if (data.get(pos).isEmpty()) {
                data.remove(pos);
            }
        }
        this.setPositionedTags(data);
    }

    default public void addTag(BlockPos pos, String tag) {
        Map<BlockPos, List<String>> data = this.getPositionedTags();
        if (data.containsKey(pos)) {
            data.get(pos).add(tag);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(tag);
            data.put(pos, list);
        }
        this.setPositionedTags(data);
    }

    default public Map<BlockPos, List<String>> getWorldTagPosMap() {
        HashMap<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
        for (Map.Entry<BlockPos, List<String>> entry : this.getPositionedTags().entrySet()) {
            tagPosMap.put(entry.getKey().func_177971_a((Vec3i)this.getTilePos()), entry.getValue());
        }
        return tagPosMap;
    }

    default public BlockPos getRealWorldPos(BlockPos relativePos) {
        return relativePos.func_177971_a((Vec3i)this.getTilePos());
    }

    public BlockPos getTilePos();

    public SUpdateTileEntityPacket getUpdatePacket();
}

