/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.config;

import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.config.CommonConfiguration;
import com.ldtteam.structurize.config.ServerConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    private final ModConfig common;
    private final CommonConfiguration commonConfig;
    private final ModConfig client;
    private final ClientConfiguration clientConfig;
    private final ModConfig server;
    private final ServerConfiguration serverConfig;

    public Configuration(ModContainer modContainer) {
        Pair com = new ForgeConfigSpec.Builder().configure(CommonConfiguration::new);
        Pair cli = new ForgeConfigSpec.Builder().configure(ClientConfiguration::new);
        Pair ser = new ForgeConfigSpec.Builder().configure(ServerConfiguration::new);
        this.common = new ModConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)com.getRight(), modContainer);
        this.client = new ModConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)cli.getRight(), modContainer);
        this.server = new ModConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)ser.getRight(), modContainer);
        this.commonConfig = (CommonConfiguration)com.getLeft();
        this.clientConfig = (ClientConfiguration)cli.getLeft();
        this.serverConfig = (ServerConfiguration)ser.getLeft();
        modContainer.addConfig(this.common);
        modContainer.addConfig(this.client);
        modContainer.addConfig(this.server);
    }

    public CommonConfiguration getCommon() {
        return this.commonConfig;
    }

    public ClientConfiguration getClient() {
        return this.clientConfig;
    }

    public ServerConfiguration getServer() {
        return this.serverConfig;
    }
}

