/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.floating_carpets;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ldtteam.datagenerators.lang.LangJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockFloatingCarpet;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.DyeColor;
import org.jetbrains.annotations.NotNull;

public class FloatingCarpetsLangEntryProvider
implements IDataProvider {
    private final DataGenerator generator;

    public FloatingCarpetsLangEntryProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        File langFile = inputPath.resolve("assets/structurize/lang/en_us.json").toFile();
        FileReader reader = new FileReader(langFile);
        LangJson langJson = new LangJson();
        langJson.deserialize(new JsonParser().parse((Reader)reader));
        for (BlockFloatingCarpet floatingCarpet : ModBlocks.getFloatingCarpets()) {
            if (floatingCarpet.getRegistryName() == null) continue;
            String reference = "block.structurize." + floatingCarpet.getRegistryName().func_110623_a();
            String value = this.dyeToString(floatingCarpet.getColor()) + " Floating Carpet";
            langJson.getLang().put(reference, value);
        }
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSONLang, (DirectoryCache)cache, (JsonElement)langJson.serialize(), (Path)langFile.toPath());
    }

    public String dyeToString(DyeColor dyeColor) {
        switch (dyeColor) {
            case RED: {
                return "Red";
            }
            case BLUE: {
                return "Blue";
            }
            case CYAN: {
                return "Cyan";
            }
            case GRAY: {
                return "Gray";
            }
            case LIME: {
                return "Lime";
            }
            case PINK: {
                return "Pink";
            }
            case BLACK: {
                return "Black";
            }
            case BROWN: {
                return "Brown";
            }
            case GREEN: {
                return "Green";
            }
            case WHITE: {
                return "White";
            }
            case ORANGE: {
                return "Orange";
            }
            case PURPLE: {
                return "Purple";
            }
            case YELLOW: {
                return "Yellow";
            }
            case MAGENTA: {
                return "Magenta";
            }
            case LIGHT_BLUE: {
                return "Light Blue";
            }
            case LIGHT_GRAY: {
                return "Light Gray";
            }
        }
        return "Null";
    }

    @NotNull
    public String func_200397_b() {
        return "Floating Carpets Lang Provider";
    }
}

