/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation.shingles;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.generation.DataGeneratorConstants;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.state.properties.StairsShape;
import org.jetbrains.annotations.NotNull;

public class ShinglesBlockModelProvider
implements IDataProvider {
    private final DataGenerator generator;

    public ShinglesBlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        Path inputPath = this.generator.func_200389_a().stream().findFirst().orElse(null);
        if (inputPath == null) {
            return;
        }
        for (BlockShingle shingle : ModBlocks.getShingles()) {
            for (StairsShape shapeValue : StairsBlock.field_176310_M.func_177700_c()) {
                String shapeType = BlockShingle.getTypeFromShape(shapeValue);
                File modelFile = inputPath.resolve("assets/structurize/models/block/shingle/shingle_" + shapeType + ".json").toFile();
                FileReader reader = new FileReader(modelFile);
                BlockModelJson modelJson = new BlockModelJson();
                modelJson.deserialize(new JsonParser().parse((Reader)reader));
                modelJson.setAmbientOcclusion(false);
                HashMap<String, String> textures = modelJson.getTextures();
                if (textures == null) {
                    textures = new HashMap<String, String>();
                }
                textures.put("1", shingle.getFaceType().getTexture(1));
                textures.put("2", shingle.getFaceType().getTexture(2));
                textures.put("3", shingle.getFaceType().getTexture(3));
                textures.put("particle", shingle.getFaceType().getTexture(1));
                textures.put("plank", shingle.getWoodType().getTextureLocation());
                modelJson.setTextures(textures);
                String name = shingle.getFaceType().func_176610_l() + "_shingle.json";
                Path saveFile = this.generator.func_200391_b().resolve("assets/structurize/models/block/shingle/" + shapeType + "/" + shingle.getWoodType().func_176610_l()).resolve(name);
                IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)saveFile);
            }
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Shingles Block Model Provider";
    }
}

